/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import java.io.FileOutputStream;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public final class KeyStoreGenerator {
    static String symAlg = "AES";
    static int keySize = 128;
    static String keyStoreName = "defaultStore.keystore";
    static String storePass = "changeit";
    static String alias = "myKey";
    static String storeType = "pkcs12";

    private KeyStoreGenerator() {
        throw new InstantiationError("Must not instantiate this class");
    }

    public static void main(String[] args) {
        int i = 0;
        String arg = null;
        while (i < args.length && args[i].startsWith("-")) {
            if ((arg = args[i++]).equalsIgnoreCase("--alg")) {
                symAlg = args[i++];
                continue;
            }
            if (arg.equalsIgnoreCase("--size")) {
                keySize = Integer.parseInt(args[i++]);
                continue;
            }
            if (arg.equalsIgnoreCase("--storeName")) {
                keyStoreName = args[i++];
                continue;
            }
            if (arg.equalsIgnoreCase("--storeType")) {
                storeType = args[i++];
                continue;
            }
            if (arg.equalsIgnoreCase("--storePass")) {
                storePass = args[i++];
                continue;
            }
            if (arg.equalsIgnoreCase("--alias")) {
                alias = args[i++];
                continue;
            }
            KeyStoreGenerator.help();
            return;
        }
        System.out.printf("Creating file '%s' using algorithm '%s' size '%d'\n", keyStoreName, symAlg, keySize);
        try (FileOutputStream stream = new FileOutputStream(keyStoreName);){
            SecretKey key = KeyStoreGenerator.createSecretKey();
            KeyStore store = KeyStore.getInstance(storeType);
            store.load(null, null);
            store.setKeyEntry(alias, key, storePass.toCharArray(), null);
            store.store(stream, storePass.toCharArray());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Finished keystore creation");
    }

    protected static void help() {
        System.out.println("KeyStoreGenerator [-help] [--alg algorithm] [--size size] [--storeName name] [--storeType type (e.g. JKS)] [--storePass password] [--alias alias]");
    }

    public static SecretKey createSecretKey() throws Exception {
        return KeyStoreGenerator.createSecretKey(symAlg, keySize);
    }

    public static SecretKey createSecretKey(String sym_alg, int key_size) throws NoSuchAlgorithmException {
        KeyGenerator keyGen = KeyGenerator.getInstance(sym_alg);
        keyGen.init(key_size);
        return keyGen.generateKey();
    }

    private static String getAlgorithm(String s2) {
        int index = s2.indexOf(47);
        if (index == -1) {
            return s2;
        }
        return s2.substring(0, index);
    }
}

