/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.jmx;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.TreeMap;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.blocks.MethodCall;
import org.jgroups.jmx.ResourceDMBean;
import org.jgroups.util.Ref;
import org.jgroups.util.Util;

public class ReflectUtils {
    public static void handleAttributeAccess(Map<String, String> map, String attrs, Object target) {
        List<String> list;
        if (target == null) {
            return;
        }
        List<String> list2 = list = attrs != null ? Util.parseStringList(attrs, ",") : null;
        if (list != null) {
            Iterator<String> it = list.iterator();
            while (it.hasNext()) {
                String tmp = it.next();
                int index = tmp.indexOf(61);
                if (index <= -1) continue;
                it.remove();
                String attrname = tmp.substring(0, index);
                String attrvalue = tmp.substring(index + 1);
                try {
                    ReflectUtils.handleAttrWrite(target, attrname, attrvalue);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.format("failed writing: %s", e));
                }
            }
        }
        Map<String, Map<String, Object>> tmp_stats = ReflectUtils.dumpSelectedAttributes(target, list);
        ReflectUtils.convert(tmp_stats, map);
    }

    public static Map<String, Map<String, Object>> dumpSelectedAttributes(Object target, List<String> attrs) {
        HashMap<String, Map<String, Object>> retval = new HashMap<String, Map<String, Object>>();
        TreeMap<String, Object> tmp = new TreeMap<String, Object>();
        ReflectUtils.dumpStats(target, tmp);
        if (attrs != null && !attrs.isEmpty()) {
            Iterator it = tmp.keySet().iterator();
            while (it.hasNext()) {
                String attrname = (String)it.next();
                boolean found = false;
                for (String attr : attrs) {
                    if (!attrname.startsWith(attr)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                it.remove();
            }
        }
        String pname = target.getClass().getSimpleName();
        retval.put(pname, tmp);
        return retval;
    }

    public static void dumpStats(Object obj, Map<String, Object> map) {
        ResourceDMBean.dumpStats(obj, map);
        Util.forAllComponents(obj, (o, prefix) -> ResourceDMBean.dumpStats(o, prefix, map));
    }

    public static String listOperations(Class<?> clazz) {
        Method[] methods;
        if (clazz == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(clazz.getSimpleName()).append(":\n");
        for (Method m4 : methods = Util.getAllDeclaredMethodsWithAnnotations(clazz, ManagedOperation.class)) {
            sb.append("  ").append(ReflectUtils.methodToString(m4)).append("\n");
        }
        Util.forAllComponentTypes(clazz, (cl, prefix) -> {
            Method[] meths;
            for (Method m4 : meths = Util.getAllDeclaredMethodsWithAnnotations(cl, ManagedOperation.class)) {
                sb.append("  ").append((String)prefix).append(".").append(ReflectUtils.methodToString(m4)).append("\n");
            }
        });
        return sb.toString();
    }

    public static void invokeOperation(Map<String, String> map, String operation, Object target) throws Exception {
        if (target == null) {
            throw new IllegalArgumentException("target object must not be null");
        }
        int args_index = operation.indexOf(91);
        String method_name = args_index != -1 ? operation.substring(0, args_index).trim() : operation.trim();
        String[] args = null;
        if (args_index != -1) {
            int end_index = operation.indexOf(93);
            if (end_index == -1) {
                throw new IllegalArgumentException("] not found");
            }
            List<String> str_args = Util.parseCommaDelimitedStrings(operation.substring(args_index + 1, end_index));
            Object[] strings = str_args.toArray();
            args = new String[strings.length];
            for (int i = 0; i < strings.length; ++i) {
                args[i] = (String)strings[i];
            }
        }
        Ref<Object> t2 = new Ref<Object>(target);
        Ref<Method> method = new Ref<Method>(Util.findMethod(target.getClass(), method_name, args));
        if (!method.isSet()) {
            String[] arguments = args;
            Util.forAllComponents(target, (o, prefix) -> {
                if (!method.isSet() && method_name.startsWith(prefix + ".")) {
                    String m4 = method_name.substring(prefix.length() + 1);
                    try {
                        Method meth = Util.findMethod(o.getClass(), m4, arguments);
                        if (meth != null) {
                            method.set(meth);
                            t2.set(o);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        if (!method.isSet()) {
            throw new IllegalArgumentException(String.format("method %s not found in %s", method_name, target.getClass().getSimpleName()));
        }
        Object retval = ReflectUtils.invoke(method.get(), t2.get(), args);
        if (retval != null) {
            map.put(target.getClass().getSimpleName() + "." + method_name, retval.toString());
        }
    }

    public static Object invoke(Method method, Object target, String[] args) throws Exception {
        MethodCall call = new MethodCall(method, new Object[0]);
        Object[] converted_args = null;
        if (args != null) {
            converted_args = new Object[args.length];
            Class<?>[] types = method.getParameterTypes();
            for (int i = 0; i < args.length; ++i) {
                converted_args[i] = Util.convert(args[i], types[i]);
            }
        }
        return call.invoke(target, converted_args);
    }

    protected static void convert(Map<String, Map<String, Object>> in, Map<String, String> out) {
        if (in != null) {
            in.entrySet().stream().filter(e -> e.getValue() != null).forEach(e -> out.put((String)e.getKey(), ((Map)e.getValue()).toString()));
        }
    }

    public static void handleAttrWrite(Object target, String attr_name, String attr_value) throws Exception {
        Ref<Object> ex = new Ref<Object>(null);
        try {
            ReflectUtils._handleAttrWrite(target, attr_name, attr_value);
            return;
        }
        catch (Exception e) {
            ex.set(e);
            Util.forAllComponents(target, (comp, prefix) -> {
                if (attr_name.startsWith(prefix + ".")) {
                    String actual_attrname = attr_name.substring(prefix.length() + 1);
                    try {
                        ReflectUtils._handleAttrWrite(comp, actual_attrname, attr_value);
                        ex.set(null);
                    }
                    catch (Exception e) {
                        ex.set(e);
                    }
                }
            });
            if (ex.isSet()) {
                throw (Exception)ex.get();
            }
            return;
        }
    }

    public static void _handleAttrWrite(Object target, String attr_name, String attr_value) {
        ResourceDMBean.Accessor setter;
        Object value;
        Exception e1 = null;
        Exception e2 = null;
        Field field = Util.getField(target.getClass(), attr_name);
        if (field != null && (value = Util.convert(attr_value, field.getType())) != null) {
            try {
                Util.setField(field, target, value);
                return;
            }
            catch (Exception ex) {
                e1 = ex;
            }
        }
        if ((setter = ResourceDMBean.findSetter(target, attr_name)) != null) {
            try {
                Class<?> type = setter instanceof ResourceDMBean.FieldAccessor ? ((ResourceDMBean.FieldAccessor)setter).getField().getType() : (setter instanceof ResourceDMBean.MethodAccessor ? ((ResourceDMBean.MethodAccessor)setter).getMethod().getParameterTypes()[0] : null);
                Object converted_value = Util.convert(attr_value, type);
                setter.invoke(converted_value);
                return;
            }
            catch (Exception ex) {
                e2 = ex;
            }
        }
        String s2 = String.format("failed setting %s to %s: %s", attr_name, attr_value, e1 != null || e2 != null ? e1 + " " + e2 : "field or setter not found");
        throw new IllegalArgumentException(s2);
    }

    protected static String methodToString(Method m4) {
        StringBuilder sb = new StringBuilder(m4.getName());
        sb.append('(');
        StringJoiner sj = new StringJoiner(",");
        for (Class<?> parameterType : m4.getParameterTypes()) {
            sj.add(parameterType.getTypeName());
        }
        sb.append(sj);
        sb.append(')');
        return sb.toString();
    }
}

