/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.relay;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.protocols.relay.SiteAddress;
import org.jgroups.util.AsciiString;
import org.jgroups.util.Bits;
import org.jgroups.util.ExtendedUUID;
import org.jgroups.util.NameCache;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

public class SiteUUID
extends ExtendedUUID
implements SiteAddress {
    protected String site;
    protected String name;

    public SiteUUID() {
    }

    public SiteUUID(long mostSigBits, long leastSigBits, String name, String site) {
        super(mostSigBits, leastSigBits);
        this.name = name;
        this.site = site;
    }

    @Deprecated(since="5.2.15")
    public SiteUUID(long mostSigBits, long leastSigBits, byte[] name, byte[] site) {
        this(mostSigBits, leastSigBits, name != null ? new String(name) : null, site != null ? new String(site) : null);
    }

    public SiteUUID(UUID uuid, String name, String site) {
        this(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits(), name, site);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getSite() {
        return this.site;
    }

    @Override
    public Supplier<? extends UUID> create() {
        return SiteUUID::new;
    }

    @Override
    public UUID copy() {
        return new SiteUUID(this.mostSigBits, this.leastSigBits, this.name, this.site);
    }

    @Override
    public String toString() {
        return this.print(false);
    }

    @Override
    public int hashCode() {
        int retval = super.hashCode();
        return this.site != null ? this.site.hashCode() + retval : retval;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SiteUUID)) {
            return false;
        }
        return this.compareTo((SiteUUID)obj) == 0;
    }

    @Override
    public int compareTo(Address other) {
        if (other instanceof SiteUUID) {
            String other_site = ((SiteUUID)other).getSite();
            if (this.site != null && other_site != null) {
                int rc = this.site.compareTo(other_site);
                return rc == 0 ? super.compareTo(other) : rc;
            }
        }
        return super.compareTo(other);
    }

    public String print(boolean detailed) {
        String retval = this.name != null ? this.name : NameCache.get(this);
        return String.format("%s:%s%s", retval, this.site != null ? this.site : "<all sites>", detailed ? this.printOthers() : "");
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + Util.size(this.site) + Util.size(this.name);
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        Bits.writeString(this.site, out);
        Bits.writeString(this.name, out);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.site = Bits.readString(in);
        this.name = Bits.readString(in);
    }

    protected String printOthers() {
        StringBuilder sb = new StringBuilder();
        if (this.flags != 0) {
            sb.append(" flags=" + this.flags + " (" + this.flags + ")");
        }
        if (this.keys == null) {
            return sb.toString();
        }
        for (int i = 0; i < this.keys.length; ++i) {
            byte[] key = this.keys[i];
            if (key == null) continue;
            byte[] val = this.values[i];
            String obj = null;
            try {
                obj = Util.bytesToString(val);
            }
            catch (Throwable t2) {
                obj = val != null ? val.length + " bytes" : null;
            }
            sb.append(", ").append(new AsciiString(key)).append("=").append((Object)obj);
        }
        return sb.toString();
    }
}

