/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.relay;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.BiConsumer;
import org.jgroups.Address;
import org.jgroups.EmptyMessage;
import org.jgroups.Message;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.protocols.relay.RELAY;
import org.jgroups.protocols.relay.RelayHeader;
import org.jgroups.protocols.relay.SiteMaster;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Bits;
import org.jgroups.util.SizeStreamable;
import org.jgroups.util.Util;

public class Topology {
    protected final RELAY relay;
    protected final Map<String, Set<MemberInfo>> cache = new ConcurrentHashMap<String, Set<MemberInfo>>();
    protected BiConsumer<String, Members> rsp_handler;

    public Topology(RELAY relay) {
        this.relay = Objects.requireNonNull(relay);
    }

    public Map<String, Set<MemberInfo>> cache() {
        return this.cache;
    }

    public Topology setResponseHandler(BiConsumer<String, Members> c) {
        this.rsp_handler = c;
        return this;
    }

    @ManagedOperation(description="Fetches information (site, address, IP address) from all members")
    public Topology refresh() {
        return this.refresh(null);
    }

    @ManagedOperation(description="Fetches information (site, address, IP address) from all members of a given site")
    public Topology refresh(String site) {
        SiteMaster dest = new SiteMaster(site);
        Message topo_req = new EmptyMessage(dest).putHeader(this.relay.getId(), new RelayHeader(6));
        this.relay.down(topo_req);
        return this;
    }

    @ManagedOperation(description="Prints the cache information about all members")
    public String print() {
        return this.print(null);
    }

    @ManagedOperation(description="Prints the cache information about all members")
    public String print(String site) {
        if (site != null) {
            return this.dumpSite(site);
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Set<MemberInfo>> e : this.cache.entrySet()) {
            sb.append(this.dumpSite(e.getKey()));
        }
        return sb.toString();
    }

    public Topology removeAll(Collection<String> sites) {
        if (sites == null) {
            this.cache.keySet().clear();
        } else {
            this.cache.keySet().removeAll(sites);
        }
        return this;
    }

    public Topology adjust(String site, Collection<Address> mbrs) {
        Set<MemberInfo> list = this.cache.get(site);
        if (list != null && mbrs != null) {
            list.removeIf(mi -> !mbrs.contains(mi.addr));
        }
        return this;
    }

    public String toString() {
        return String.format("%d sites", this.cache.size());
    }

    protected String dumpSite(String site) {
        Set<MemberInfo> members = this.cache.get(site);
        if (members == null) {
            return String.format("%s: no members found", site);
        }
        StringBuilder sb = new StringBuilder(site).append("\n");
        for (MemberInfo mi : members) {
            sb.append("  ").append(mi.toStringNoSite()).append("\n");
        }
        return sb.toString();
    }

    protected void handleResponse(Members rsp) {
        String site = rsp.site;
        Set infos = this.cache.computeIfAbsent(site, s2 -> new ConcurrentSkipListSet());
        if (rsp.joined != null) {
            infos.addAll(rsp.joined);
        }
        if (rsp.left != null) {
            // empty if block
        }
        if (this.rsp_handler != null) {
            this.rsp_handler.accept(site, rsp);
        }
    }

    public static class MemberInfo
    implements SizeStreamable,
    Comparable<MemberInfo> {
        protected String site;
        protected Address addr;
        protected IpAddress ip_addr;
        protected boolean site_master;

        public MemberInfo() {
        }

        public MemberInfo(String site, Address addr, IpAddress ip_addr, boolean site_master) {
            this.site = site;
            this.addr = Objects.requireNonNull(addr);
            this.ip_addr = ip_addr;
            this.site_master = site_master;
        }

        public int hashCode() {
            return this.addr.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof MemberInfo && this.compareTo((MemberInfo)obj) == 0;
        }

        @Override
        public int compareTo(MemberInfo o) {
            return this.addr.compareTo(o.addr);
        }

        @Override
        public int serializedSize() {
            return Util.size(this.site) + Util.size(this.addr) + Util.size(this.ip_addr) + 1;
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            Bits.writeString(this.site, out);
            Util.writeAddress(this.addr, out);
            Util.writeAddress(this.ip_addr, out);
            out.writeBoolean(this.site_master);
        }

        @Override
        public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
            this.site = Bits.readString(in);
            this.addr = Util.readAddress(in);
            this.ip_addr = (IpAddress)Util.readAddress(in);
            this.site_master = in.readBoolean();
        }

        public String toString() {
            return String.format("site=%s, addr=%s (ip=%s%s)", this.site, this.addr, this.ip_addr, this.site_master ? ", sm" : "");
        }

        public String toStringNoSite() {
            return String.format("%s (ip=%s%s)", this.addr, this.ip_addr, this.site_master ? ", sm" : "");
        }
    }

    public static class Members
    implements SizeStreamable {
        protected String site;
        protected List<MemberInfo> joined;
        protected List<Address> left;

        public Members() {
        }

        public Members(String site) {
            this.site = site;
        }

        public Members addJoined(MemberInfo mi) {
            if (this.joined == null) {
                this.joined = new ArrayList<MemberInfo>();
            }
            this.joined.add(Objects.requireNonNull(mi));
            return this;
        }

        public Members addLeft(Address left) {
            if (this.left == null) {
                this.left = new ArrayList<Address>();
            }
            this.left.add(Objects.requireNonNull(left));
            return this;
        }

        @Override
        public int serializedSize() {
            int size = Util.size(this.site) + 4;
            if (this.joined != null && !this.joined.isEmpty()) {
                for (MemberInfo mi : this.joined) {
                    size += mi.serializedSize();
                }
            }
            if (this.left != null && !this.left.isEmpty()) {
                for (Address addr : this.left) {
                    size += Util.size(addr);
                }
            }
            return size;
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            Bits.writeString(this.site, out);
            if (this.joined == null || this.joined.isEmpty()) {
                out.writeShort(0);
            } else {
                out.writeShort(this.joined.size());
                for (MemberInfo mi : this.joined) {
                    mi.writeTo(out);
                }
            }
            if (this.left == null || this.left.isEmpty()) {
                out.writeShort(0);
            } else {
                out.writeShort(this.left.size());
                for (Address addr : this.left) {
                    Util.writeAddress(addr, out);
                }
            }
        }

        @Override
        public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
            this.site = Bits.readString(in);
            int len = in.readShort();
            if (len > 0) {
                this.joined = new ArrayList<MemberInfo>(len);
                for (int i = 0; i < len; ++i) {
                    MemberInfo mi = new MemberInfo();
                    mi.readFrom(in);
                    this.joined.add(mi);
                }
            }
            if ((len = in.readShort()) > 0) {
                this.left = new ArrayList<Address>(len);
                Address addr = Util.readAddress(in);
                this.left.add(addr);
            }
        }

        public String toString() {
            return String.format("site %s: %d members joined %d left", this.site, this.joined == null ? 0 : this.joined.size(), this.left == null ? 0 : this.left.size());
        }
    }
}

