/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.jgroups.logging.Log;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.UNICAST3;
import org.jgroups.protocols.pbcast.NAKACK2;
import org.jgroups.stack.Policy;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.ShutdownRejectedExecutionHandler;

public class CheckCallerRunsPolicy
implements Policy {
    protected static final Class<? extends Protocol> UNICAST3 = UNICAST3.class;
    protected static final Class<? extends Protocol> NAKACK2 = NAKACK2.class;

    @Override
    public void check(Protocol prot) throws Exception {
        RejectedExecutionHandler handler;
        if (!(prot instanceof TP)) {
            throw new IllegalStateException(String.format("%s needs to be run in the scope of a transport", CheckCallerRunsPolicy.class.getSimpleName()));
        }
        TP tp = (TP)prot;
        ProtocolStack stack = tp.getProtocolStack();
        Log log = tp.getLog();
        if (!(stack.findProtocol(UNICAST3) != null && stack.findProtocol(NAKACK2) != null || (handler = tp.getThreadPool().getRejectedExecutionHandler()) == null || CheckCallerRunsPolicy.isCallerRunsHandler(handler))) {
            log.warn("the absence of %s or %s requires CallerRunsPolicy in the thread pool; replacing %s", UNICAST3.getSimpleName(), NAKACK2.getSimpleName(), handler.getClass().getSimpleName());
            tp.getThreadPool().setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        }
    }

    protected static boolean isCallerRunsHandler(RejectedExecutionHandler h2) {
        return h2 instanceof ThreadPoolExecutor.CallerRunsPolicy || h2 instanceof ShutdownRejectedExecutionHandler && ((ShutdownRejectedExecutionHandler)h2).handler() instanceof ThreadPoolExecutor.CallerRunsPolicy;
    }
}

