/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeSet;
import org.jgroups.tests.DiscoveryRequest;
import org.jgroups.tests.DiscoveryResponse;
import org.jgroups.tests.Result;
import org.jgroups.util.Util;

public class McastDiscovery {
    int ttl = 32;
    List handlers = new ArrayList();
    InetAddress mcast_addr = null;
    int mcast_port = 5000;
    long interval = 2000L;
    McastSender mcast_sender = null;
    volatile boolean running = true;
    HashMap map = new HashMap();

    public McastDiscovery(InetAddress mcast_addr, int mcast_port, long interval, int ttl) {
        this.mcast_addr = mcast_addr;
        this.mcast_port = mcast_port;
        this.interval = interval;
        this.ttl = ttl;
    }

    public void start() throws Exception {
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (en.hasMoreElements()) {
            NetworkInterface intf = en.nextElement();
            Enumeration<InetAddress> en2 = intf.getInetAddresses();
            while (en2.hasMoreElements()) {
                InetAddress bind_addr = en2.nextElement();
                this.map.put(bind_addr, new ArrayList());
                System.out.println("-- creating receiver for " + bind_addr);
                MessageHandler handler = new MessageHandler(bind_addr);
                this.handlers.add(handler);
                handler.start();
            }
        }
        this.mcast_sender = new McastSender();
        this.mcast_sender.start();
        System.out.println("press key to stop");
        System.out.flush();
        System.in.read();
        this.printValidInterfaces();
    }

    void printValidInterfaces() {
        ArrayList<InetSocketAddress> all_mbrs = new ArrayList<InetSocketAddress>();
        HashMap map_copy = (HashMap)this.map.clone();
        System.out.println("\n========================================================");
        System.out.println("Responses received ordered by interface:\n");
        for (Map.Entry entry : this.map.entrySet()) {
            InetAddress bind_interface = (InetAddress)entry.getKey();
            System.out.println(bind_interface.getHostAddress() + ":\t " + entry.getValue());
        }
        for (List l : this.map.values()) {
            for (InetSocketAddress tmp_addr : l) {
                if (all_mbrs.contains(tmp_addr)) continue;
                all_mbrs.add(tmp_addr);
            }
        }
        for (InetSocketAddress tmp_addr : all_mbrs) {
            Iterator<Object> it2 = this.map.entrySet().iterator();
            while (it2.hasNext()) {
                List l;
                Map.Entry entry;
                entry = (Map.Entry)it2.next();
                l = (List)entry.getValue();
                if (l.contains(tmp_addr)) continue;
                it2.remove();
            }
        }
        if (!this.map.isEmpty()) {
            System.out.println("\n-- Valid interfaces are " + this.map.keySet() + "\n");
        } else {
            System.out.println("\nNo valid interfaces found, listing interfaces by number of responses/interface:\n(it is best to use the interface with the most responses)");
            TreeSet<Result> s2 = new TreeSet<Result>();
            for (Map.Entry entry : map_copy.entrySet()) {
                Result r = new Result((InetAddress)entry.getKey(), ((List)entry.getValue()).size());
                s2.add(r);
            }
            Stack st = new Stack();
            Iterator it = s2.iterator();
            while (it.hasNext()) {
                st.push(it.next());
            }
            while (!st.empty()) {
                System.out.println("-- " + st.pop());
            }
        }
        System.out.println("\nUse of any of the above interfaces in \"UDP(bind_addr=<interface>)\" will guarantee that the members will find each other");
        System.out.println("========================================================\n\n");
    }

    public static void main(String[] args) {
        int ttl = 32;
        String mcast_addr = "239.8.8.8";
        int mcast_port = 5000;
        long interval = 2000L;
        for (int i = 0; i < args.length; ++i) {
            if ("-help".equals(args[i])) {
                McastDiscovery.help();
                return;
            }
            if ("-mcast_addr".equals(args[i])) {
                mcast_addr = args[++i];
                continue;
            }
            if ("-mcast_port".equals(args[i])) {
                mcast_port = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-interval".equals(args[i])) {
                interval = Long.parseLong(args[++i]);
                continue;
            }
            if ("-ttl".equals(args[i])) {
                ttl = Integer.parseInt(args[++i]);
                continue;
            }
            McastDiscovery.help();
            return;
        }
        try {
            new McastDiscovery(InetAddress.getByName(mcast_addr), mcast_port, interval, ttl).start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static void help() {
        System.out.println("McastDiscovery [-mcast_addr <multicast address>] [-mcast_port <port>] [-interval <time between mcasts (msecs)>] [-ttl <ttl>]");
    }

    class MessageHandler {
        MulticastSocket mcast_sock = null;
        DatagramSocket sock = null;
        McastReceiver mcast_receiver = null;
        UcastReceiver ucast_receiver = null;
        InetAddress local_addr = null;
        int local_port = 0;

        MessageHandler(InetAddress bind_interface) throws Exception {
            this.mcast_sock = new MulticastSocket(McastDiscovery.this.mcast_port);
            if (bind_interface != null) {
                this.mcast_sock.setNetworkInterface(NetworkInterface.getByInetAddress(bind_interface));
            }
            this.mcast_sock.setTimeToLive(McastDiscovery.this.ttl);
            this.mcast_sock.joinGroup(new InetSocketAddress(McastDiscovery.this.mcast_addr, McastDiscovery.this.mcast_port), bind_interface == null ? null : NetworkInterface.getByInetAddress(bind_interface));
            this.sock = new DatagramSocket(0, bind_interface);
            this.local_addr = this.sock.getLocalAddress();
            this.local_port = this.sock.getLocalPort();
        }

        void start() throws Exception {
            McastDiscovery.this.running = true;
            this.ucast_receiver = new UcastReceiver();
            this.ucast_receiver.start();
            this.mcast_receiver = new McastReceiver();
            this.mcast_receiver.start();
        }

        void stop() {
            McastDiscovery.this.running = false;
            if (this.mcast_sock != null) {
                this.mcast_sock.close();
                this.mcast_sock = null;
            }
            if (this.sock != null) {
                this.sock.close();
                this.sock = null;
            }
        }

        void sendDiscoveryRequest() {
            DiscoveryRequest req = new DiscoveryRequest(this.local_addr, this.local_port);
            System.out.println("--> " + req);
            try {
                byte[] buf = Util.objectToByteBuffer(req);
                DatagramPacket packet = new DatagramPacket(buf, buf.length, McastDiscovery.this.mcast_addr, McastDiscovery.this.mcast_port);
                this.mcast_sock.send(packet);
            }
            catch (Exception ex) {
                System.err.println("McastDiscovery.sendDiscoveryRequest(): " + ex);
            }
        }

        class UcastReceiver
        extends Thread {
            UcastReceiver() {
                this.setName("UcastReceiver");
                this.setDaemon(true);
            }

            @Override
            public void run() {
                while (McastDiscovery.this.running) {
                    try {
                        InetSocketAddress responder_addr;
                        byte[] buf = new byte[16000];
                        DatagramPacket packet = new DatagramPacket(buf, buf.length);
                        MessageHandler.this.sock.receive(packet);
                        DiscoveryResponse rsp = (DiscoveryResponse)Util.objectFromByteBuffer(packet.getData());
                        System.out.println("<== " + rsp);
                        InetAddress bind_interface = rsp.interface_used;
                        ArrayList<InetSocketAddress> l = (ArrayList<InetSocketAddress>)McastDiscovery.this.map.get(bind_interface);
                        if (l == null) {
                            l = new ArrayList<InetSocketAddress>();
                            McastDiscovery.this.map.put(bind_interface, l);
                        }
                        if (l.contains(responder_addr = rsp.discovery_responder)) continue;
                        l.add(responder_addr);
                    }
                    catch (Exception ex) {
                        System.err.println("UcastReceiver.run(): " + ex);
                    }
                }
            }
        }

        class McastReceiver
        extends Thread {
            byte[] buf;
            DatagramPacket mcast_packet;
            DatagramPacket rsp_packet;
            DiscoveryRequest req;
            DiscoveryResponse rsp;

            McastReceiver() {
                this.setName("McastReceiver");
                this.setDaemon(true);
            }

            @Override
            public void run() {
                while (McastDiscovery.this.running) {
                    this.buf = new byte[16000];
                    this.mcast_packet = new DatagramPacket(this.buf, this.buf.length);
                    try {
                        MessageHandler.this.mcast_sock.receive(this.mcast_packet);
                        this.req = (DiscoveryRequest)Util.objectFromByteBuffer(this.mcast_packet.getData());
                        System.out.println("<-- " + this.req);
                        this.rsp = new DiscoveryResponse(new InetSocketAddress(MessageHandler.this.local_addr, MessageHandler.this.local_port), this.req.sender_addr.getAddress());
                        this.buf = Util.objectToByteBuffer(this.rsp);
                        this.rsp_packet = new DatagramPacket(this.buf, this.buf.length, this.req.sender_addr);
                        MessageHandler.this.sock.send(this.rsp_packet);
                    }
                    catch (Exception ex) {
                        System.err.println("McastReceiver.run(): " + ex + ", rsp_packet=" + this.rsp_packet.getSocketAddress() + ", length=" + this.rsp_packet.getLength() + " bytes");
                        ex.printStackTrace();
                    }
                }
            }
        }
    }

    class McastSender
    extends Thread {
        McastSender() {
            this.setName("McastSender");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (McastDiscovery.this.running) {
                for (MessageHandler handler : McastDiscovery.this.handlers) {
                    handler.sendDiscoveryRequest();
                }
                try {
                    McastSender.sleep(McastDiscovery.this.interval);
                }
                catch (Exception exception) {}
            }
        }
    }
}

