/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.util.DefaultThreadFactory;
import org.jgroups.util.ShutdownRejectedExecutionHandler;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.Util;

public class ThreadCreator {
    private static final Log LOG = LogFactory.getLog(ThreadCreator.class);
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.publicLookup();
    private static final String OF_VIRTUAL_NAME = "java.lang.Thread$Builder$OfVirtual";
    private static final Class<?> OF_VIRTUAL_CLASS = ThreadCreator.getOfVirtualClass();
    private static final MethodHandle OF_VIRTUAL = ThreadCreator.getOfVirtualHandle();
    private static final MethodHandle CREATE_VTHREAD = ThreadCreator.getCreateVThreadHandle();
    private static final MethodHandle EXECUTORS_NEW_VIRTUAL_THREAD_FACTORY = ThreadCreator.getNewVirtualThreadFactoryHandle();

    public static boolean hasVirtualThreads() {
        return CREATE_VTHREAD != null;
    }

    protected static MethodHandle getCreateVThreadHandle() {
        MethodType type = MethodType.methodType(Thread.class, Runnable.class);
        try {
            return LOOKUP.findVirtual(OF_VIRTUAL_CLASS, "unstarted", type);
        }
        catch (Exception ex) {
            LOG.debug("%s.unstarted() not found, trying Thread.newThread() (jdk 15/16)", OF_VIRTUAL_NAME);
            type = MethodType.methodType(Thread.class, String.class, Integer.TYPE, Runnable.class);
            try {
                return LOOKUP.findStatic(Thread.class, "newThread", type);
            }
            catch (Exception ex2) {
                LOG.debug("Thread.newThread() not found, falling back to regular threads");
                return null;
            }
        }
    }

    protected static Class<?> getOfVirtualClass() {
        try {
            return Util.loadClass(OF_VIRTUAL_NAME, (Class)null);
        }
        catch (ClassNotFoundException e) {
            LOG.debug("class %s not found", OF_VIRTUAL_NAME);
            return null;
        }
    }

    protected static MethodHandle getOfVirtualHandle() {
        try {
            return OF_VIRTUAL_CLASS != null ? LOOKUP.findStatic(Thread.class, "ofVirtual", MethodType.methodType(OF_VIRTUAL_CLASS)) : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected static MethodHandle getNewVirtualThreadFactoryHandle() {
        MethodType type = MethodType.methodType(ExecutorService.class);
        String[] names = new String[]{"newVirtualThreadPerTaskExecutor", "newVirtualThreadExecutor", "newUnboundedVirtualThreadExecutor"};
        for (int i = 0; i < names.length; ++i) {
            try {
                return LOOKUP.findStatic(Executors.class, names[i], type);
            }
            catch (Exception e) {
                String next = i + 1 < names.length ? names[i + 1] : "regular thread pool";
                LOG.debug("%s not found, falling back to %s", names[i], next);
                continue;
            }
        }
        return null;
    }

    public static Thread createThread(Runnable r, String name, boolean daemon, boolean virtual) {
        if (!virtual || CREATE_VTHREAD == null) {
            Thread t2 = new Thread(r, name);
            t2.setDaemon(daemon);
            return t2;
        }
        try {
            Object of = OF_VIRTUAL.invoke();
            Thread t3 = (Thread)CREATE_VTHREAD.invokeWithArguments(of, r);
            t3.setName(name);
            return t3;
        }
        catch (Throwable throwable) {
            try {
                return CREATE_VTHREAD.invokeExact(name, 1, r);
            }
            catch (Throwable throwable2) {
                return new Thread(r, name);
            }
        }
    }

    public static ExecutorService createThreadPool(int min_threads, int max_threads, long keep_alive_time, boolean virtual_threads, Log log) {
        return ThreadCreator.createThreadPool(min_threads, max_threads, keep_alive_time, "abort", new SynchronousQueue<Runnable>(), new DefaultThreadFactory("threads", true, true), virtual_threads, log);
    }

    public static ExecutorService createThreadPool(int min_threads, int max_threads, long keep_alive_time, String rejection_policy, BlockingQueue<Runnable> queue, ThreadFactory factory, boolean useVirtualThreads, Log log) {
        if (!useVirtualThreads || EXECUTORS_NEW_VIRTUAL_THREAD_FACTORY == null) {
            ThreadPoolExecutor pool = new ThreadPoolExecutor(min_threads, max_threads, keep_alive_time, TimeUnit.MILLISECONDS, queue, factory);
            RejectedExecutionHandler handler = Util.parseRejectionPolicy(rejection_policy);
            pool.setRejectedExecutionHandler(new ShutdownRejectedExecutionHandler(handler));
            if (log != null) {
                log.debug("thread pool min/max/keep-alive (ms): %d/%d/%d", min_threads, max_threads, keep_alive_time);
            }
            return pool;
        }
        try {
            return EXECUTORS_NEW_VIRTUAL_THREAD_FACTORY.invokeExact();
        }
        catch (Throwable t2) {
            throw new IllegalStateException(String.format("failed to create virtual thread pool: %s", t2));
        }
    }
}

