/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.util.DirectExecutor;
import org.jgroups.util.LazyThreadFactory;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.ThreadPool;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

public class TimeScheduler3
implements TimeScheduler,
Runnable {
    protected Executor pool;
    protected ThreadPool thread_pool;
    protected final BlockingQueue<Task> queue = new DelayQueue<Task>();
    protected volatile Thread runner;
    protected static final Log log = LogFactory.getLog(TimeScheduler3.class);
    protected ThreadFactory timer_thread_factory;
    protected boolean non_blocking_task_handling = true;
    protected boolean shut_down_pool;

    public TimeScheduler3() {
        this.pool = new ThreadPoolExecutor(4, 10, 30000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(100), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
        this.shut_down_pool = true;
        this.start();
    }

    public TimeScheduler3(ThreadFactory factory, int min_threads, int max_threads, long keep_alive_time, int max_queue_size, String rejection_policy) {
        this(factory, min_threads, max_threads, keep_alive_time, new ArrayBlockingQueue<Runnable>(max_queue_size), rejection_policy, true);
    }

    public TimeScheduler3(ThreadFactory factory, int min_threads, int max_threads, long keep_alive_time, BlockingQueue<Runnable> queue, String rejection_policy, boolean thread_pool_enabled) {
        this.timer_thread_factory = factory;
        this.pool = thread_pool_enabled ? new ThreadPoolExecutor(min_threads, max_threads, keep_alive_time, TimeUnit.MILLISECONDS, queue, factory, Util.parseRejectionPolicy(rejection_policy)) : new DirectExecutor();
        this.shut_down_pool = true;
        this.start();
    }

    public TimeScheduler3(ThreadPool thread_pool, ThreadFactory factory, boolean start) {
        this.timer_thread_factory = factory;
        this.thread_pool = Objects.requireNonNull(thread_pool);
        this.pool = thread_pool.getThreadPool();
        if (start) {
            this.start();
        }
    }

    @Override
    public void setThreadFactory(ThreadFactory f) {
        this.condSet(p -> p.setThreadFactory(f));
    }

    public void setThreadPool(Executor new_pool) {
        this.pool = new_pool;
    }

    @Override
    public int getMinThreads() {
        return this.condGet(ThreadPoolExecutor::getCorePoolSize, 0);
    }

    @Override
    public void setMinThreads(int size) {
        this.condSet(p -> p.setCorePoolSize(size));
    }

    @Override
    public int getMaxThreads() {
        return this.condGet(ThreadPoolExecutor::getMaximumPoolSize, 0);
    }

    @Override
    public void setMaxThreads(int size) {
        this.condSet(p -> p.setMaximumPoolSize(size));
    }

    @Override
    public long getKeepAliveTime() {
        return this.condGet(p -> p.getKeepAliveTime(TimeUnit.MILLISECONDS), 0L);
    }

    @Override
    public void setKeepAliveTime(long time) {
        this.condSet(p -> p.setKeepAliveTime(time, TimeUnit.MILLISECONDS));
    }

    @Override
    public int getCurrentThreads() {
        return this.condGet(ThreadPoolExecutor::getPoolSize, 0);
    }

    public int getQueueSize() {
        return this.condGet(p -> p.getQueue().size(), 0);
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public boolean isShutdown() {
        return this.condGet(ThreadPoolExecutor::isShutdown, false);
    }

    @Override
    public boolean getNonBlockingTaskHandling() {
        return this.non_blocking_task_handling;
    }

    @Override
    public void setNonBlockingTaskHandling(boolean b) {
        this.non_blocking_task_handling = b;
    }

    @Override
    public String dumpTimerTasks() {
        StringBuilder sb = new StringBuilder();
        for (Task task : this.queue) {
            sb.append(task);
            if (task.isCancelled()) {
                sb.append(" (cancelled)");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public void removeCancelledTasks() {
        this.queue.removeIf(Task::isDone);
    }

    @Override
    public void execute(Runnable task, boolean can_block) {
        this.submitToPool(task instanceof TimeScheduler.Task ? new RecurringTask(task, TaskType.dynamic, 0L, ((TimeScheduler.Task)task).nextInterval(), TimeUnit.MILLISECONDS, can_block) : new Task(task, can_block));
    }

    @Override
    public Future<?> schedule(Runnable work, long initial_delay, TimeUnit unit, boolean can_block) {
        return this.doSchedule(new Task(work, initial_delay, unit, can_block), initial_delay);
    }

    @Override
    public Future<?> scheduleWithFixedDelay(Runnable work, long initial_delay, long delay, TimeUnit unit, boolean can_block) {
        return this.scheduleRecurring(work, TaskType.fixed_delay, initial_delay, delay, unit, can_block);
    }

    @Override
    public Future<?> scheduleAtFixedRate(Runnable work, long initial_delay, long delay, TimeUnit unit, boolean can_block) {
        return this.scheduleRecurring(work, TaskType.fixed_rate, initial_delay, delay, unit, can_block);
    }

    @Override
    public Future<?> scheduleWithDynamicInterval(TimeScheduler.Task work, boolean can_block) {
        return this.scheduleRecurring(work, TaskType.dynamic, work.nextInterval(), 0L, TimeUnit.MILLISECONDS, can_block);
    }

    @Override
    public synchronized void start() {
        if (this.runner == null || !this.runner.isAlive()) {
            this.runner = this.timer_thread_factory != null ? this.timer_thread_factory.newThread(this, "Timer runner") : new Thread((Runnable)this, "Timer runner");
            this.runner.start();
        }
    }

    @Override
    public synchronized void stop() {
        Thread tmp = this.runner;
        this.runner = null;
        if (tmp != null) {
            tmp.interrupt();
            try {
                tmp.join(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        while (!this.queue.isEmpty()) {
            for (Task entry : this.queue) {
                entry.cancel(true);
                this.queue.remove(entry);
            }
        }
        if (this.pool instanceof ThreadPoolExecutor && this.shut_down_pool) {
            ThreadPoolExecutor p = (ThreadPoolExecutor)this.pool;
            List<Runnable> remaining_tasks = p.shutdownNow();
            remaining_tasks.stream().filter(task -> task instanceof Future).forEach(task -> ((Future)((Object)task)).cancel(true));
            p.getQueue().clear();
            try {
                p.awaitTermination(3000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.timer_thread_factory instanceof LazyThreadFactory) {
            ((LazyThreadFactory)this.timer_thread_factory).destroy();
        }
    }

    @Override
    public void run() {
        while (Thread.currentThread() == this.runner) {
            try {
                Task task = this.queue.take();
                if (task.isDone()) continue;
                this.submitToPool(task);
            }
            catch (InterruptedException task) {
            }
            catch (Throwable t2) {
                log.error(Util.getMessage("FailedSubmittingTaskToThreadPool"), t2);
            }
        }
    }

    protected Future<?> scheduleRecurring(Runnable work, TaskType type, long initial_delay, long delay, TimeUnit unit, boolean can_block) {
        return this.doSchedule(new RecurringTask(work, type, initial_delay, delay, unit, can_block), initial_delay);
    }

    protected Future<?> doSchedule(Task task, long initial_delay) {
        if (task.getRunnable() == null) {
            throw new NullPointerException();
        }
        if (this.isShutdown()) {
            return null;
        }
        if (initial_delay <= 0L) {
            this.submitToPool(task);
            return task;
        }
        return this.add(task);
    }

    protected void condSet(Consumer<ThreadPoolExecutor> setter) {
        if (this.pool instanceof ThreadPoolExecutor) {
            setter.accept((ThreadPoolExecutor)this.pool);
        }
    }

    protected <T> T condGet(Function<ThreadPoolExecutor, T> getter, T default_value) {
        if (this.pool instanceof ThreadPoolExecutor) {
            return getter.apply((ThreadPoolExecutor)this.pool);
        }
        return default_value;
    }

    protected void submitToPool(Task task) {
        if (this.non_blocking_task_handling && !task.canBlock()) {
            task.run();
            return;
        }
        try {
            if (this.pool == null && (this.pool = this.thread_pool.getThreadPool()) == null) {
                log.warn("timer: thread pool is null, will use caller's thread to execute task %s", task);
                task.run();
                return;
            }
            this.pool.execute(task);
        }
        catch (RejectedExecutionException rejected) {
            Thread thread = this.timer_thread_factory != null ? this.timer_thread_factory.newThread(task, "Timer temp thread") : new Thread((Runnable)task, "Timer temp thread");
            thread.start();
        }
    }

    protected Task add(Task task) {
        this.queue.add(task);
        return task;
    }

    protected boolean isRunning() {
        Thread tmp = this.runner;
        return tmp != null && tmp.isAlive();
    }

    protected class RecurringTask
    extends Task {
        protected final TaskType type;
        protected final long period;
        protected final long initial_delay;
        protected int cnt;

        public RecurringTask(Runnable runnable, TaskType type, long initial_delay, long delay, TimeUnit unit, boolean can_block) {
            super(runnable, initial_delay, unit, can_block);
            this.cnt = 1;
            this.initial_delay = TimeUnit.NANOSECONDS.convert(initial_delay, TimeUnit.MILLISECONDS);
            this.type = type;
            this.period = TimeUnit.NANOSECONDS.convert(delay, unit);
            if (type == TaskType.dynamic && !(runnable instanceof TimeScheduler.Task)) {
                throw new IllegalArgumentException("Need to provide a TimeScheduler.Task as runnable when type is dynamic");
            }
        }

        @Override
        public void run() {
            if (this.isDone()) {
                return;
            }
            super.run();
            if (this.cancelled) {
                return;
            }
            this.done = false;
            switch (this.type) {
                case dynamic: {
                    long next_interval = TimeUnit.NANOSECONDS.convert(((TimeScheduler.Task)this.runnable).nextInterval(), TimeUnit.MILLISECONDS);
                    if (next_interval <= 0L) {
                        if (log.isTraceEnabled()) {
                            log.trace("task will not get rescheduled as interval is " + next_interval);
                        }
                        this.done = true;
                        return;
                    }
                    this.creation_time = System.nanoTime();
                    this.delay = next_interval;
                    break;
                }
                case fixed_rate: {
                    this.delay = this.initial_delay + (long)this.cnt++ * this.period;
                    break;
                }
                case fixed_delay: {
                    this.creation_time = System.nanoTime();
                    this.delay = this.period;
                }
            }
            TimeScheduler3.this.add(this);
        }
    }

    public static class Task
    implements Runnable,
    Delayed,
    Future {
        protected final Runnable runnable;
        protected long creation_time;
        protected long delay;
        protected volatile boolean cancelled;
        protected volatile boolean done;
        protected final boolean can_block;

        public Task(Runnable runnable, boolean can_block) {
            this.runnable = runnable;
            this.can_block = can_block;
        }

        public Task(Runnable runnable, long initial_delay, TimeUnit unit, boolean can_block) {
            this.can_block = can_block;
            this.creation_time = System.nanoTime();
            this.delay = TimeUnit.NANOSECONDS.convert(initial_delay, unit);
            this.runnable = runnable;
            if (runnable == null) {
                throw new IllegalArgumentException("runnable cannot be null");
            }
        }

        public Runnable getRunnable() {
            return this.runnable;
        }

        public boolean canBlock() {
            return this.can_block;
        }

        @Override
        public int compareTo(Delayed o) {
            long my_delay = this.getDelay(TimeUnit.NANOSECONDS);
            long other_delay = o.getDelay(TimeUnit.NANOSECONDS);
            return Long.compare(my_delay, other_delay);
        }

        @Override
        public long getDelay(TimeUnit unit) {
            long remaining_time = this.delay - (System.nanoTime() - this.creation_time);
            return unit.convert(remaining_time, TimeUnit.NANOSECONDS);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean retval = !this.isDone();
            this.cancelled = true;
            return retval;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public boolean isDone() {
            return this.done || this.cancelled;
        }

        public Object get() throws InterruptedException, ExecutionException {
            return null;
        }

        public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return null;
        }

        @Override
        public void run() {
            if (this.isDone()) {
                return;
            }
            try {
                this.runnable.run();
            }
            catch (Throwable t2) {
                log.error(Util.getMessage("FailedExecutingTask") + " " + this.runnable, t2);
            }
            finally {
                this.done = true;
            }
        }

        public String toString() {
            return String.format("%s (can block=%b)", this.runnable.toString(), this.can_block);
        }
    }

    protected static enum TaskType {
        dynamic,
        fixed_rate,
        fixed_delay;

    }
}

