/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.function;

import org.wildfly.common.Assert;
import org.wildfly.common.function.ExceptionObjLongConsumer;

@FunctionalInterface
public interface ExceptionObjIntConsumer<T, E extends Exception> {
    public void accept(T var1, int var2) throws E;

    default public ExceptionObjIntConsumer<T, E> andThen(ExceptionObjIntConsumer<? super T, ? extends E> after) {
        Assert.checkNotNullParam("after", after);
        return (t2, v) -> {
            this.accept(t2, v);
            after.accept(t2, v);
        };
    }

    default public ExceptionObjIntConsumer<T, E> compose(ExceptionObjIntConsumer<? super T, ? extends E> before) {
        Assert.checkNotNullParam("before", before);
        return (t2, v) -> {
            before.accept(t2, v);
            this.accept(t2, v);
        };
    }

    default public ExceptionObjIntConsumer<T, E> andThen(ExceptionObjLongConsumer<? super T, ? extends E> after) {
        Assert.checkNotNullParam("after", after);
        return (t2, v) -> {
            this.accept(t2, v);
            after.accept(t2, v);
        };
    }

    default public ExceptionObjIntConsumer<T, E> compose(ExceptionObjLongConsumer<? super T, ? extends E> before) {
        Assert.checkNotNullParam("before", before);
        return (t2, v) -> {
            before.accept(t2, v);
            this.accept(t2, v);
        };
    }
}

