/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.permission;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import org.wildfly.common.Assert;
import org.wildfly.security.permission.SecurityMessages;

@Deprecated
public final class PermissionActions {
    private static final ClassValue<Info<?>> storedInfo = new ClassValue<Info<?>>(){

        @Override
        protected Info<?> computeValue(Class<?> type) {
            return this.computeReal(type);
        }

        private <E> Info<E> computeReal(Class<E> type) {
            E[] enumConstants;
            TrieNode<E> root = new TrieNode<E>();
            for (E e : enumConstants = type.getEnumConstants()) {
                root.put(e.toString(), 0, e);
            }
            return new Info(root, type.getEnumConstants());
        }
    };

    private PermissionActions() {
    }

    public static <E extends Enum<E>> EnumSet<E> parseActionStringToSet(Class<E> actionType, String actionString) throws IllegalArgumentException {
        Assert.checkNotNullParam("actionType", actionType);
        Assert.checkNotNullParam("actionString", actionString);
        SetMatchAction<E> matchAction = new SetMatchAction<E>(EnumSet.noneOf(actionType));
        PermissionActions.doParse(actionType, actionString, matchAction);
        return matchAction.getSet();
    }

    public static <E extends Enum<E>> int parseActionStringToInt(Class<E> actionType, String actionString) throws IllegalArgumentException {
        Assert.checkNotNullParam("actionType", actionType);
        Assert.checkNotNullParam("actionString", actionString);
        IntMatchAction matchAction = new IntMatchAction();
        PermissionActions.doParse(actionType, actionString, matchAction);
        return matchAction.getResult();
    }

    public static <E extends Enum<E>> long parseActionStringToLong(Class<E> actionType, String actionString) throws IllegalArgumentException {
        Assert.checkNotNullParam("actionType", actionType);
        Assert.checkNotNullParam("actionString", actionString);
        LongMatchAction matchAction = new LongMatchAction();
        PermissionActions.doParse(actionType, actionString, matchAction);
        return matchAction.getResult();
    }

    private static <E extends Enum<E>> void doParse(Class<E> actionType, String actionString, MatchAction<E> matchAction) {
        Info<?> info = storedInfo.get(actionType);
        TrieNode rootNode = info.root;
        int length = actionString.length();
        int i = 0;
        block0: while (i != length) {
            char c = actionString.charAt(i);
            if (Character.isWhitespace(c)) {
                ++i;
                continue;
            }
            if (c == ',') {
                ++i;
                continue;
            }
            if (c == '*') {
                matchAction.matchedAll(actionType);
                while (++i != length) {
                    c = actionString.charAt(i);
                    if (c == ',') {
                        ++i;
                        continue block0;
                    }
                    if (Character.isWhitespace(c)) continue;
                    throw SecurityMessages.permission.unexpectedActionCharacter(c, i, actionString);
                }
                break;
            }
            int start = i;
            do {
                char c2 = c = ++i < length ? actionString.charAt(i) : (char)'\u0000';
            } while (i != length && !Character.isWhitespace(c) && c != ',');
            Enum action = (Enum)rootNode.get(actionString, start, i);
            if (action == null) {
                throw SecurityMessages.permission.invalidAction(actionString.substring(start, i), start, actionString);
            }
            matchAction.matched(action);
            if (i == length) break;
            while (Character.isWhitespace(c)) {
                if (++i == length) break block0;
                c = actionString.charAt(i);
            }
            if (c != ',') {
                throw SecurityMessages.permission.unexpectedActionCharacter(c, i, actionString);
            }
            ++i;
        }
    }

    public static <E extends Enum<E>> String getCanonicalActionString(EnumSet<E> set) {
        if (set == null || set.isEmpty()) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        PermissionActions.getCanonicalActionString(set, b);
        return b.toString();
    }

    public static <E extends Enum<E>> void getCanonicalActionString(EnumSet<E> set, StringBuilder b) {
        if (set == null || set.isEmpty()) {
            return;
        }
        Iterator iterator = set.iterator();
        if (iterator.hasNext()) {
            Enum e = (Enum)iterator.next();
            b.append(e.toString());
            while (iterator.hasNext()) {
                e = (Enum)iterator.next();
                b.append(',');
                b.append(e.toString());
            }
        }
    }

    public static <E extends Enum<E>> String getCanonicalActionString(Class<E> type, int set) {
        if (set == 0) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        PermissionActions.getCanonicalActionString(type, set, b);
        return b.toString();
    }

    public static <E extends Enum<E>> void getCanonicalActionString(Class<E> type, int set, StringBuilder b) {
        if (set == 0) {
            return;
        }
        Enum[] constants = (Enum[])PermissionActions.storedInfo.get(type).constants;
        int bit = Integer.lowestOneBit(set);
        Enum e = constants[Integer.numberOfTrailingZeros(bit)];
        b.append(e.toString());
        set &= ~bit;
        while (set != 0) {
            bit = Integer.lowestOneBit(set);
            e = constants[Integer.numberOfTrailingZeros(bit)];
            b.append(',').append(e.toString());
            set &= ~bit;
        }
    }

    public static <E extends Enum<E>> String getCanonicalActionString(Class<E> type, long set) {
        if (set == 0L) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        PermissionActions.getCanonicalActionString(type, set, b);
        return b.toString();
    }

    public static <E extends Enum<E>> void getCanonicalActionString(Class<E> type, long set, StringBuilder b) {
        if (set == 0L) {
            return;
        }
        Enum[] constants = (Enum[])PermissionActions.storedInfo.get(type).constants;
        long bit = Long.lowestOneBit(set);
        Enum e = constants[Long.numberOfTrailingZeros(bit)];
        b.append(e.toString());
        set &= bit ^ 0xFFFFFFFFFFFFFFFFL;
        while (set != 0L) {
            bit = Long.lowestOneBit(set);
            e = constants[Long.numberOfTrailingZeros(bit)];
            b.append(',').append(e.toString());
            set &= bit ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    static class LongMatchAction<E extends Enum<E>>
    implements MatchAction<E> {
        private long result;

        LongMatchAction() {
        }

        @Override
        public void matched(E item) {
            this.result |= 1L << ((Enum)item).ordinal();
        }

        @Override
        public void matchedAll(Class<E> type) {
            this.result |= (1L << ((Info)storedInfo.get(type)).constants.length) - 1L;
        }

        public long getResult() {
            return this.result;
        }
    }

    static class IntMatchAction<E extends Enum<E>>
    implements MatchAction<E> {
        private int result;

        IntMatchAction() {
        }

        @Override
        public void matched(E item) {
            this.result |= 1 << ((Enum)item).ordinal();
        }

        @Override
        public void matchedAll(Class<E> type) {
            this.result |= (1 << ((Info)storedInfo.get(type)).constants.length) - 1;
        }

        public int getResult() {
            return this.result;
        }
    }

    static class SetMatchAction<E extends Enum<E>>
    implements MatchAction<E> {
        private EnumSet<E> set;

        SetMatchAction(EnumSet<E> set) {
            this.set = set;
        }

        @Override
        public void matched(E item) {
            this.set.add(item);
        }

        @Override
        public void matchedAll(Class<E> type) {
            this.set = EnumSet.allOf(type);
        }

        public EnumSet<E> getSet() {
            return this.set;
        }
    }

    static interface MatchAction<E extends Enum<E>> {
        public void matched(E var1);

        public void matchedAll(Class<E> var1);
    }

    static final class Info<E> {
        final TrieNode<E> root;
        final E[] constants;

        Info(TrieNode<E> root, E[] constants) {
            this.root = root;
            this.constants = constants;
        }
    }

    static final class TrieNode<E> {
        private static final char[] C_EMPTY = new char[0];
        private static final TrieNode[] T_EMPTY = new TrieNode[0];
        private E result;
        private char[] matches = C_EMPTY;
        private TrieNode<E>[] children = T_EMPTY;

        TrieNode() {
        }

        void put(String s2, int idx, E value) {
            if (idx == s2.length()) {
                this.result = value;
                return;
            }
            char c = s2.charAt(idx);
            int i = Arrays.binarySearch(this.matches, c);
            if (i < 0) {
                int oldLength = this.matches.length;
                char[] newMatches = Arrays.copyOf(this.matches, oldLength + 1);
                TrieNode<E>[] newChildren = Arrays.copyOf(this.children, oldLength + 1);
                int insertIndex = -i - 1;
                System.arraycopy(newMatches, insertIndex, newMatches, insertIndex + 1, oldLength - insertIndex);
                System.arraycopy(newChildren, insertIndex, newChildren, insertIndex + 1, oldLength - insertIndex);
                newMatches[insertIndex] = c;
                TrieNode<E> newNode = new TrieNode<E>();
                newChildren[insertIndex] = newNode;
                this.matches = newMatches;
                this.children = newChildren;
                newNode.put(s2, idx + 1, value);
            } else {
                this.children[i].put(s2, idx + 1, value);
            }
        }

        E get(String s2, int idx, int end) {
            if (idx == end) {
                return this.result;
            }
            char c = s2.charAt(idx);
            int i = Arrays.binarySearch(this.matches, c);
            if (i < 0) {
                return null;
            }
            return this.children[i].get(s2, idx + 1, end);
        }
    }
}

