/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Predicate;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.wildfly.common.Assert;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslClientFactory;

public final class FilterMechanismSaslClientFactory
extends AbstractDelegatingSaslClientFactory {
    private final Predicate<String> predicate;

    public FilterMechanismSaslClientFactory(SaslClientFactory delegate, Predicate<String> predicate) {
        super(delegate);
        Assert.checkNotNullParam("predicate", predicate);
        this.predicate = predicate;
    }

    public FilterMechanismSaslClientFactory(SaslClientFactory delegate, boolean include, String ... mechanisms) {
        super(delegate);
        Assert.checkNotNullParam("mechanisms", mechanisms);
        HashSet set = new HashSet(mechanisms.length);
        Collections.addAll(set, mechanisms);
        Predicate<String> predicate = set::contains;
        this.predicate = include ? predicate : predicate.negate();
    }

    public FilterMechanismSaslClientFactory(SaslClientFactory delegate, boolean include, Collection<String> mechanisms) {
        super(delegate);
        Assert.checkNotNullParam("mechanisms", mechanisms);
        HashSet<String> set = new HashSet<String>(mechanisms);
        Predicate<String> predicate = set::contains;
        this.predicate = include ? predicate : predicate.negate();
    }

    @Override
    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        for (String mechanism : mechanisms) {
            if (this.predicate.test(mechanism)) continue;
            ArrayList<String> list = new ArrayList<String>(mechanisms.length - 1);
            for (String m22 : mechanisms) {
                if (!this.predicate.test(m22)) continue;
                list.add(m22);
            }
            if (list.size() == 0) {
                return null;
            }
            return this.delegate.createSaslClient(list.toArray(new String[list.size()]), authorizationId, protocol, serverName, props, cbh);
        }
        return this.delegate.createSaslClient(mechanisms, authorizationId, protocol, serverName, props, cbh);
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        String[] names = this.delegate.getMechanismNames(props);
        ArrayList<String> list = new ArrayList<String>(names.length);
        for (String name : names) {
            if (!this.predicate.test(name)) continue;
            list.add(name);
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof FilterMechanismSaslClientFactory && this.equals((FilterMechanismSaslClientFactory)other);
    }

    @Override
    public boolean equals(AbstractDelegatingSaslClientFactory other) {
        return other instanceof FilterMechanismSaslClientFactory && this.equals((FilterMechanismSaslClientFactory)other);
    }

    public boolean equals(FilterMechanismSaslClientFactory other) {
        return super.equals(other) && this.predicate.equals(other.predicate);
    }

    @Override
    protected int calculateHashCode() {
        return HashMath.multiHashOrdered(HashMath.multiHashOrdered(super.calculateHashCode(), this.getClass().hashCode()), this.predicate.hashCode());
    }
}

