/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.wildfly.security.ssl.AbstractDelegatingSSLSocketFactory;
import org.wildfly.security.ssl.ConfiguredSSLSocket;
import org.wildfly.security.ssl.SSLConfigurator;

final class ConfiguredSSLSocketFactory
extends AbstractDelegatingSSLSocketFactory {
    private final SSLContext sslContext;
    private final SSLConfigurator sslConfigurator;
    private final boolean wrap;

    ConfiguredSSLSocketFactory(SSLSocketFactory delegate, SSLContext sslContext, SSLConfigurator sslConfigurator, boolean wrap) {
        super(delegate);
        this.sslContext = sslContext;
        this.sslConfigurator = sslConfigurator;
        this.wrap = wrap;
    }

    @Override
    public Socket createSocket(Socket s2, String host, int port, boolean autoClose) throws IOException {
        return this.wrap(super.createSocket(s2, host, port, autoClose));
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.wrap(super.createSocket());
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return this.wrap(super.createSocket(host, port));
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        return this.wrap(super.createSocket(host, port, localHost, localPort));
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.wrap(super.createSocket(host, port));
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.wrap(super.createSocket(address, port, localAddress, localPort));
    }

    @Override
    public Socket createSocket(Socket socket, InputStream inputStream, boolean autoClose) throws IOException {
        return this.wrap(super.createSocket(socket, inputStream, autoClose));
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.sslConfigurator.getDefaultSSLParameters(this.sslContext, this.sslContext.getDefaultSSLParameters()).getCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.sslConfigurator.getSupportedSSLParameters(this.sslContext, this.sslContext.getSupportedSSLParameters()).getCipherSuites();
    }

    private Socket wrap(Socket orig) {
        if (orig instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)orig;
            SSLContext sslContext = this.sslContext;
            SSLConfigurator sslConfigurator = this.sslConfigurator;
            sslConfigurator.configure(sslContext, sslSocket);
            return this.wrap ? new ConfiguredSSLSocket(sslSocket, sslContext, sslConfigurator) : sslSocket;
        }
        return orig;
    }
}

