/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.common;

import io.debezium.config.Configuration;
import io.debezium.connector.common.BaseSourceConnector;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.util.Strings;
import java.util.ArrayList;
import java.util.Map;
import org.apache.kafka.common.config.Config;
import org.apache.kafka.common.config.ConfigValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RelationalBaseSourceConnector
extends BaseSourceConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(RelationalBaseSourceConnector.class);

    @Override
    public Config validate(Map<String, String> connectorConfigs) {
        Configuration config = Configuration.from(connectorConfigs);
        Map<String, ConfigValue> results = this.validateAllFields(config);
        if (Strings.isNullOrEmpty(config.getString(RelationalDatabaseConnectorConfig.PASSWORD))) {
            LOGGER.debug("The connection password is empty");
        }
        if (results.values().stream().allMatch(configValue -> configValue.errorMessages().isEmpty())) {
            this.validateConnection(results, config);
        }
        return new Config(new ArrayList<ConfigValue>(results.values()));
    }

    protected abstract void validateConnection(Map<String, ConfigValue> var1, Configuration var2);
}

