/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.bean.StandardBeanNames;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.common.BaseSourceTask;
import io.debezium.connector.sqlserver.Module;
import io.debezium.connector.sqlserver.SqlServerChangeEventSourceCoordinator;
import io.debezium.connector.sqlserver.SqlServerChangeEventSourceFactory;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnector;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.SqlServerDatabaseSchema;
import io.debezium.connector.sqlserver.SqlServerErrorHandler;
import io.debezium.connector.sqlserver.SqlServerEventMetadataProvider;
import io.debezium.connector.sqlserver.SqlServerOffsetContext;
import io.debezium.connector.sqlserver.SqlServerPartition;
import io.debezium.connector.sqlserver.SqlServerTaskContext;
import io.debezium.connector.sqlserver.SqlServerValueConverters;
import io.debezium.connector.sqlserver.metrics.SqlServerMetricsFactory;
import io.debezium.document.DocumentReader;
import io.debezium.jdbc.DefaultMainConnectionProvidingConnectionFactory;
import io.debezium.pipeline.ChangeEventSourceCoordinator;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.notification.NotificationService;
import io.debezium.pipeline.signal.SignalProcessor;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.pipeline.spi.Offsets;
import io.debezium.relational.TableId;
import io.debezium.schema.SchemaFactory;
import io.debezium.schema.SchemaNameAdjuster;
import io.debezium.snapshot.SnapshotterService;
import io.debezium.spi.topic.TopicNamingStrategy;
import io.debezium.util.Clock;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerConnectorTask
extends BaseSourceTask<SqlServerPartition, SqlServerOffsetContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlServerConnectorTask.class);
    private static final String CONTEXT_NAME = "sql-server-connector-task";
    private volatile SqlServerTaskContext taskContext;
    private volatile ChangeEventQueue<DataChangeEvent> queue;
    private volatile SqlServerConnection dataConnection;
    private volatile SqlServerConnection metadataConnection;
    private volatile SqlServerErrorHandler errorHandler;
    private volatile SqlServerDatabaseSchema schema;

    @Override
    public String version() {
        return Module.version();
    }

    @Override
    public ChangeEventSourceCoordinator<SqlServerPartition, SqlServerOffsetContext> start(Configuration config) {
        Clock clock = Clock.system();
        config = ((Configuration.Builder)config.edit().withDefault("driver.responseBuffering", "adaptive").withDefault("driver.fetchSize", 10000)).build();
        SqlServerConnectorConfig connectorConfig = new SqlServerConnectorConfig(config);
        TopicNamingStrategy topicNamingStrategy = connectorConfig.getTopicNamingStrategy(CommonConnectorConfig.TOPIC_NAMING_STRATEGY, true);
        SchemaNameAdjuster schemaNameAdjuster = connectorConfig.schemaNameAdjuster();
        SqlServerValueConverters valueConverters = new SqlServerValueConverters(connectorConfig.getDecimalMode(), connectorConfig.getTemporalPrecisionMode(), connectorConfig.binaryHandlingMode());
        DefaultMainConnectionProvidingConnectionFactory<SqlServerConnection> connectionFactory = new DefaultMainConnectionProvidingConnectionFactory<SqlServerConnection>(() -> new SqlServerConnection(connectorConfig, valueConverters, connectorConfig.getSkippedOperations(), connectorConfig.useSingleDatabase(), connectorConfig.getOptionRecompile()));
        this.dataConnection = (SqlServerConnection)connectionFactory.mainConnection();
        this.metadataConnection = new SqlServerConnection(connectorConfig, valueConverters, connectorConfig.getSkippedOperations(), connectorConfig.useSingleDatabase());
        this.schema = new SqlServerDatabaseSchema(connectorConfig, this.metadataConnection.getDefaultValueConverter(), valueConverters, topicNamingStrategy, schemaNameAdjuster);
        this.schema.initializeStorage();
        Offsets<SqlServerPartition, SqlServerOffsetContext> offsets = this.getPreviousOffsets(new SqlServerPartition.Provider(connectorConfig), new SqlServerOffsetContext.Loader(connectorConfig));
        connectorConfig.getBeanRegistry().add(StandardBeanNames.CONFIGURATION, config);
        connectorConfig.getBeanRegistry().add("ConnectorConfig", connectorConfig);
        connectorConfig.getBeanRegistry().add("Schema", this.schema);
        connectorConfig.getBeanRegistry().add(StandardBeanNames.JDBC_CONNECTION, this.metadataConnection);
        connectorConfig.getBeanRegistry().add(StandardBeanNames.VALUE_CONVERTER, valueConverters);
        connectorConfig.getBeanRegistry().add(StandardBeanNames.OFFSETS, offsets);
        this.registerServiceProviders(connectorConfig.getServiceRegistry());
        SnapshotterService snapshotterService = connectorConfig.getServiceRegistry().tryGetService(SnapshotterService.class);
        this.validateAndLoadSchemaHistory(connectorConfig, this.dataConnection::validateLogPosition, offsets, this.schema, snapshotterService.getSnapshotter());
        this.taskContext = new SqlServerTaskContext(connectorConfig, this.schema);
        this.queue = new ChangeEventQueue.Builder().pollInterval(connectorConfig.getPollInterval()).maxBatchSize(connectorConfig.getMaxBatchSize()).maxQueueSize(connectorConfig.getMaxQueueSize()).maxQueueSizeInBytes(connectorConfig.getMaxQueueSizeInBytes()).loggingContextSupplier(() -> this.taskContext.configureLoggingContext(CONTEXT_NAME)).build();
        this.errorHandler = new SqlServerErrorHandler(connectorConfig, this.queue, this.errorHandler);
        SqlServerEventMetadataProvider metadataProvider = new SqlServerEventMetadataProvider();
        SignalProcessor<SqlServerPartition, SqlServerOffsetContext> signalProcessor = new SignalProcessor<SqlServerPartition, SqlServerOffsetContext>(SqlServerConnector.class, connectorConfig, Map.of(), this.getAvailableSignalChannels(), DocumentReader.defaultReader(), offsets);
        EventDispatcher<SqlServerPartition, TableId> dispatcher = new EventDispatcher<SqlServerPartition, TableId>((CommonConnectorConfig)connectorConfig, topicNamingStrategy, this.schema, this.queue, connectorConfig.getTableFilters().dataCollectionFilter(), DataChangeEvent::new, (EventMetadataProvider)metadataProvider, schemaNameAdjuster, signalProcessor);
        NotificationService<SqlServerPartition, SqlServerOffsetContext> notificationService = new NotificationService<SqlServerPartition, SqlServerOffsetContext>(this.getNotificationChannels(), connectorConfig, SchemaFactory.get(), dispatcher::enqueueNotification);
        SqlServerChangeEventSourceCoordinator coordinator = new SqlServerChangeEventSourceCoordinator(offsets, this.errorHandler, SqlServerConnector.class, connectorConfig, new SqlServerChangeEventSourceFactory(connectorConfig, connectionFactory, this.metadataConnection, this.errorHandler, dispatcher, clock, this.schema, notificationService, snapshotterService), new SqlServerMetricsFactory(offsets.getPartitions()), dispatcher, this.schema, clock, signalProcessor, notificationService, snapshotterService);
        coordinator.start(this.taskContext, this.queue, metadataProvider);
        return coordinator;
    }

    @Override
    public List<SourceRecord> doPoll() throws InterruptedException {
        List<DataChangeEvent> records = this.queue.poll();
        return records.stream().map(DataChangeEvent::getRecord).collect(Collectors.toList());
    }

    @Override
    protected void resetErrorHandlerRetriesIfNeeded() {
        if (this.coordinator.getErrorHandler().getRetries() > 0 && ((SqlServerChangeEventSourceCoordinator)this.coordinator).firstStreamingIterationCompletedSuccessfully()) {
            this.coordinator.getErrorHandler().resetRetries();
        }
    }

    @Override
    protected void doStop() {
        try {
            if (this.dataConnection != null) {
                this.dataConnection.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("Exception while closing JDBC connection", e);
        }
        try {
            if (this.metadataConnection != null) {
                this.metadataConnection.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("Exception while closing JDBC metadata connection", e);
        }
        if (this.schema != null) {
            this.schema.close();
        }
    }

    @Override
    protected Iterable<Field> getAllConfigurationFields() {
        return SqlServerConnectorConfig.ALL_FIELDS;
    }
}

