/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.annotation.Immutable;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.jdbc.JdbcConfiguration;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;

@Immutable
public interface SqlServerJdbcConfiguration
extends JdbcConfiguration {
    public static final Field INSTANCE = Field.create("instance", "Named instance of the database server");

    public static SqlServerJdbcConfiguration adapt(final Configuration config) {
        if (config instanceof SqlServerJdbcConfiguration) {
            return (SqlServerJdbcConfiguration)config;
        }
        return new SqlServerJdbcConfiguration(){

            @Override
            public Set<String> keys() {
                return config.keys();
            }

            @Override
            public String getString(String key) {
                return config.getString(key);
            }

            public String toString() {
                return config.toString();
            }
        };
    }

    public static Builder copy(final Configuration config) {
        return new Builder(){
            private Configuration.Builder builder;
            {
                this.builder = Configuration.copy(config);
            }

            @Override
            public Builder with(String key, String value) {
                this.builder.with(key, value);
                return this;
            }

            @Override
            public Builder withDefault(String key, String value) {
                this.builder.withDefault(key, value);
                return this;
            }

            @Override
            public Builder without(String key) {
                this.builder.without(key);
                return this;
            }

            @Override
            public Builder apply(Consumer<Builder> function) {
                function.accept(this);
                return this;
            }

            @Override
            public Builder changeString(Field field, Function<String, String> function) {
                this.changeString(field, (Function)function);
                return this;
            }

            @Override
            public Builder changeString(String key, Function<String, String> function) {
                this.changeString(key, (Function)function);
                return this;
            }

            @Override
            public SqlServerJdbcConfiguration build() {
                return SqlServerJdbcConfiguration.adapt(this.builder.build());
            }

            public String toString() {
                return this.builder.toString();
            }
        };
    }

    public static Builder create() {
        return new Builder(){
            private Configuration.Builder builder = Configuration.create();

            @Override
            public Builder with(String key, String value) {
                this.builder.with(key, value);
                return this;
            }

            @Override
            public Builder withDefault(String key, String value) {
                this.builder.withDefault(key, value);
                return this;
            }

            @Override
            public Builder without(String key) {
                this.builder.without(key);
                return this;
            }

            @Override
            public Builder apply(Consumer<Builder> function) {
                function.accept(this);
                return this;
            }

            @Override
            public Builder changeString(Field field, Function<String, String> function) {
                this.changeString(field, (Function)function);
                return this;
            }

            @Override
            public Builder changeString(String key, Function<String, String> function) {
                this.changeString(key, (Function)function);
                return this;
            }

            @Override
            public SqlServerJdbcConfiguration build() {
                return SqlServerJdbcConfiguration.adapt(this.builder.build());
            }

            public String toString() {
                return this.builder.toString();
            }
        };
    }

    default public String getInstance() {
        return this.getString(INSTANCE);
    }

    public static interface Builder
    extends Configuration.ConfigBuilder<SqlServerJdbcConfiguration, Builder> {
        default public Builder withInstance(String instance) {
            return (Builder)this.with(INSTANCE, instance);
        }
    }
}

