/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.converters.recordandmetadata;

import io.debezium.converters.recordandmetadata.RecordAndMetadata;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;

public class RecordAndMetadataBaseImpl
implements RecordAndMetadata {
    private final Struct record;
    private final Schema originalDataSchema;

    public RecordAndMetadataBaseImpl(Struct record, Schema originalDataSchema) {
        this.record = record;
        this.originalDataSchema = originalDataSchema;
    }

    @Override
    public Struct record() {
        return this.record;
    }

    @Override
    public String id() {
        return null;
    }

    @Override
    public String type() {
        return null;
    }

    @Override
    public Struct source() {
        return this.record.getStruct("source");
    }

    @Override
    public String operation() {
        return this.record.getString("op");
    }

    @Override
    public Struct transaction() {
        return this.record.schema().field("transaction") != null ? this.record.getStruct("transaction") : null;
    }

    @Override
    public SchemaAndValue timestamp() {
        String ts_ms = this.record.getInt64("ts_ms").toString();
        Schema ts_msSchema = this.originalDataSchema.field("ts_ms").schema();
        return new SchemaAndValue(ts_msSchema, ts_ms);
    }

    @Override
    public String dataSchemaName() {
        String connectorType = this.source().getString("connector");
        return "io.debezium.connector." + connectorType + ".Data";
    }

    @Override
    public Schema dataSchema(String ... dataFields) {
        SchemaBuilder builder = SchemaBuilder.struct().name(this.dataSchemaName());
        if (dataFields.length == 0) {
            for (Field field : this.originalDataSchema.fields()) {
                builder.field(field.name(), field.schema());
            }
        } else {
            for (String field : dataFields) {
                builder.field(field, this.originalDataSchema.field(field).schema());
            }
        }
        return builder.build();
    }
}

