/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.embedded;

import io.debezium.DebeziumException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.kafka.connect.json.JsonConverter;
import org.apache.kafka.connect.storage.Converter;
import org.apache.kafka.connect.storage.FileOffsetBackingStore;
import org.apache.kafka.connect.storage.KafkaOffsetBackingStore;
import org.apache.kafka.connect.storage.MemoryOffsetBackingStore;
import org.apache.kafka.connect.util.SharedTopicAdmin;

public class KafkaConnectUtil {
    public static final Converter converterForOffsetStore() {
        JsonConverter converter = new JsonConverter();
        converter.configure(Collections.singletonMap("schemas.enable", "false"), true);
        return converter;
    }

    public static final FileOffsetBackingStore fileOffsetBackingStore() {
        return new FileOffsetBackingStore(KafkaConnectUtil.converterForOffsetStore());
    }

    public static final MemoryOffsetBackingStore memoryOffsetBackingStore() {
        return new MemoryOffsetBackingStore(){

            @Override
            public Set<Map<String, Object>> connectorPartitions(String connectorName) {
                return null;
            }
        };
    }

    public static final KafkaOffsetBackingStore kafkaOffsetBackingStore(Map<String, String> config) {
        String clientId = "debezium-server";
        HashMap<String, Object> adminProps = new HashMap<String, Object>(config);
        adminProps.put("client.id", "debezium-servershared-admin");
        Stream.of("bootstrap.servers", "offset.storage.topic", "offset.storage.partitions", "offset.storage.replication.factor").forEach(prop -> {
            if (!adminProps.containsKey(prop)) {
                throw new DebeziumException(String.format("Cannot initialize Kafka offset storage, mandatory configuration option '%s' is missing", prop));
            }
        });
        SharedTopicAdmin sharedAdmin = new SharedTopicAdmin(adminProps);
        return new KafkaOffsetBackingStore(sharedAdmin, () -> "debezium-server", KafkaConnectUtil.converterForOffsetStore());
    }
}

