/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.source.snapshot.incremental;

import io.debezium.jdbc.JdbcConnection;
import io.debezium.pipeline.source.snapshot.incremental.SignalBasedIncrementalSnapshotChangeEventSource;
import io.debezium.pipeline.source.snapshot.incremental.WatermarkWindowCloser;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.spi.schema.DataCollectionId;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteWindowCloser<P extends Partition, T extends DataCollectionId>
implements WatermarkWindowCloser {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteWindowCloser.class);
    public static final String DELETE_STATEMENT = "DELETE FROM %s WHERE id = ?";
    private final JdbcConnection jdbcConnection;
    private final String signalWindowStatement;
    private final SignalBasedIncrementalSnapshotChangeEventSource<P, T> incrementalSnapshotChangeEventSource;

    public DeleteWindowCloser(JdbcConnection jdbcConnection, String signalTable, SignalBasedIncrementalSnapshotChangeEventSource<P, T> incrementalSnapshotChangeEventSource) {
        this.jdbcConnection = jdbcConnection;
        this.signalWindowStatement = String.format(DELETE_STATEMENT, signalTable);
        this.incrementalSnapshotChangeEventSource = incrementalSnapshotChangeEventSource;
    }

    @Override
    public void closeWindow(Partition partition, OffsetContext offsetContext, String chunkId) throws SQLException {
        this.jdbcConnection.prepareUpdate(this.signalWindowStatement, x -> {
            LOGGER.trace("Deleting open window for chunk = '{}'", (Object)chunkId);
            x.setString(1, chunkId + "-open");
        });
        try {
            this.incrementalSnapshotChangeEventSource.closeWindow(partition, chunkId + "-close", offsetContext);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Failed to close window {} successful.", (Object)chunkId);
            Thread.currentThread().interrupt();
        }
        this.jdbcConnection.commit();
    }
}

