/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.schema;

import io.debezium.annotation.ThreadSafe;
import io.debezium.schema.FieldNameUnderscoreReplacementFunction;
import io.debezium.schema.FieldNameUnicodeReplacementFunction;
import io.debezium.schema.UnicodeReplacementFunction;
import io.debezium.spi.common.ReplacementFunction;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionalInterface
@ThreadSafe
public interface SchemaNameAdjuster {
    public static final Logger LOGGER = LoggerFactory.getLogger(SchemaNameAdjuster.class);
    public static final SchemaNameAdjuster NO_OP = proposedName -> proposedName;
    public static final SchemaNameAdjuster AVRO = SchemaNameAdjuster.create();
    public static final SchemaNameAdjuster AVRO_UNICODE = SchemaNameAdjuster.create(new UnicodeReplacementFunction());
    public static final SchemaNameAdjuster AVRO_FIELD_NAMER = SchemaNameAdjuster.create(new FieldNameUnderscoreReplacementFunction());
    public static final SchemaNameAdjuster AVRO_UNICODE_FIELD_NAMER = SchemaNameAdjuster.create(new FieldNameUnicodeReplacementFunction());

    public String adjust(String var1);

    public static SchemaNameAdjuster create() {
        return SchemaNameAdjuster.create(ReplacementFunction.UNDERSCORE_REPLACEMENT);
    }

    public static SchemaNameAdjuster create(ReplacementFunction function) {
        return SchemaNameAdjuster.create(function, (String original, String replacement, String conflict) -> {
            String msg = "The Kafka Connect schema name '" + original + "' is not a valid Avro schema name and its replacement '" + replacement + "' conflicts with another different schema '" + conflict + "'";
            throw new ConnectException(msg);
        });
    }

    public static SchemaNameAdjuster create(ReplacementFunction function, ReplacementOccurred uponConflict) {
        ReplacementOccurred handler = (original, replacement, conflictsWith) -> {
            if (conflictsWith != null) {
                LOGGER.error("The Kafka Connect schema name '{}' is not a valid Avro schema name and its replacement '{}' conflicts with another different schema '{}'", original, replacement, conflictsWith);
                if (uponConflict != null) {
                    uponConflict.accept(original, replacement, conflictsWith);
                }
            } else {
                LOGGER.warn("The Kafka Connect schema name '{}' is not a valid Avro schema name, so replacing with '{}'", (Object)original, (Object)replacement);
            }
        };
        return original -> SchemaNameAdjuster.validFullname(original, function, handler.firstTimeOnly());
    }

    public static SchemaNameAdjuster create(char replacement, ReplacementOccurred uponReplacement) {
        String replacementStr = "" + replacement;
        return original -> SchemaNameAdjuster.validFullname(original, c -> replacementStr, uponReplacement);
    }

    public static SchemaNameAdjuster create(String replacement, ReplacementOccurred uponReplacement) {
        return original -> SchemaNameAdjuster.validFullname(original, c -> replacement, uponReplacement);
    }

    public static boolean isValidFullname(String fullname) {
        if (fullname.length() == 0) {
            return true;
        }
        char c = fullname.charAt(0);
        if (!ReplacementFunction.UNDERSCORE_REPLACEMENT.isValidFirstCharacter(c)) {
            return false;
        }
        for (int i = 1; i != fullname.length(); ++i) {
            c = fullname.charAt(i);
            if (ReplacementFunction.UNDERSCORE_REPLACEMENT.isValidNonFirstCharacter(c)) continue;
            return false;
        }
        return true;
    }

    public static String validFullname(String proposedName) {
        return SchemaNameAdjuster.validFullname(proposedName, "_");
    }

    public static String validFullname(String proposedName, String replacement) {
        return SchemaNameAdjuster.validFullname(proposedName, (char c) -> replacement);
    }

    public static String validFullname(String proposedName, ReplacementFunction replacement) {
        return SchemaNameAdjuster.validFullname(proposedName, replacement, null);
    }

    public static String validFullname(String proposedName, ReplacementFunction replacement, ReplacementOccurred uponReplacement) {
        if (proposedName.length() == 0) {
            return proposedName;
        }
        StringBuilder sb = new StringBuilder();
        char c = proposedName.charAt(0);
        boolean changed = false;
        if (replacement.isValidFirstCharacter(c)) {
            sb.append(c);
        } else {
            sb.append(replacement.replace(c));
            if (Character.isDigit(c) && (replacement == ReplacementFunction.UNDERSCORE_REPLACEMENT || replacement instanceof FieldNameUnderscoreReplacementFunction)) {
                sb.append(c);
            }
            changed = true;
        }
        for (int i = 1; i != proposedName.length(); ++i) {
            c = proposedName.charAt(i);
            if (replacement.isValidNonFirstCharacter(c)) {
                sb.append(c);
                continue;
            }
            sb.append(replacement.replace(c));
            changed = true;
        }
        if (!changed) {
            return proposedName;
        }
        String result = sb.toString();
        if (uponReplacement != null) {
            uponReplacement.accept(proposedName, result, null);
        }
        return result;
    }

    @FunctionalInterface
    @ThreadSafe
    public static interface ReplacementOccurred {
        public void accept(String var1, String var2, String var3);

        default public ReplacementOccurred firstTimeOnly() {
            ReplacementOccurred delegate = this;
            Set alreadySeen = Collections.newSetFromMap(new ConcurrentHashMap());
            ConcurrentHashMap originalByReplacement = new ConcurrentHashMap();
            return (original, replacement, conflictsWith) -> {
                if (alreadySeen.add(original)) {
                    String replacementsOriginal = originalByReplacement.put(replacement, original);
                    if (replacementsOriginal == null || original.equals(replacementsOriginal)) {
                        delegate.accept(original, replacement, null);
                    } else {
                        delegate.accept(original, replacement, replacementsOriginal);
                    }
                }
            };
        }

        default public ReplacementOccurred andThen(ReplacementOccurred next) {
            if (next == null) {
                return this;
            }
            return (original, replacement, conflictsWith) -> {
                this.accept(original, replacement, conflictsWith);
                next.accept(original, replacement, conflictsWith);
            };
        }
    }
}

