/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.storage.file.history;

import io.debezium.DebeziumException;
import io.debezium.annotation.ThreadSafe;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.relational.history.AbstractFileBasedSchemaHistory;
import io.debezium.relational.history.HistoryRecord;
import io.debezium.relational.history.HistoryRecordComparator;
import io.debezium.relational.history.SchemaHistoryException;
import io.debezium.relational.history.SchemaHistoryListener;
import io.debezium.util.Collect;
import io.debezium.util.Loggings;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class FileSchemaHistory
extends AbstractFileBasedSchemaHistory {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSchemaHistory.class);
    public static final Field FILE_PATH = Field.create("schema.history.internal.file.filename").withDescription("The path to the file that will be used to record the database schema history").required();
    public static Collection<Field> ALL_FIELDS = Collect.arrayListOf(FILE_PATH, new Field[0]);
    private Path path;

    @Override
    public void configure(Configuration config, HistoryRecordComparator comparator, SchemaHistoryListener listener, boolean useCatalogBeforeSchema) {
        if (!config.validateAndRecord(ALL_FIELDS, this.logger::error)) {
            throw new DebeziumException("Error configuring an instance of " + this.getClass().getSimpleName() + "; check the logs for details");
        }
        if (this.running.get()) {
            throw new SchemaHistoryException("Database schema history file already initialized to " + this.path);
        }
        super.configure(config, comparator, listener, useCatalogBeforeSchema);
        this.path = Paths.get(config.getString(FILE_PATH), new String[0]);
    }

    @Override
    protected void doStoreRecord(HistoryRecord record) {
        try {
            LOGGER.trace("Storing record into database history: {}", (Object)record);
            this.records.add(record);
            String line = this.documentWriter.write(record.document());
            try (BufferedWriter historyWriter = Files.newBufferedWriter(this.path, StandardOpenOption.APPEND);){
                try {
                    historyWriter.append(line);
                    historyWriter.newLine();
                }
                catch (IOException e) {
                    Loggings.logErrorAndTraceRecord(this.logger, (Object)record, "Failed to add record to history at {}", this.path, e);
                }
            }
            catch (IOException e) {
                throw new SchemaHistoryException("Unable to create writer for history file " + this.path + ": " + e.getMessage(), e);
            }
        }
        catch (IOException e) {
            Loggings.logErrorAndTraceRecord(this.logger, (Object)record, "Failed to convert record to string", e);
        }
    }

    @Override
    protected void doStart() {
        try {
            this.toHistoryRecord(Files.newInputStream(this.path, new OpenOption[0]));
        }
        catch (IOException e) {
            throw new SchemaHistoryException("Can't retrieve file with schema history", e);
        }
    }

    @Override
    public boolean storageExists() {
        return Files.exists(this.path, new LinkOption[0]);
    }

    @Override
    public boolean exists() {
        boolean exists = false;
        if (this.storageExists()) {
            try {
                if (Files.size(this.path) > 0L) {
                    exists = true;
                }
            }
            catch (IOException e) {
                this.logger.error("Unable to determine if history file empty " + this.path + ": " + e.getMessage(), e);
            }
        }
        return exists;
    }

    @Override
    public void initializeStorage() {
        try {
            if (this.path.getParent() != null && !Files.exists(this.path.getParent(), new LinkOption[0])) {
                Files.createDirectories(this.path.getParent(), new FileAttribute[0]);
            }
            try {
                Files.createFile(this.path, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {}
        }
        catch (IOException e) {
            throw new SchemaHistoryException("Unable to create history file at " + this.path + ": " + e.getMessage(), e);
        }
    }

    public String toString() {
        return "file " + (Comparable)(this.path != null ? this.path : "(unstarted)");
    }
}

