/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.debezium;

import io.debezium.embedded.Connect;
import io.debezium.engine.ChangeEvent;
import io.debezium.engine.DebeziumEngine;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.tasks.Output;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.RealtimeTriggerInterface;
import io.kestra.core.models.triggers.TriggerOutput;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.debezium.AbstractDebeziumTask;
import io.kestra.plugin.debezium.ChangeConsumer;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.kafka.connect.source.SourceRecord;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

public abstract class AbstractDebeziumRealtimeTrigger
extends AbstractTrigger
implements RealtimeTriggerInterface,
TriggerOutput<StreamOutput> {
    protected AbstractDebeziumTask.Format format;
    protected AbstractDebeziumTask.Deleted deleted;
    protected String deletedFieldName;
    protected AbstractDebeziumTask.Key key;
    protected AbstractDebeziumTask.Metadata metadata;
    protected String metadataFieldName;
    protected AbstractDebeziumTask.SplitTable splitTable;
    protected Boolean ignoreDdl;
    protected String hostname;
    protected String port;
    protected String username;
    protected String password;
    protected Object includedDatabases;
    protected Object excludedDatabases;
    protected Object includedTables;
    protected Object excludedTables;
    protected Object includedColumns;
    protected Object excludedColumns;
    protected Map<String, String> properties;
    protected String stateName;
    @Schema(title="How to commit the offsets to the state store.", description="Possible values are:\n- ON_EACH_BATCH: after each batch of records consumed by this trigger, the offsets will be stored in the state store. This avoids any duplicated records being consumed but can be costly if a lot of events are produced.\n- ON_STOP: when this trigger is stopped or killed, the offsets will be stored in the state store. This avoid any un-necessary write to the state store, but if the trigger is not stopped gracefully the state store may not be updated leading to duplicated records consumption.")
    @PluginProperty
    private OffsetCommitMode offsetsCommitMode;
    private final AtomicBoolean isActive;
    private final CountDownLatch waitForTermination;
    private final AtomicReference<DebeziumEngine<ChangeEvent<SourceRecord, SourceRecord>>> engineReference;

    public Publisher<StreamOutput> publisher(AbstractDebeziumTask task, RunContext runContext) {
        return Flux.create(sink -> {
            try {
                Path offsetFile = runContext.workingDir().path().resolve("offsets.dat");
                task.restoreState(runContext, offsetFile);
                Path historyFile = runContext.workingDir().path().resolve("dbhistory.dat");
                if (task.needDatabaseHistory()) {
                    task.restoreState(runContext, historyFile);
                }
                Properties props = task.properties(runContext, offsetFile, historyFile);
                ChangeConsumer changeConsumer = new ChangeConsumer(task, runContext, new AtomicInteger(), null, ZonedDateTime.now());
                DebeziumEngine.Builder engineBuilder = DebeziumEngine.create(Connect.class).using(((Object)((Object)this)).getClass().getClassLoader()).using(props).notifying((list, recordCommitter) -> {
                    changeConsumer.handleBatch(list, recordCommitter, (FluxSink<StreamOutput>)sink);
                    if (this.offsetsCommitMode == OffsetCommitMode.ON_EACH_BATCH) {
                        try {
                            AbstractDebeziumRealtimeTrigger.saveOffsets(task, runContext, offsetFile, historyFile);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }).using((success, message, error) -> {
                    if (error != null) {
                        sink.error(error);
                    }
                });
                try (DebeziumEngine engine = engineBuilder.build();){
                    this.engineReference.set(engine);
                    engine.run();
                }
                if (this.offsetsCommitMode == OffsetCommitMode.ON_STOP) {
                    AbstractDebeziumRealtimeTrigger.saveOffsets(task, runContext, offsetFile, historyFile);
                }
            }
            catch (Exception e) {
                sink.error((Throwable)e);
            }
            finally {
                sink.complete();
            }
        });
    }

    private static void saveOffsets(AbstractDebeziumTask task, RunContext runContext, Path offsetFile, Path historyFile) throws IOException {
        if (offsetFile.toFile().exists()) {
            runContext.storage().putTaskStateFile(offsetFile.toFile(), task.stateName, offsetFile.getFileName().toFile().toString());
        }
        if (task.needDatabaseHistory() && historyFile.toFile().exists()) {
            runContext.storage().putTaskStateFile(historyFile.toFile(), task.stateName, historyFile.getFileName().toFile().toString());
        }
    }

    public void kill() {
        this.stop(true);
    }

    public void stop() {
        this.stop(false);
    }

    private void stop(boolean wait) {
        if (!this.isActive.compareAndSet(true, false)) {
            return;
        }
        Optional.ofNullable(this.engineReference.get()).ifPresent(engine -> {
            block9: {
                try (ExecutorService executorService = Executors.newSingleThreadExecutor();){
                    executorService.execute(() -> {
                        try {
                            engine.close();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    });
                    executorService.shutdown();
                    if (!wait) break block9;
                    try {
                        if (!executorService.awaitTermination(1L, TimeUnit.MINUTES)) {
                            executorService.shutdownNow();
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        });
    }

    @Generated
    private static AbstractDebeziumTask.Format $default$format() {
        return AbstractDebeziumTask.Format.INLINE;
    }

    @Generated
    private static AbstractDebeziumTask.Deleted $default$deleted() {
        return AbstractDebeziumTask.Deleted.ADD_FIELD;
    }

    @Generated
    private static String $default$deletedFieldName() {
        return "deleted";
    }

    @Generated
    private static AbstractDebeziumTask.Key $default$key() {
        return AbstractDebeziumTask.Key.ADD_FIELD;
    }

    @Generated
    private static AbstractDebeziumTask.Metadata $default$metadata() {
        return AbstractDebeziumTask.Metadata.ADD_FIELD;
    }

    @Generated
    private static String $default$metadataFieldName() {
        return "metadata";
    }

    @Generated
    private static AbstractDebeziumTask.SplitTable $default$splitTable() {
        return AbstractDebeziumTask.SplitTable.TABLE;
    }

    @Generated
    private static Boolean $default$ignoreDdl() {
        return true;
    }

    @Generated
    private static String $default$stateName() {
        return "debezium-state";
    }

    @Generated
    private static OffsetCommitMode $default$offsetsCommitMode() {
        return OffsetCommitMode.ON_EACH_BATCH;
    }

    @Generated
    private static AtomicBoolean $default$isActive() {
        return new AtomicBoolean(true);
    }

    @Generated
    private static CountDownLatch $default$waitForTermination() {
        return new CountDownLatch(1);
    }

    @Generated
    private static AtomicReference<DebeziumEngine<ChangeEvent<SourceRecord, SourceRecord>>> $default$engineReference() {
        return new AtomicReference<DebeziumEngine<ChangeEvent<SourceRecord, SourceRecord>>>();
    }

    @Generated
    protected AbstractDebeziumRealtimeTrigger(AbstractDebeziumRealtimeTriggerBuilder<?, ?> b) {
        super(b);
        this.format = b.format$set ? b.format$value : AbstractDebeziumRealtimeTrigger.$default$format();
        this.deleted = b.deleted$set ? b.deleted$value : AbstractDebeziumRealtimeTrigger.$default$deleted();
        this.deletedFieldName = b.deletedFieldName$set ? b.deletedFieldName$value : AbstractDebeziumRealtimeTrigger.$default$deletedFieldName();
        this.key = b.key$set ? b.key$value : AbstractDebeziumRealtimeTrigger.$default$key();
        this.metadata = b.metadata$set ? b.metadata$value : AbstractDebeziumRealtimeTrigger.$default$metadata();
        this.metadataFieldName = b.metadataFieldName$set ? b.metadataFieldName$value : AbstractDebeziumRealtimeTrigger.$default$metadataFieldName();
        this.splitTable = b.splitTable$set ? b.splitTable$value : AbstractDebeziumRealtimeTrigger.$default$splitTable();
        this.ignoreDdl = b.ignoreDdl$set ? b.ignoreDdl$value : AbstractDebeziumRealtimeTrigger.$default$ignoreDdl();
        this.hostname = b.hostname;
        this.port = b.port;
        this.username = b.username;
        this.password = b.password;
        this.includedDatabases = b.includedDatabases;
        this.excludedDatabases = b.excludedDatabases;
        this.includedTables = b.includedTables;
        this.excludedTables = b.excludedTables;
        this.includedColumns = b.includedColumns;
        this.excludedColumns = b.excludedColumns;
        this.properties = b.properties;
        this.stateName = b.stateName$set ? b.stateName$value : AbstractDebeziumRealtimeTrigger.$default$stateName();
        this.offsetsCommitMode = b.offsetsCommitMode$set ? b.offsetsCommitMode$value : AbstractDebeziumRealtimeTrigger.$default$offsetsCommitMode();
        this.isActive = b.isActive$set ? b.isActive$value : AbstractDebeziumRealtimeTrigger.$default$isActive();
        this.waitForTermination = b.waitForTermination$set ? b.waitForTermination$value : AbstractDebeziumRealtimeTrigger.$default$waitForTermination();
        this.engineReference = b.engineReference$set ? b.engineReference$value : AbstractDebeziumRealtimeTrigger.$default$engineReference();
    }

    @Generated
    public String toString() {
        return "AbstractDebeziumRealtimeTrigger(super=" + super.toString() + ", format=" + String.valueOf((Object)this.getFormat()) + ", deleted=" + String.valueOf((Object)this.getDeleted()) + ", deletedFieldName=" + this.getDeletedFieldName() + ", key=" + String.valueOf((Object)this.getKey()) + ", metadata=" + String.valueOf((Object)this.getMetadata()) + ", metadataFieldName=" + this.getMetadataFieldName() + ", splitTable=" + String.valueOf((Object)this.getSplitTable()) + ", ignoreDdl=" + this.getIgnoreDdl() + ", hostname=" + this.getHostname() + ", port=" + this.getPort() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", includedDatabases=" + String.valueOf(this.getIncludedDatabases()) + ", excludedDatabases=" + String.valueOf(this.getExcludedDatabases()) + ", includedTables=" + String.valueOf(this.getIncludedTables()) + ", excludedTables=" + String.valueOf(this.getExcludedTables()) + ", includedColumns=" + String.valueOf(this.getIncludedColumns()) + ", excludedColumns=" + String.valueOf(this.getExcludedColumns()) + ", properties=" + String.valueOf(this.getProperties()) + ", stateName=" + this.getStateName() + ", offsetsCommitMode=" + String.valueOf((Object)this.getOffsetsCommitMode()) + ", isActive=" + String.valueOf(this.isActive) + ", waitForTermination=" + String.valueOf(this.waitForTermination) + ", engineReference=" + String.valueOf(this.engineReference) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractDebeziumRealtimeTrigger)) {
            return false;
        }
        AbstractDebeziumRealtimeTrigger other = (AbstractDebeziumRealtimeTrigger)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$ignoreDdl = this.getIgnoreDdl();
        Boolean other$ignoreDdl = other.getIgnoreDdl();
        if (this$ignoreDdl == null ? other$ignoreDdl != null : !((Object)this$ignoreDdl).equals(other$ignoreDdl)) {
            return false;
        }
        AbstractDebeziumTask.Format this$format = this.getFormat();
        AbstractDebeziumTask.Format other$format = other.getFormat();
        if (this$format == null ? other$format != null : !((Object)((Object)this$format)).equals((Object)other$format)) {
            return false;
        }
        AbstractDebeziumTask.Deleted this$deleted = this.getDeleted();
        AbstractDebeziumTask.Deleted other$deleted = other.getDeleted();
        if (this$deleted == null ? other$deleted != null : !((Object)((Object)this$deleted)).equals((Object)other$deleted)) {
            return false;
        }
        String this$deletedFieldName = this.getDeletedFieldName();
        String other$deletedFieldName = other.getDeletedFieldName();
        if (this$deletedFieldName == null ? other$deletedFieldName != null : !this$deletedFieldName.equals(other$deletedFieldName)) {
            return false;
        }
        AbstractDebeziumTask.Key this$key = this.getKey();
        AbstractDebeziumTask.Key other$key = other.getKey();
        if (this$key == null ? other$key != null : !((Object)((Object)this$key)).equals((Object)other$key)) {
            return false;
        }
        AbstractDebeziumTask.Metadata this$metadata = this.getMetadata();
        AbstractDebeziumTask.Metadata other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)((Object)this$metadata)).equals((Object)other$metadata)) {
            return false;
        }
        String this$metadataFieldName = this.getMetadataFieldName();
        String other$metadataFieldName = other.getMetadataFieldName();
        if (this$metadataFieldName == null ? other$metadataFieldName != null : !this$metadataFieldName.equals(other$metadataFieldName)) {
            return false;
        }
        AbstractDebeziumTask.SplitTable this$splitTable = this.getSplitTable();
        AbstractDebeziumTask.SplitTable other$splitTable = other.getSplitTable();
        if (this$splitTable == null ? other$splitTable != null : !((Object)((Object)this$splitTable)).equals((Object)other$splitTable)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        String this$port = this.getPort();
        String other$port = other.getPort();
        if (this$port == null ? other$port != null : !this$port.equals(other$port)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        Object this$includedDatabases = this.getIncludedDatabases();
        Object other$includedDatabases = other.getIncludedDatabases();
        if (this$includedDatabases == null ? other$includedDatabases != null : !this$includedDatabases.equals(other$includedDatabases)) {
            return false;
        }
        Object this$excludedDatabases = this.getExcludedDatabases();
        Object other$excludedDatabases = other.getExcludedDatabases();
        if (this$excludedDatabases == null ? other$excludedDatabases != null : !this$excludedDatabases.equals(other$excludedDatabases)) {
            return false;
        }
        Object this$includedTables = this.getIncludedTables();
        Object other$includedTables = other.getIncludedTables();
        if (this$includedTables == null ? other$includedTables != null : !this$includedTables.equals(other$includedTables)) {
            return false;
        }
        Object this$excludedTables = this.getExcludedTables();
        Object other$excludedTables = other.getExcludedTables();
        if (this$excludedTables == null ? other$excludedTables != null : !this$excludedTables.equals(other$excludedTables)) {
            return false;
        }
        Object this$includedColumns = this.getIncludedColumns();
        Object other$includedColumns = other.getIncludedColumns();
        if (this$includedColumns == null ? other$includedColumns != null : !this$includedColumns.equals(other$includedColumns)) {
            return false;
        }
        Object this$excludedColumns = this.getExcludedColumns();
        Object other$excludedColumns = other.getExcludedColumns();
        if (this$excludedColumns == null ? other$excludedColumns != null : !this$excludedColumns.equals(other$excludedColumns)) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        String this$stateName = this.getStateName();
        String other$stateName = other.getStateName();
        if (this$stateName == null ? other$stateName != null : !this$stateName.equals(other$stateName)) {
            return false;
        }
        OffsetCommitMode this$offsetsCommitMode = this.getOffsetsCommitMode();
        OffsetCommitMode other$offsetsCommitMode = other.getOffsetsCommitMode();
        if (this$offsetsCommitMode == null ? other$offsetsCommitMode != null : !((Object)((Object)this$offsetsCommitMode)).equals((Object)other$offsetsCommitMode)) {
            return false;
        }
        AtomicBoolean this$isActive = this.isActive;
        AtomicBoolean other$isActive = other.isActive;
        if (this$isActive == null ? other$isActive != null : !this$isActive.equals(other$isActive)) {
            return false;
        }
        CountDownLatch this$waitForTermination = this.waitForTermination;
        CountDownLatch other$waitForTermination = other.waitForTermination;
        if (this$waitForTermination == null ? other$waitForTermination != null : !this$waitForTermination.equals(other$waitForTermination)) {
            return false;
        }
        AtomicReference<DebeziumEngine<ChangeEvent<SourceRecord, SourceRecord>>> this$engineReference = this.engineReference;
        AtomicReference<DebeziumEngine<ChangeEvent<SourceRecord, SourceRecord>>> other$engineReference = other.engineReference;
        return !(this$engineReference == null ? other$engineReference != null : !this$engineReference.equals(other$engineReference));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractDebeziumRealtimeTrigger;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $ignoreDdl = this.getIgnoreDdl();
        result = result * 59 + ($ignoreDdl == null ? 43 : ((Object)$ignoreDdl).hashCode());
        AbstractDebeziumTask.Format $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : ((Object)((Object)$format)).hashCode());
        AbstractDebeziumTask.Deleted $deleted = this.getDeleted();
        result = result * 59 + ($deleted == null ? 43 : ((Object)((Object)$deleted)).hashCode());
        String $deletedFieldName = this.getDeletedFieldName();
        result = result * 59 + ($deletedFieldName == null ? 43 : $deletedFieldName.hashCode());
        AbstractDebeziumTask.Key $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : ((Object)((Object)$key)).hashCode());
        AbstractDebeziumTask.Metadata $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)((Object)$metadata)).hashCode());
        String $metadataFieldName = this.getMetadataFieldName();
        result = result * 59 + ($metadataFieldName == null ? 43 : $metadataFieldName.hashCode());
        AbstractDebeziumTask.SplitTable $splitTable = this.getSplitTable();
        result = result * 59 + ($splitTable == null ? 43 : ((Object)((Object)$splitTable)).hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        String $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : $port.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        Object $includedDatabases = this.getIncludedDatabases();
        result = result * 59 + ($includedDatabases == null ? 43 : $includedDatabases.hashCode());
        Object $excludedDatabases = this.getExcludedDatabases();
        result = result * 59 + ($excludedDatabases == null ? 43 : $excludedDatabases.hashCode());
        Object $includedTables = this.getIncludedTables();
        result = result * 59 + ($includedTables == null ? 43 : $includedTables.hashCode());
        Object $excludedTables = this.getExcludedTables();
        result = result * 59 + ($excludedTables == null ? 43 : $excludedTables.hashCode());
        Object $includedColumns = this.getIncludedColumns();
        result = result * 59 + ($includedColumns == null ? 43 : $includedColumns.hashCode());
        Object $excludedColumns = this.getExcludedColumns();
        result = result * 59 + ($excludedColumns == null ? 43 : $excludedColumns.hashCode());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        String $stateName = this.getStateName();
        result = result * 59 + ($stateName == null ? 43 : $stateName.hashCode());
        OffsetCommitMode $offsetsCommitMode = this.getOffsetsCommitMode();
        result = result * 59 + ($offsetsCommitMode == null ? 43 : ((Object)((Object)$offsetsCommitMode)).hashCode());
        AtomicBoolean $isActive = this.isActive;
        result = result * 59 + ($isActive == null ? 43 : $isActive.hashCode());
        CountDownLatch $waitForTermination = this.waitForTermination;
        result = result * 59 + ($waitForTermination == null ? 43 : $waitForTermination.hashCode());
        AtomicReference<DebeziumEngine<ChangeEvent<SourceRecord, SourceRecord>>> $engineReference = this.engineReference;
        result = result * 59 + ($engineReference == null ? 43 : $engineReference.hashCode());
        return result;
    }

    @Generated
    public AbstractDebeziumTask.Format getFormat() {
        return this.format;
    }

    @Generated
    public AbstractDebeziumTask.Deleted getDeleted() {
        return this.deleted;
    }

    @Generated
    public String getDeletedFieldName() {
        return this.deletedFieldName;
    }

    @Generated
    public AbstractDebeziumTask.Key getKey() {
        return this.key;
    }

    @Generated
    public AbstractDebeziumTask.Metadata getMetadata() {
        return this.metadata;
    }

    @Generated
    public String getMetadataFieldName() {
        return this.metadataFieldName;
    }

    @Generated
    public AbstractDebeziumTask.SplitTable getSplitTable() {
        return this.splitTable;
    }

    @Generated
    public Boolean getIgnoreDdl() {
        return this.ignoreDdl;
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Generated
    public String getPort() {
        return this.port;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public Object getIncludedDatabases() {
        return this.includedDatabases;
    }

    @Generated
    public Object getExcludedDatabases() {
        return this.excludedDatabases;
    }

    @Generated
    public Object getIncludedTables() {
        return this.includedTables;
    }

    @Generated
    public Object getExcludedTables() {
        return this.excludedTables;
    }

    @Generated
    public Object getIncludedColumns() {
        return this.includedColumns;
    }

    @Generated
    public Object getExcludedColumns() {
        return this.excludedColumns;
    }

    @Generated
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Generated
    public String getStateName() {
        return this.stateName;
    }

    @Generated
    public OffsetCommitMode getOffsetsCommitMode() {
        return this.offsetsCommitMode;
    }

    @Generated
    public AbstractDebeziumRealtimeTrigger() {
        this.format = AbstractDebeziumRealtimeTrigger.$default$format();
        this.deleted = AbstractDebeziumRealtimeTrigger.$default$deleted();
        this.deletedFieldName = AbstractDebeziumRealtimeTrigger.$default$deletedFieldName();
        this.key = AbstractDebeziumRealtimeTrigger.$default$key();
        this.metadata = AbstractDebeziumRealtimeTrigger.$default$metadata();
        this.metadataFieldName = AbstractDebeziumRealtimeTrigger.$default$metadataFieldName();
        this.splitTable = AbstractDebeziumRealtimeTrigger.$default$splitTable();
        this.ignoreDdl = AbstractDebeziumRealtimeTrigger.$default$ignoreDdl();
        this.stateName = AbstractDebeziumRealtimeTrigger.$default$stateName();
        this.offsetsCommitMode = AbstractDebeziumRealtimeTrigger.$default$offsetsCommitMode();
        this.isActive = AbstractDebeziumRealtimeTrigger.$default$isActive();
        this.waitForTermination = AbstractDebeziumRealtimeTrigger.$default$waitForTermination();
        this.engineReference = AbstractDebeziumRealtimeTrigger.$default$engineReference();
    }

    public static enum OffsetCommitMode {
        ON_EACH_BATCH,
        ON_STOP;

    }

    @Generated
    public static abstract class AbstractDebeziumRealtimeTriggerBuilder<C extends AbstractDebeziumRealtimeTrigger, B extends AbstractDebeziumRealtimeTriggerBuilder<C, B>>
    extends AbstractTrigger.AbstractTriggerBuilder<C, B> {
        @Generated
        private boolean format$set;
        @Generated
        private AbstractDebeziumTask.Format format$value;
        @Generated
        private boolean deleted$set;
        @Generated
        private AbstractDebeziumTask.Deleted deleted$value;
        @Generated
        private boolean deletedFieldName$set;
        @Generated
        private String deletedFieldName$value;
        @Generated
        private boolean key$set;
        @Generated
        private AbstractDebeziumTask.Key key$value;
        @Generated
        private boolean metadata$set;
        @Generated
        private AbstractDebeziumTask.Metadata metadata$value;
        @Generated
        private boolean metadataFieldName$set;
        @Generated
        private String metadataFieldName$value;
        @Generated
        private boolean splitTable$set;
        @Generated
        private AbstractDebeziumTask.SplitTable splitTable$value;
        @Generated
        private boolean ignoreDdl$set;
        @Generated
        private Boolean ignoreDdl$value;
        @Generated
        private String hostname;
        @Generated
        private String port;
        @Generated
        private String username;
        @Generated
        private String password;
        @Generated
        private Object includedDatabases;
        @Generated
        private Object excludedDatabases;
        @Generated
        private Object includedTables;
        @Generated
        private Object excludedTables;
        @Generated
        private Object includedColumns;
        @Generated
        private Object excludedColumns;
        @Generated
        private Map<String, String> properties;
        @Generated
        private boolean stateName$set;
        @Generated
        private String stateName$value;
        @Generated
        private boolean offsetsCommitMode$set;
        @Generated
        private OffsetCommitMode offsetsCommitMode$value;
        @Generated
        private boolean isActive$set;
        @Generated
        private AtomicBoolean isActive$value;
        @Generated
        private boolean waitForTermination$set;
        @Generated
        private CountDownLatch waitForTermination$value;
        @Generated
        private boolean engineReference$set;
        @Generated
        private AtomicReference<DebeziumEngine<ChangeEvent<SourceRecord, SourceRecord>>> engineReference$value;

        @Generated
        public B format(AbstractDebeziumTask.Format format) {
            this.format$value = format;
            this.format$set = true;
            return (B)this.self();
        }

        @Generated
        public B deleted(AbstractDebeziumTask.Deleted deleted) {
            this.deleted$value = deleted;
            this.deleted$set = true;
            return (B)this.self();
        }

        @Generated
        public B deletedFieldName(String deletedFieldName) {
            this.deletedFieldName$value = deletedFieldName;
            this.deletedFieldName$set = true;
            return (B)this.self();
        }

        @Generated
        public B key(AbstractDebeziumTask.Key key) {
            this.key$value = key;
            this.key$set = true;
            return (B)this.self();
        }

        @Generated
        public B metadata(AbstractDebeziumTask.Metadata metadata) {
            this.metadata$value = metadata;
            this.metadata$set = true;
            return (B)this.self();
        }

        @Generated
        public B metadataFieldName(String metadataFieldName) {
            this.metadataFieldName$value = metadataFieldName;
            this.metadataFieldName$set = true;
            return (B)this.self();
        }

        @Generated
        public B splitTable(AbstractDebeziumTask.SplitTable splitTable) {
            this.splitTable$value = splitTable;
            this.splitTable$set = true;
            return (B)this.self();
        }

        @Generated
        public B ignoreDdl(Boolean ignoreDdl) {
            this.ignoreDdl$value = ignoreDdl;
            this.ignoreDdl$set = true;
            return (B)this.self();
        }

        @Generated
        public B hostname(String hostname) {
            this.hostname = hostname;
            return (B)this.self();
        }

        @Generated
        public B port(String port) {
            this.port = port;
            return (B)this.self();
        }

        @Generated
        public B username(String username) {
            this.username = username;
            return (B)this.self();
        }

        @Generated
        public B password(String password) {
            this.password = password;
            return (B)this.self();
        }

        @Generated
        public B includedDatabases(Object includedDatabases) {
            this.includedDatabases = includedDatabases;
            return (B)this.self();
        }

        @Generated
        public B excludedDatabases(Object excludedDatabases) {
            this.excludedDatabases = excludedDatabases;
            return (B)this.self();
        }

        @Generated
        public B includedTables(Object includedTables) {
            this.includedTables = includedTables;
            return (B)this.self();
        }

        @Generated
        public B excludedTables(Object excludedTables) {
            this.excludedTables = excludedTables;
            return (B)this.self();
        }

        @Generated
        public B includedColumns(Object includedColumns) {
            this.includedColumns = includedColumns;
            return (B)this.self();
        }

        @Generated
        public B excludedColumns(Object excludedColumns) {
            this.excludedColumns = excludedColumns;
            return (B)this.self();
        }

        @Generated
        public B properties(Map<String, String> properties) {
            this.properties = properties;
            return (B)this.self();
        }

        @Generated
        public B stateName(String stateName) {
            this.stateName$value = stateName;
            this.stateName$set = true;
            return (B)this.self();
        }

        @Generated
        public B offsetsCommitMode(OffsetCommitMode offsetsCommitMode) {
            this.offsetsCommitMode$value = offsetsCommitMode;
            this.offsetsCommitMode$set = true;
            return (B)this.self();
        }

        @Generated
        public B isActive(AtomicBoolean isActive) {
            this.isActive$value = isActive;
            this.isActive$set = true;
            return (B)this.self();
        }

        @Generated
        public B waitForTermination(CountDownLatch waitForTermination) {
            this.waitForTermination$value = waitForTermination;
            this.waitForTermination$set = true;
            return (B)this.self();
        }

        @Generated
        public B engineReference(AtomicReference<DebeziumEngine<ChangeEvent<SourceRecord, SourceRecord>>> engineReference) {
            this.engineReference$value = engineReference;
            this.engineReference$set = true;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "AbstractDebeziumRealtimeTrigger.AbstractDebeziumRealtimeTriggerBuilder(super=" + super.toString() + ", format$value=" + String.valueOf((Object)this.format$value) + ", deleted$value=" + String.valueOf((Object)this.deleted$value) + ", deletedFieldName$value=" + this.deletedFieldName$value + ", key$value=" + String.valueOf((Object)this.key$value) + ", metadata$value=" + String.valueOf((Object)this.metadata$value) + ", metadataFieldName$value=" + this.metadataFieldName$value + ", splitTable$value=" + String.valueOf((Object)this.splitTable$value) + ", ignoreDdl$value=" + this.ignoreDdl$value + ", hostname=" + this.hostname + ", port=" + this.port + ", username=" + this.username + ", password=" + this.password + ", includedDatabases=" + String.valueOf(this.includedDatabases) + ", excludedDatabases=" + String.valueOf(this.excludedDatabases) + ", includedTables=" + String.valueOf(this.includedTables) + ", excludedTables=" + String.valueOf(this.excludedTables) + ", includedColumns=" + String.valueOf(this.includedColumns) + ", excludedColumns=" + String.valueOf(this.excludedColumns) + ", properties=" + String.valueOf(this.properties) + ", stateName$value=" + this.stateName$value + ", offsetsCommitMode$value=" + String.valueOf((Object)this.offsetsCommitMode$value) + ", isActive$value=" + String.valueOf(this.isActive$value) + ", waitForTermination$value=" + String.valueOf(this.waitForTermination$value) + ", engineReference$value=" + String.valueOf(this.engineReference$value) + ")";
        }
    }

    public static class StreamOutput
    implements Output {
        private String stream;
        private Map<String, Object> data;

        @ConstructorProperties(value={"stream", "data"})
        @Generated
        StreamOutput(String stream, Map<String, Object> data) {
            this.stream = stream;
            this.data = data;
        }

        @Generated
        public static StreamOutputBuilder builder() {
            return new StreamOutputBuilder();
        }

        @Generated
        public String getStream() {
            return this.stream;
        }

        @Generated
        public Map<String, Object> getData() {
            return this.data;
        }

        @Generated
        public static class StreamOutputBuilder {
            @Generated
            private String stream;
            @Generated
            private Map<String, Object> data;

            @Generated
            StreamOutputBuilder() {
            }

            @Generated
            public StreamOutputBuilder stream(String stream) {
                this.stream = stream;
                return this;
            }

            @Generated
            public StreamOutputBuilder data(Map<String, Object> data) {
                this.data = data;
                return this;
            }

            @Generated
            public StreamOutput build() {
                return new StreamOutput(this.stream, this.data);
            }

            @Generated
            public String toString() {
                return "AbstractDebeziumRealtimeTrigger.StreamOutput.StreamOutputBuilder(stream=" + this.stream + ", data=" + String.valueOf(this.data) + ")";
            }
        }
    }
}

