/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.debezium.sqlserver;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.tasks.Output;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.TriggerContext;
import io.kestra.core.models.triggers.TriggerService;
import io.kestra.plugin.debezium.AbstractDebeziumInterface;
import io.kestra.plugin.debezium.AbstractDebeziumRealtimeTrigger;
import io.kestra.plugin.debezium.AbstractDebeziumTask;
import io.kestra.plugin.debezium.sqlserver.Capture;
import io.kestra.plugin.debezium.sqlserver.SqlServerInterface;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Schema(title="Consume a message in real-time from a SQL Server database via change data capture and create one execution per row.", description="If you would like to consume multiple messages processed within a given time frame and process them in batch, you can use the [io.kestra.plugin.debezium.sqlserver.Trigger](https://kestra.io/plugins/plugin-debezium/triggers/io.kestra.plugin.debezium.sqlserver.trigger) instead.")
@Plugin(examples={@Example(title="Consume a message from a SQL Server database via change data capture in real-time.", full=true, code={"id: debezium-sqlserver\nnamespace: company.team\n\ntasks:\n  - id: send_data\n    type: io.kestra.plugin.core.log.Log\n    message: \"{{ trigger.data }}\"\n\ntriggers:\n  - id: realtime\n    type: io.kestra.plugin.debezium.sqlserver.RealtimeTrigger\n    hostname: 127.0.0.1\n    port: 61433\n    username: sa\n    password: password\n    database: deb"})})
public class RealtimeTrigger
extends AbstractDebeziumRealtimeTrigger
implements SqlServerInterface,
AbstractDebeziumInterface {
    protected String database;
    private SqlServerInterface.SnapshotMode snapshotMode;
    private String serverId;

    public Publisher<Execution> evaluate(ConditionContext conditionContext, TriggerContext context) throws Exception {
        AbstractDebeziumTask task = ((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Capture.CaptureBuilder)Capture.builder().id(this.id)).type(Capture.class.getName())).format(this.format))).deleted(this.deleted))).deletedFieldName(this.deletedFieldName))).key(this.key))).metadata(this.metadata))).metadataFieldName(this.metadataFieldName))).splitTable(this.splitTable))).ignoreDdl(this.ignoreDdl))).hostname(this.hostname))).port(this.port))).username(this.username))).password(this.password))).includedDatabases(this.includedDatabases))).excludedDatabases(this.excludedDatabases))).includedTables(this.includedTables))).excludedTables(this.excludedTables))).includedColumns(this.includedColumns))).excludedColumns(this.excludedColumns))).properties(this.properties))).stateName(this.stateName))).snapshotMode(this.snapshotMode))).database(this.database))).build();
        return Flux.from(this.publisher(task, conditionContext.getRunContext())).map(output -> TriggerService.generateRealtimeExecution((AbstractTrigger)this, (ConditionContext)conditionContext, (TriggerContext)context, (Output)output));
    }

    @Generated
    private static SqlServerInterface.SnapshotMode $default$snapshotMode() {
        return SqlServerInterface.SnapshotMode.INITIAL;
    }

    @Generated
    protected RealtimeTrigger(RealtimeTriggerBuilder<?, ?> b) {
        super(b);
        this.database = b.database;
        this.snapshotMode = b.snapshotMode$set ? b.snapshotMode$value : RealtimeTrigger.$default$snapshotMode();
        this.serverId = b.serverId;
    }

    @Generated
    public static RealtimeTriggerBuilder<?, ?> builder() {
        return new RealtimeTriggerBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "RealtimeTrigger(super=" + super.toString() + ", database=" + this.getDatabase() + ", snapshotMode=" + String.valueOf((Object)this.getSnapshotMode()) + ", serverId=" + this.getServerId() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RealtimeTrigger)) {
            return false;
        }
        RealtimeTrigger other = (RealtimeTrigger)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        SqlServerInterface.SnapshotMode this$snapshotMode = this.getSnapshotMode();
        SqlServerInterface.SnapshotMode other$snapshotMode = other.getSnapshotMode();
        if (this$snapshotMode == null ? other$snapshotMode != null : !((Object)((Object)this$snapshotMode)).equals((Object)other$snapshotMode)) {
            return false;
        }
        String this$serverId = this.getServerId();
        String other$serverId = other.getServerId();
        return !(this$serverId == null ? other$serverId != null : !this$serverId.equals(other$serverId));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RealtimeTrigger;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        SqlServerInterface.SnapshotMode $snapshotMode = this.getSnapshotMode();
        result = result * 59 + ($snapshotMode == null ? 43 : ((Object)((Object)$snapshotMode)).hashCode());
        String $serverId = this.getServerId();
        result = result * 59 + ($serverId == null ? 43 : $serverId.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getDatabase() {
        return this.database;
    }

    @Override
    @Generated
    public SqlServerInterface.SnapshotMode getSnapshotMode() {
        return this.snapshotMode;
    }

    @Generated
    public String getServerId() {
        return this.serverId;
    }

    @Generated
    public RealtimeTrigger() {
        this.snapshotMode = RealtimeTrigger.$default$snapshotMode();
    }

    @Generated
    public static abstract class RealtimeTriggerBuilder<C extends RealtimeTrigger, B extends RealtimeTriggerBuilder<C, B>>
    extends AbstractDebeziumRealtimeTrigger.AbstractDebeziumRealtimeTriggerBuilder<C, B> {
        @Generated
        private String database;
        @Generated
        private boolean snapshotMode$set;
        @Generated
        private SqlServerInterface.SnapshotMode snapshotMode$value;
        @Generated
        private String serverId;

        @Generated
        public B database(String database) {
            this.database = database;
            return (B)((Object)this.self());
        }

        @Generated
        public B snapshotMode(SqlServerInterface.SnapshotMode snapshotMode) {
            this.snapshotMode$value = snapshotMode;
            this.snapshotMode$set = true;
            return (B)((Object)this.self());
        }

        @Generated
        public B serverId(String serverId) {
            this.serverId = serverId;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "RealtimeTrigger.RealtimeTriggerBuilder(super=" + super.toString() + ", database=" + this.database + ", snapshotMode$value=" + String.valueOf((Object)this.snapshotMode$value) + ", serverId=" + this.serverId + ")";
        }
    }

    @Generated
    private static final class RealtimeTriggerBuilderImpl
    extends RealtimeTriggerBuilder<RealtimeTrigger, RealtimeTriggerBuilderImpl> {
        @Generated
        private RealtimeTriggerBuilderImpl() {
        }

        @Override
        @Generated
        protected RealtimeTriggerBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public RealtimeTrigger build() {
            return new RealtimeTrigger(this);
        }
    }
}

