/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.debezium.sqlserver;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.tasks.Output;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.TriggerContext;
import io.kestra.core.models.triggers.TriggerService;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.debezium.AbstractDebeziumInterface;
import io.kestra.plugin.debezium.AbstractDebeziumTask;
import io.kestra.plugin.debezium.AbstractDebeziumTrigger;
import io.kestra.plugin.debezium.sqlserver.Capture;
import io.kestra.plugin.debezium.sqlserver.SqlServerInterface;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;

@Schema(title="Consume messages periodically from a SQL Server database via change data capture and create one execution per batch.", description="If you would like to consume each message from change data capture in real-time and create one execution per message, you can use the [io.kestra.plugin.debezium.sqlserver.RealtimeTrigger](https://kestra.io/plugins/plugin-debezium/triggers/io.kestra.plugin.debezium.sqlserver.realtimetrigger) instead.")
@Plugin(examples={@Example(code={"snapshotMode: INITIAL", "hostname: 127.0.0.1", "port: \"1433\"", "username: sqlserver_user", "password: sqlserver_passwd", "database: deb", "maxRecords: 100"})})
public class Trigger
extends AbstractDebeziumTrigger
implements SqlServerInterface,
AbstractDebeziumInterface {
    protected String database;
    private SqlServerInterface.SnapshotMode snapshotMode;
    private String serverId;

    public Optional<Execution> evaluate(ConditionContext conditionContext, TriggerContext context) throws Exception {
        RunContext runContext = conditionContext.getRunContext();
        Logger logger = runContext.logger();
        AbstractDebeziumTask task = ((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Object)((Capture.CaptureBuilder)((Capture.CaptureBuilder)Capture.builder().id(this.id)).type(Capture.class.getName())).format(this.format))).deleted(this.deleted))).deletedFieldName(this.deletedFieldName))).key(this.key))).metadata(this.metadata))).metadataFieldName(this.metadataFieldName))).splitTable(this.splitTable))).ignoreDdl(this.ignoreDdl))).hostname(this.hostname))).port(this.port))).username(this.username))).password(this.password))).includedDatabases(this.includedDatabases))).excludedDatabases(this.excludedDatabases))).includedTables(this.includedTables))).excludedTables(this.excludedTables))).includedColumns(this.includedColumns))).excludedColumns(this.excludedColumns))).properties(this.properties))).stateName(this.stateName))).maxRecords(this.maxRecords))).maxDuration(this.maxDuration))).maxWait(this.maxWait))).maxSnapshotDuration(this.maxSnapshotDuration))).snapshotMode(this.snapshotMode))).database(this.database))).build();
        AbstractDebeziumTask.Output run = task.run(runContext);
        if (logger.isDebugEnabled()) {
            logger.debug("Found '{}' messages", (Object)run.getSize());
        }
        if (run.getSize() == 0) {
            return Optional.empty();
        }
        Execution execution = TriggerService.generateExecution((AbstractTrigger)this, (ConditionContext)conditionContext, (TriggerContext)context, (Output)run);
        return Optional.of(execution);
    }

    @Generated
    private static SqlServerInterface.SnapshotMode $default$snapshotMode() {
        return SqlServerInterface.SnapshotMode.INITIAL;
    }

    @Generated
    protected Trigger(TriggerBuilder<?, ?> b) {
        super(b);
        this.database = b.database;
        this.snapshotMode = b.snapshotMode$set ? b.snapshotMode$value : Trigger.$default$snapshotMode();
        this.serverId = b.serverId;
    }

    @Generated
    public static TriggerBuilder<?, ?> builder() {
        return new TriggerBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "Trigger(super=" + super.toString() + ", database=" + this.getDatabase() + ", snapshotMode=" + String.valueOf((Object)this.getSnapshotMode()) + ", serverId=" + this.getServerId() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Trigger)) {
            return false;
        }
        Trigger other = (Trigger)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        SqlServerInterface.SnapshotMode this$snapshotMode = this.getSnapshotMode();
        SqlServerInterface.SnapshotMode other$snapshotMode = other.getSnapshotMode();
        if (this$snapshotMode == null ? other$snapshotMode != null : !((Object)((Object)this$snapshotMode)).equals((Object)other$snapshotMode)) {
            return false;
        }
        String this$serverId = this.getServerId();
        String other$serverId = other.getServerId();
        return !(this$serverId == null ? other$serverId != null : !this$serverId.equals(other$serverId));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Trigger;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        SqlServerInterface.SnapshotMode $snapshotMode = this.getSnapshotMode();
        result = result * 59 + ($snapshotMode == null ? 43 : ((Object)((Object)$snapshotMode)).hashCode());
        String $serverId = this.getServerId();
        result = result * 59 + ($serverId == null ? 43 : $serverId.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getDatabase() {
        return this.database;
    }

    @Override
    @Generated
    public SqlServerInterface.SnapshotMode getSnapshotMode() {
        return this.snapshotMode;
    }

    @Generated
    public String getServerId() {
        return this.serverId;
    }

    @Generated
    public Trigger() {
        this.snapshotMode = Trigger.$default$snapshotMode();
    }

    @Generated
    public static abstract class TriggerBuilder<C extends Trigger, B extends TriggerBuilder<C, B>>
    extends AbstractDebeziumTrigger.AbstractDebeziumTriggerBuilder<C, B> {
        @Generated
        private String database;
        @Generated
        private boolean snapshotMode$set;
        @Generated
        private SqlServerInterface.SnapshotMode snapshotMode$value;
        @Generated
        private String serverId;

        @Generated
        public B database(String database) {
            this.database = database;
            return (B)((Object)this.self());
        }

        @Generated
        public B snapshotMode(SqlServerInterface.SnapshotMode snapshotMode) {
            this.snapshotMode$value = snapshotMode;
            this.snapshotMode$set = true;
            return (B)((Object)this.self());
        }

        @Generated
        public B serverId(String serverId) {
            this.serverId = serverId;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Trigger.TriggerBuilder(super=" + super.toString() + ", database=" + this.database + ", snapshotMode$value=" + String.valueOf((Object)this.snapshotMode$value) + ", serverId=" + this.serverId + ")";
        }
    }

    @Generated
    private static final class TriggerBuilderImpl
    extends TriggerBuilder<Trigger, TriggerBuilderImpl> {
        @Generated
        private TriggerBuilderImpl() {
        }

        @Override
        @Generated
        protected TriggerBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Trigger build() {
            return new Trigger(this);
        }
    }
}

