/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.io.Closeable;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.kafka.clients.MetadataSnapshot;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.ClusterResourceListener;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InvalidMetadataException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.internals.ClusterResourceListeners;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

public class Metadata
implements Closeable {
    private final Logger log;
    private final ExponentialBackoff refreshBackoff;
    private final long metadataExpireMs;
    private int updateVersion;
    private int requestVersion;
    private long lastRefreshMs;
    private long lastSuccessfulRefreshMs;
    private long attempts;
    private KafkaException fatalException;
    private Set<String> invalidTopics;
    private Set<String> unauthorizedTopics;
    private volatile MetadataSnapshot metadataSnapshot = MetadataSnapshot.empty();
    private boolean needFullUpdate;
    private boolean needPartialUpdate;
    private long equivalentResponseCount;
    private final ClusterResourceListeners clusterResourceListeners;
    private boolean isClosed;
    private final Map<TopicPartition, Integer> lastSeenLeaderEpochs;

    public Metadata(long refreshBackoffMs, long refreshBackoffMaxMs, long metadataExpireMs, LogContext logContext, ClusterResourceListeners clusterResourceListeners) {
        this.log = logContext.logger(Metadata.class);
        this.refreshBackoff = new ExponentialBackoff(refreshBackoffMs, 2, refreshBackoffMaxMs, 0.2);
        this.metadataExpireMs = metadataExpireMs;
        this.lastRefreshMs = 0L;
        this.lastSuccessfulRefreshMs = 0L;
        this.attempts = 0L;
        this.requestVersion = 0;
        this.updateVersion = 0;
        this.needFullUpdate = false;
        this.needPartialUpdate = false;
        this.equivalentResponseCount = 0L;
        this.clusterResourceListeners = clusterResourceListeners;
        this.isClosed = false;
        this.lastSeenLeaderEpochs = new HashMap<TopicPartition, Integer>();
        this.invalidTopics = Collections.emptySet();
        this.unauthorizedTopics = Collections.emptySet();
    }

    public Cluster fetch() {
        return this.metadataSnapshot.cluster();
    }

    public MetadataSnapshot fetchMetadataSnapshot() {
        return this.metadataSnapshot;
    }

    public synchronized long timeToAllowUpdate(long nowMs) {
        long backoffForAttempts = Math.max(this.lastRefreshMs + this.refreshBackoff.backoff(this.attempts > 0L ? this.attempts - 1L : 0L) - nowMs, 0L);
        if (Math.max(this.lastSuccessfulRefreshMs + this.metadataExpireMs - nowMs, 0L) == 0L) {
            this.equivalentResponseCount = 0L;
        }
        long backoffForEquivalentResponseCount = Math.max(this.lastRefreshMs + (this.equivalentResponseCount > 0L ? this.refreshBackoff.backoff(this.equivalentResponseCount - 1L) : 0L) - nowMs, 0L);
        return Math.max(backoffForAttempts, backoffForEquivalentResponseCount);
    }

    public synchronized long timeToNextUpdate(long nowMs) {
        long timeToExpire = this.updateRequested() ? 0L : Math.max(this.lastSuccessfulRefreshMs + this.metadataExpireMs - nowMs, 0L);
        return Math.max(timeToExpire, this.timeToAllowUpdate(nowMs));
    }

    public long metadataExpireMs() {
        return this.metadataExpireMs;
    }

    public synchronized int requestUpdate(boolean resetEquivalentResponseBackoff) {
        this.needFullUpdate = true;
        if (resetEquivalentResponseBackoff) {
            this.equivalentResponseCount = 0L;
        }
        return this.updateVersion;
    }

    public synchronized int requestUpdateForNewTopics() {
        this.lastRefreshMs = 0L;
        this.needPartialUpdate = true;
        this.equivalentResponseCount = 0L;
        ++this.requestVersion;
        return this.updateVersion;
    }

    public synchronized boolean updateLastSeenEpochIfNewer(TopicPartition topicPartition, int leaderEpoch) {
        boolean updated;
        Objects.requireNonNull(topicPartition, "TopicPartition cannot be null");
        if (leaderEpoch < 0) {
            throw new IllegalArgumentException("Invalid leader epoch " + leaderEpoch + " (must be non-negative)");
        }
        Integer oldEpoch = this.lastSeenLeaderEpochs.get(topicPartition);
        this.log.trace("Determining if we should replace existing epoch {} with new epoch {} for partition {}", oldEpoch, leaderEpoch, topicPartition);
        if (oldEpoch == null) {
            this.log.debug("Not replacing null epoch with new epoch {} for partition {}", (Object)leaderEpoch, (Object)topicPartition);
            updated = false;
        } else if (leaderEpoch > oldEpoch) {
            this.log.debug("Updating last seen epoch from {} to {} for partition {}", oldEpoch, leaderEpoch, topicPartition);
            this.lastSeenLeaderEpochs.put(topicPartition, leaderEpoch);
            updated = true;
        } else {
            this.log.debug("Not replacing existing epoch {} with new epoch {} for partition {}", oldEpoch, leaderEpoch, topicPartition);
            updated = false;
        }
        this.needFullUpdate = this.needFullUpdate || updated;
        return updated;
    }

    public Optional<Integer> lastSeenLeaderEpoch(TopicPartition topicPartition) {
        return Optional.ofNullable(this.lastSeenLeaderEpochs.get(topicPartition));
    }

    public synchronized boolean updateRequested() {
        return this.needFullUpdate || this.needPartialUpdate;
    }

    public synchronized void addClusterUpdateListener(ClusterResourceListener listener) {
        this.clusterResourceListeners.maybeAdd(listener);
    }

    synchronized Optional<MetadataResponse.PartitionMetadata> partitionMetadataIfCurrent(TopicPartition topicPartition) {
        Integer epoch = this.lastSeenLeaderEpochs.get(topicPartition);
        Optional<MetadataResponse.PartitionMetadata> partitionMetadata = this.metadataSnapshot.partitionMetadata(topicPartition);
        if (epoch == null) {
            return partitionMetadata;
        }
        return partitionMetadata.filter(metadata -> metadata.leaderEpoch.orElse(-1).equals(epoch));
    }

    public Map<String, Uuid> topicIds() {
        return this.metadataSnapshot.topicIds();
    }

    public synchronized LeaderAndEpoch currentLeader(TopicPartition topicPartition) {
        Optional<MetadataResponse.PartitionMetadata> maybeMetadata = this.partitionMetadataIfCurrent(topicPartition);
        if (!maybeMetadata.isPresent()) {
            return new LeaderAndEpoch(Optional.empty(), Optional.ofNullable(this.lastSeenLeaderEpochs.get(topicPartition)));
        }
        MetadataResponse.PartitionMetadata partitionMetadata = maybeMetadata.get();
        Optional<Integer> leaderEpochOpt = partitionMetadata.leaderEpoch;
        Optional<Node> leaderNodeOpt = partitionMetadata.leaderId.flatMap(this.metadataSnapshot::nodeById);
        return new LeaderAndEpoch(leaderNodeOpt, leaderEpochOpt);
    }

    public synchronized void bootstrap(List<InetSocketAddress> addresses) {
        this.needFullUpdate = true;
        ++this.updateVersion;
        this.metadataSnapshot = MetadataSnapshot.bootstrap(addresses);
    }

    public synchronized void updateWithCurrentRequestVersion(MetadataResponse response, boolean isPartialUpdate, long nowMs) {
        this.update(this.requestVersion, response, isPartialUpdate, nowMs);
    }

    public synchronized void update(int requestVersion, MetadataResponse response, boolean isPartialUpdate, long nowMs) {
        Objects.requireNonNull(response, "Metadata response cannot be null");
        if (this.isClosed()) {
            throw new IllegalStateException("Update requested after metadata close");
        }
        this.needPartialUpdate = requestVersion < this.requestVersion;
        this.lastRefreshMs = nowMs;
        this.attempts = 0L;
        ++this.updateVersion;
        if (!isPartialUpdate) {
            this.needFullUpdate = false;
            this.lastSuccessfulRefreshMs = nowMs;
        }
        ++this.equivalentResponseCount;
        String previousClusterId = this.metadataSnapshot.clusterResource().clusterId();
        this.metadataSnapshot = this.handleMetadataResponse(response, isPartialUpdate, nowMs);
        Cluster cluster = this.metadataSnapshot.cluster();
        this.maybeSetMetadataError(cluster);
        this.lastSeenLeaderEpochs.keySet().removeIf(tp -> !this.retainTopic(tp.topic(), false, nowMs));
        String newClusterId = this.metadataSnapshot.clusterResource().clusterId();
        if (!Objects.equals(previousClusterId, newClusterId)) {
            this.log.info("Cluster ID: {}", (Object)newClusterId);
        }
        this.clusterResourceListeners.onUpdate(this.metadataSnapshot.clusterResource());
        this.log.debug("Updated cluster metadata updateVersion {} to {}", (Object)this.updateVersion, (Object)this.metadataSnapshot);
    }

    public synchronized Set<TopicPartition> updatePartitionLeadership(Map<TopicPartition, LeaderIdAndEpoch> partitionLeaders, List<Node> leaderNodes) {
        Map<Integer, Node> newNodes = leaderNodes.stream().collect(Collectors.toMap(Node::id, node -> node));
        this.metadataSnapshot.cluster().nodes().stream().forEach(node -> newNodes.putIfAbsent(node.id(), (Node)node));
        ArrayList<MetadataResponse.PartitionMetadata> updatePartitionMetadata = new ArrayList<MetadataResponse.PartitionMetadata>();
        for (Map.Entry<TopicPartition, LeaderIdAndEpoch> partitionLeader : partitionLeaders.entrySet()) {
            TopicPartition partition = partitionLeader.getKey();
            LeaderAndEpoch currentLeader = this.currentLeader(partition);
            LeaderIdAndEpoch newLeader = partitionLeader.getValue();
            if (!newLeader.epoch.isPresent() || !newLeader.leaderId.isPresent()) {
                this.log.debug("For {}, incoming leader information is incomplete {}", (Object)partition, (Object)newLeader);
                continue;
            }
            if (currentLeader.epoch.isPresent() && newLeader.epoch.get() <= currentLeader.epoch.get()) {
                this.log.debug("For {}, incoming leader({}) is not-newer than the one in the existing metadata {}, so ignoring.", partition, newLeader, currentLeader);
                continue;
            }
            if (!newNodes.containsKey(newLeader.leaderId.get())) {
                this.log.debug("For {}, incoming leader({}), the corresponding node information for node-id {} is missing, so ignoring.", partition, newLeader, newLeader.leaderId.get());
                continue;
            }
            if (!this.metadataSnapshot.partitionMetadata(partition).isPresent()) {
                this.log.debug("For {}, incoming leader({}), partition metadata is no longer cached, ignoring.", (Object)partition, (Object)newLeader);
                continue;
            }
            MetadataResponse.PartitionMetadata existingMetadata = this.metadataSnapshot.partitionMetadata(partition).get();
            MetadataResponse.PartitionMetadata updatedMetadata = new MetadataResponse.PartitionMetadata(existingMetadata.error, partition, newLeader.leaderId, newLeader.epoch, existingMetadata.replicaIds, existingMetadata.inSyncReplicaIds, existingMetadata.offlineReplicaIds);
            updatePartitionMetadata.add(updatedMetadata);
            this.lastSeenLeaderEpochs.put(partition, newLeader.epoch.get());
        }
        if (updatePartitionMetadata.isEmpty()) {
            this.log.debug("No relevant metadata updates.");
            return new HashSet<TopicPartition>();
        }
        Set updatedTopics = updatePartitionMetadata.stream().map(MetadataResponse.PartitionMetadata::topic).collect(Collectors.toSet());
        Map<String, Uuid> existingTopicIds = this.metadataSnapshot.topicIds();
        Map<String, Uuid> topicIdsForUpdatedTopics = updatedTopics.stream().filter(e -> existingTopicIds.containsKey(e)).collect(Collectors.toMap(e -> e, e -> (Uuid)existingTopicIds.get(e)));
        if (this.log.isDebugEnabled()) {
            updatePartitionMetadata.forEach(partMetadata -> this.log.debug("For {} updating leader information, updated metadata is {}.", (Object)partMetadata.topicPartition, partMetadata));
        }
        this.metadataSnapshot = this.metadataSnapshot.mergeWith(this.metadataSnapshot.clusterResource().clusterId(), newNodes, updatePartitionMetadata, Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), this.metadataSnapshot.cluster().controller(), topicIdsForUpdatedTopics, (topic, isInternal) -> true);
        this.clusterResourceListeners.onUpdate(this.metadataSnapshot.clusterResource());
        return updatePartitionMetadata.stream().map(metadata -> metadata.topicPartition).collect(Collectors.toSet());
    }

    private void maybeSetMetadataError(Cluster cluster) {
        this.clearRecoverableErrors();
        this.checkInvalidTopics(cluster);
        this.checkUnauthorizedTopics(cluster);
    }

    private void checkInvalidTopics(Cluster cluster) {
        if (!cluster.invalidTopics().isEmpty()) {
            this.log.error("Metadata response reported invalid topics {}", (Object)cluster.invalidTopics());
            this.invalidTopics = new HashSet<String>(cluster.invalidTopics());
        }
    }

    private void checkUnauthorizedTopics(Cluster cluster) {
        if (!cluster.unauthorizedTopics().isEmpty()) {
            this.log.error("Topic authorization failed for topics {}", (Object)cluster.unauthorizedTopics());
            this.unauthorizedTopics = new HashSet<String>(cluster.unauthorizedTopics());
        }
    }

    private MetadataSnapshot handleMetadataResponse(MetadataResponse metadataResponse, boolean isPartialUpdate, long nowMs) {
        HashSet<String> topics = new HashSet<String>();
        HashSet<String> internalTopics = new HashSet<String>();
        HashSet<String> unauthorizedTopics = new HashSet<String>();
        HashSet<String> invalidTopics = new HashSet<String>();
        ArrayList<MetadataResponse.PartitionMetadata> partitions = new ArrayList<MetadataResponse.PartitionMetadata>();
        HashMap<String, Uuid> topicIds = new HashMap<String, Uuid>();
        Map<String, Uuid> oldTopicIds = this.metadataSnapshot.topicIds();
        for (MetadataResponse.TopicMetadata metadata : metadataResponse.topicMetadata()) {
            String topicName = metadata.topic();
            Uuid topicId = metadata.topicId();
            topics.add(topicName);
            Uuid oldTopicId = null;
            if (!Uuid.ZERO_UUID.equals(topicId)) {
                topicIds.put(topicName, topicId);
                oldTopicId = oldTopicIds.get(topicName);
            } else {
                topicId = null;
            }
            if (!this.retainTopic(topicName, metadata.isInternal(), nowMs)) continue;
            if (metadata.isInternal()) {
                internalTopics.add(topicName);
            }
            if (metadata.error() == Errors.NONE) {
                for (MetadataResponse.PartitionMetadata partitionMetadata : metadata.partitionMetadata()) {
                    this.updateLatestMetadata(partitionMetadata, metadataResponse.hasReliableLeaderEpochs(), topicId, oldTopicId).ifPresent(partitions::add);
                    if (!(partitionMetadata.error.exception() instanceof InvalidMetadataException)) continue;
                    this.log.debug("Requesting metadata update for partition {} due to error {}", (Object)partitionMetadata.topicPartition, (Object)partitionMetadata.error);
                    this.requestUpdate(false);
                }
                continue;
            }
            if (metadata.error().exception() instanceof InvalidMetadataException) {
                this.log.debug("Requesting metadata update for topic {} due to error {}", (Object)topicName, (Object)metadata.error());
                this.requestUpdate(false);
            }
            if (metadata.error() == Errors.INVALID_TOPIC_EXCEPTION) {
                invalidTopics.add(topicName);
                continue;
            }
            if (metadata.error() != Errors.TOPIC_AUTHORIZATION_FAILED) continue;
            unauthorizedTopics.add(topicName);
        }
        Map<Integer, Node> nodes = metadataResponse.brokersById();
        if (isPartialUpdate) {
            return this.metadataSnapshot.mergeWith(metadataResponse.clusterId(), nodes, partitions, unauthorizedTopics, invalidTopics, internalTopics, metadataResponse.controller(), topicIds, (topic, isInternal) -> !topics.contains(topic) && this.retainTopic((String)topic, (boolean)isInternal, nowMs));
        }
        return new MetadataSnapshot(metadataResponse.clusterId(), nodes, partitions, unauthorizedTopics, invalidTopics, internalTopics, metadataResponse.controller(), topicIds);
    }

    private Optional<MetadataResponse.PartitionMetadata> updateLatestMetadata(MetadataResponse.PartitionMetadata partitionMetadata, boolean hasReliableLeaderEpoch, Uuid topicId, Uuid oldTopicId) {
        TopicPartition tp = partitionMetadata.topicPartition;
        if (hasReliableLeaderEpoch && partitionMetadata.leaderEpoch.isPresent()) {
            int newEpoch = partitionMetadata.leaderEpoch.get();
            Integer currentEpoch = this.lastSeenLeaderEpochs.get(tp);
            if (currentEpoch == null) {
                this.log.debug("Setting the last seen epoch of partition {} to {} since the last known epoch was undefined.", (Object)tp, (Object)newEpoch);
                this.lastSeenLeaderEpochs.put(tp, newEpoch);
                this.equivalentResponseCount = 0L;
                return Optional.of(partitionMetadata);
            }
            if (topicId != null && !topicId.equals(oldTopicId)) {
                this.log.info("Resetting the last seen epoch of partition {} to {} since the associated topicId changed from {} to {}", tp, newEpoch, oldTopicId, topicId);
                this.lastSeenLeaderEpochs.put(tp, newEpoch);
                this.equivalentResponseCount = 0L;
                return Optional.of(partitionMetadata);
            }
            if (newEpoch >= currentEpoch) {
                this.log.debug("Updating last seen epoch for partition {} from {} to epoch {} from new metadata", tp, currentEpoch, newEpoch);
                this.lastSeenLeaderEpochs.put(tp, newEpoch);
                if (newEpoch > currentEpoch) {
                    this.equivalentResponseCount = 0L;
                }
                return Optional.of(partitionMetadata);
            }
            this.log.debug("Got metadata for an older epoch {} (current is {}) for partition {}, not updating", newEpoch, currentEpoch, tp);
            return this.metadataSnapshot.partitionMetadata(tp);
        }
        this.lastSeenLeaderEpochs.remove(tp);
        this.equivalentResponseCount = 0L;
        return Optional.of(partitionMetadata.withoutLeaderEpoch());
    }

    public synchronized void maybeThrowAnyException() {
        this.clearErrorsAndMaybeThrowException(this::recoverableException);
    }

    protected synchronized void maybeThrowFatalException() {
        KafkaException metadataException = this.fatalException;
        if (metadataException != null) {
            this.fatalException = null;
            throw metadataException;
        }
    }

    public synchronized void maybeThrowExceptionForTopic(String topic) {
        this.clearErrorsAndMaybeThrowException(() -> this.recoverableExceptionForTopic(topic));
    }

    private void clearErrorsAndMaybeThrowException(Supplier<KafkaException> recoverableExceptionSupplier) {
        KafkaException metadataException = Optional.ofNullable(this.fatalException).orElseGet(recoverableExceptionSupplier);
        this.fatalException = null;
        this.clearRecoverableErrors();
        if (metadataException != null) {
            throw metadataException;
        }
    }

    private KafkaException recoverableException() {
        if (!this.unauthorizedTopics.isEmpty()) {
            return new TopicAuthorizationException(this.unauthorizedTopics);
        }
        if (!this.invalidTopics.isEmpty()) {
            return new InvalidTopicException(this.invalidTopics);
        }
        return null;
    }

    private KafkaException recoverableExceptionForTopic(String topic) {
        if (this.unauthorizedTopics.contains(topic)) {
            return new TopicAuthorizationException(Collections.singleton(topic));
        }
        if (this.invalidTopics.contains(topic)) {
            return new InvalidTopicException(Collections.singleton(topic));
        }
        return null;
    }

    private void clearRecoverableErrors() {
        this.invalidTopics = Collections.emptySet();
        this.unauthorizedTopics = Collections.emptySet();
    }

    public synchronized void failedUpdate(long now) {
        this.lastRefreshMs = now;
        ++this.attempts;
        this.equivalentResponseCount = 0L;
    }

    public synchronized void fatalError(KafkaException exception) {
        this.fatalException = exception;
    }

    public synchronized int updateVersion() {
        return this.updateVersion;
    }

    public synchronized long lastSuccessfulUpdate() {
        return this.lastSuccessfulRefreshMs;
    }

    @Override
    public synchronized void close() {
        this.isClosed = true;
    }

    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    public synchronized MetadataRequestAndVersion newMetadataRequestAndVersion(long nowMs) {
        MetadataRequest.Builder request = null;
        boolean isPartialUpdate = false;
        if (!this.needFullUpdate && this.lastSuccessfulRefreshMs + this.metadataExpireMs > nowMs) {
            request = this.newMetadataRequestBuilderForNewTopics();
            isPartialUpdate = true;
        }
        if (request == null) {
            request = this.newMetadataRequestBuilder();
            isPartialUpdate = false;
        }
        return new MetadataRequestAndVersion(request, this.requestVersion, isPartialUpdate);
    }

    protected MetadataRequest.Builder newMetadataRequestBuilder() {
        return MetadataRequest.Builder.allTopics();
    }

    protected MetadataRequest.Builder newMetadataRequestBuilderForNewTopics() {
        return null;
    }

    public Map<Uuid, String> topicNames() {
        return this.metadataSnapshot.topicNames();
    }

    protected boolean retainTopic(String topic, boolean isInternal, long nowMs) {
        return true;
    }

    public static class LeaderIdAndEpoch {
        public final Optional<Integer> leaderId;
        public final Optional<Integer> epoch;

        public LeaderIdAndEpoch(Optional<Integer> leaderId, Optional<Integer> epoch) {
            this.leaderId = Objects.requireNonNull(leaderId);
            this.epoch = Objects.requireNonNull(epoch);
        }

        public String toString() {
            return "LeaderIdAndEpoch{leaderId=" + this.leaderId.map(Object::toString).orElse("absent") + ", epoch=" + this.epoch.map(Object::toString).orElse("absent") + '}';
        }
    }

    public static class LeaderAndEpoch {
        private static final LeaderAndEpoch NO_LEADER_OR_EPOCH = new LeaderAndEpoch(Optional.empty(), Optional.empty());
        public final Optional<Node> leader;
        public final Optional<Integer> epoch;

        public LeaderAndEpoch(Optional<Node> leader, Optional<Integer> epoch) {
            this.leader = Objects.requireNonNull(leader);
            this.epoch = Objects.requireNonNull(epoch);
        }

        public static LeaderAndEpoch noLeaderOrEpoch() {
            return NO_LEADER_OR_EPOCH;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LeaderAndEpoch that = (LeaderAndEpoch)o;
            if (!this.leader.equals(that.leader)) {
                return false;
            }
            return this.epoch.equals(that.epoch);
        }

        public int hashCode() {
            int result = this.leader.hashCode();
            result = 31 * result + this.epoch.hashCode();
            return result;
        }

        public String toString() {
            return "LeaderAndEpoch{leader=" + this.leader + ", epoch=" + this.epoch.map(Object::toString).orElse("absent") + '}';
        }
    }

    public static class MetadataRequestAndVersion {
        public final MetadataRequest.Builder requestBuilder;
        public final int requestVersion;
        public final boolean isPartialUpdate;

        private MetadataRequestAndVersion(MetadataRequest.Builder requestBuilder, int requestVersion, boolean isPartialUpdate) {
            this.requestBuilder = requestBuilder;
            this.requestVersion = requestVersion;
            this.isPartialUpdate = isPartialUpdate;
        }
    }
}

