/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.secured;

import java.io.IOException;
import java.security.Key;
import java.util.List;
import org.apache.kafka.common.security.oauthbearer.internals.secured.CloseableVerificationKeyResolver;
import org.apache.kafka.common.security.oauthbearer.internals.secured.RefreshingHttpsJwks;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.VerificationJwkSelector;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.lang.JoseException;
import org.jose4j.lang.UnresolvableKeyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshingHttpsJwksVerificationKeyResolver
implements CloseableVerificationKeyResolver {
    private static final Logger log = LoggerFactory.getLogger(RefreshingHttpsJwksVerificationKeyResolver.class);
    private final RefreshingHttpsJwks refreshingHttpsJwks;
    private final VerificationJwkSelector verificationJwkSelector;
    private boolean isInitialized;

    public RefreshingHttpsJwksVerificationKeyResolver(RefreshingHttpsJwks refreshingHttpsJwks) {
        this.refreshingHttpsJwks = refreshingHttpsJwks;
        this.verificationJwkSelector = new VerificationJwkSelector();
    }

    @Override
    public void init() throws IOException {
        try {
            log.debug("init started");
            this.refreshingHttpsJwks.init();
        }
        finally {
            this.isInitialized = true;
            log.debug("init completed");
        }
    }

    @Override
    public void close() {
        try {
            log.debug("close started");
            this.refreshingHttpsJwks.close();
        }
        finally {
            log.debug("close completed");
        }
    }

    @Override
    public Key resolveKey(JsonWebSignature jws, List<JsonWebStructure> nestingContext) throws UnresolvableKeyException {
        if (!this.isInitialized) {
            throw new IllegalStateException("Please call init() first");
        }
        try {
            List<JsonWebKey> jwks = this.refreshingHttpsJwks.getJsonWebKeys();
            JsonWebKey jwk = this.verificationJwkSelector.select(jws, jwks);
            if (jwk != null) {
                return jwk.getKey();
            }
            String keyId = jws.getKeyIdHeaderValue();
            if (this.refreshingHttpsJwks.maybeExpediteRefresh(keyId)) {
                log.debug("Refreshing JWKs from {} as no suitable verification key for JWS w/ header {} was found in {}", this.refreshingHttpsJwks.getLocation(), jws.getHeaders().getFullHeaderAsJsonString(), jwks);
            }
            StringBuilder sb = new StringBuilder();
            sb.append("Unable to find a suitable verification key for JWS w/ header ").append(jws.getHeaders().getFullHeaderAsJsonString());
            sb.append(" from JWKs ").append(jwks).append(" obtained from ").append(this.refreshingHttpsJwks.getLocation());
            throw new UnresolvableKeyException(sb.toString());
        }
        catch (IOException | JoseException e) {
            StringBuilder sb = new StringBuilder();
            sb.append("Unable to find a suitable verification key for JWS w/ header ").append(jws.getHeaders().getFullHeaderAsJsonString());
            sb.append(" due to an unexpected exception (").append(e).append(") while obtaining or using keys from JWKS endpoint at ").append(this.refreshingHttpsJwks.getLocation());
            throw new UnresolvableKeyException(sb.toString(), e);
        }
    }
}

