/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.clients.CommonClientConfigs;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.runtime.isolation.PluginDiscoveryMode;
import org.apache.kafka.connect.runtime.rest.RestServerConfig;
import org.apache.kafka.connect.storage.SimpleHeaderConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerConfig
extends AbstractConfig {
    private static final Logger log = LoggerFactory.getLogger(WorkerConfig.class);
    public static final String BOOTSTRAP_SERVERS_CONFIG = "bootstrap.servers";
    public static final String BOOTSTRAP_SERVERS_DOC = "A list of host/port pairs to use for establishing the initial connection to the Kafka cluster. The client will make use of all servers irrespective of which servers are specified here for bootstrapping&mdash;this list only impacts the initial hosts used to discover the full set of servers. This list should be in the form <code>host1:port1,host2:port2,...</code>. Since these servers are just used for the initial connection to discover the full cluster membership (which may change dynamically), this list need not contain the full set of servers (you may want more than one, though, in case a server is down).";
    public static final String BOOTSTRAP_SERVERS_DEFAULT = "localhost:9092";
    public static final String CLIENT_DNS_LOOKUP_CONFIG = "client.dns.lookup";
    public static final String CLIENT_DNS_LOOKUP_DOC = "Controls how the client uses DNS lookups. If set to <code>use_all_dns_ips</code>, connect to each returned IP address in sequence until a successful connection is established. After a disconnection, the next IP is used. Once all IPs have been used once, the client resolves the IP(s) from the hostname again (both the JVM and the OS cache DNS name lookups, however). If set to <code>resolve_canonical_bootstrap_servers_only</code>, resolve each bootstrap address into a list of canonical names. After the bootstrap phase, this behaves the same as <code>use_all_dns_ips</code>.";
    public static final String KEY_CONVERTER_CLASS_CONFIG = "key.converter";
    public static final String KEY_CONVERTER_CLASS_DOC = "Converter class used to convert between Kafka Connect format and the serialized form that is written to Kafka. This controls the format of the keys in messages written to or read from Kafka, and since this is independent of connectors it allows any connector to work with any serialization format. Examples of common formats include JSON and Avro.";
    public static final String VALUE_CONVERTER_CLASS_CONFIG = "value.converter";
    public static final String VALUE_CONVERTER_CLASS_DOC = "Converter class used to convert between Kafka Connect format and the serialized form that is written to Kafka. This controls the format of the values in messages written to or read from Kafka, and since this is independent of connectors it allows any connector to work with any serialization format. Examples of common formats include JSON and Avro.";
    public static final String HEADER_CONVERTER_CLASS_CONFIG = "header.converter";
    public static final String HEADER_CONVERTER_CLASS_DOC = "HeaderConverter class used to convert between Kafka Connect format and the serialized form that is written to Kafka. This controls the format of the header values in messages written to or read from Kafka, and since this is independent of connectors it allows any connector to work with any serialization format. Examples of common formats include JSON and Avro. By default, the SimpleHeaderConverter is used to serialize header values to strings and deserialize them by inferring the schemas.";
    public static final String HEADER_CONVERTER_CLASS_DEFAULT = SimpleHeaderConverter.class.getName();
    public static final String TASK_SHUTDOWN_GRACEFUL_TIMEOUT_MS_CONFIG = "task.shutdown.graceful.timeout.ms";
    private static final String TASK_SHUTDOWN_GRACEFUL_TIMEOUT_MS_DOC = "Amount of time to wait for tasks to shutdown gracefully. This is the total amount of time, not per task. All task have shutdown triggered, then they are waited on sequentially.";
    private static final String TASK_SHUTDOWN_GRACEFUL_TIMEOUT_MS_DEFAULT = "5000";
    public static final String OFFSET_COMMIT_INTERVAL_MS_CONFIG = "offset.flush.interval.ms";
    private static final String OFFSET_COMMIT_INTERVAL_MS_DOC = "Interval at which to try committing offsets for tasks.";
    public static final long OFFSET_COMMIT_INTERVAL_MS_DEFAULT = 60000L;
    public static final String OFFSET_COMMIT_TIMEOUT_MS_CONFIG = "offset.flush.timeout.ms";
    private static final String OFFSET_COMMIT_TIMEOUT_MS_DOC = "Maximum number of milliseconds to wait for records to flush and partition offset data to be committed to offset storage before cancelling the process and restoring the offset data to be committed in a future attempt. This property has no effect for source connectors running with exactly-once support.";
    public static final long OFFSET_COMMIT_TIMEOUT_MS_DEFAULT = 5000L;
    public static final String PLUGIN_PATH_CONFIG = "plugin.path";
    protected static final String PLUGIN_PATH_DOC = "List of paths separated by commas (,) that contain plugins (connectors, converters, transformations). The list should consist of top level directories that include any combination of: \na) directories immediately containing jars with plugins and their dependencies\nb) uber-jars with plugins and their dependencies\nc) directories immediately containing the package directory structure of classes of plugins and their dependencies\nNote: symlinks will be followed to discover dependencies or plugins.\nExamples: plugin.path=/usr/local/share/java,/usr/local/share/kafka/plugins,/opt/connectors\nDo not use config provider variables in this property, since the raw path is used by the worker's scanner before config providers are initialized and used to replace variables.";
    public static final String PLUGIN_DISCOVERY_CONFIG = "plugin.discovery";
    protected static final String PLUGIN_DISCOVERY_DOC = "Method to use to discover plugins present in the classpath and plugin.path configuration. This can be one of multiple values with the following meanings:\n* " + (Object)((Object)PluginDiscoveryMode.ONLY_SCAN) + ": Discover plugins only by reflection. Plugins which are not discoverable by ServiceLoader will not impact worker startup.\n* " + (Object)((Object)PluginDiscoveryMode.HYBRID_WARN) + ": Discover plugins reflectively and by ServiceLoader. Plugins which are not discoverable by ServiceLoader will print warnings during worker startup.\n* " + (Object)((Object)PluginDiscoveryMode.HYBRID_FAIL) + ": Discover plugins reflectively and by ServiceLoader. Plugins which are not discoverable by ServiceLoader will cause worker startup to fail.\n* " + (Object)((Object)PluginDiscoveryMode.SERVICE_LOAD) + ": Discover plugins only by ServiceLoader. Faster startup than other modes. Plugins which are not discoverable by ServiceLoader may not be usable.";
    public static final String CONFIG_PROVIDERS_CONFIG = "config.providers";
    protected static final String CONFIG_PROVIDERS_DOC = "Comma-separated names of <code>ConfigProvider</code> classes, loaded and used in the order specified. Implementing the interface  <code>ConfigProvider</code> allows you to replace variable references in connector configurations, such as for externalized secrets. ";
    public static final String CONNECTOR_CLIENT_POLICY_CLASS_CONFIG = "connector.client.config.override.policy";
    public static final String CONNECTOR_CLIENT_POLICY_CLASS_DOC = "Class name or alias of implementation of <code>ConnectorClientConfigOverridePolicy</code>. Defines what client configurations can be overridden by the connector. The default implementation is `All`, meaning connector configurations can override all client properties. The other possible policies in the framework include `None` to disallow connectors from overriding client properties, and `Principal` to allow connectors to override only client principals.";
    public static final String CONNECTOR_CLIENT_POLICY_CLASS_DEFAULT = "All";
    public static final String METRICS_SAMPLE_WINDOW_MS_CONFIG = "metrics.sample.window.ms";
    public static final String METRICS_NUM_SAMPLES_CONFIG = "metrics.num.samples";
    public static final String METRICS_RECORDING_LEVEL_CONFIG = "metrics.recording.level";
    public static final String METRIC_REPORTER_CLASSES_CONFIG = "metric.reporters";
    @Deprecated
    public static final String AUTO_INCLUDE_JMX_REPORTER_CONFIG = "auto.include.jmx.reporter";
    public static final String TOPIC_TRACKING_ENABLE_CONFIG = "topic.tracking.enable";
    protected static final String TOPIC_TRACKING_ENABLE_DOC = "Enable tracking the set of active topics per connector during runtime.";
    protected static final boolean TOPIC_TRACKING_ENABLE_DEFAULT = true;
    public static final String TOPIC_TRACKING_ALLOW_RESET_CONFIG = "topic.tracking.allow.reset";
    protected static final String TOPIC_TRACKING_ALLOW_RESET_DOC = "If set to true, it allows user requests to reset the set of active topics per connector.";
    protected static final boolean TOPIC_TRACKING_ALLOW_RESET_DEFAULT = true;
    public static final String CONNECT_KAFKA_CLUSTER_ID = "connect.kafka.cluster.id";
    public static final String CONNECT_GROUP_ID = "connect.group.id";
    public static final String TOPIC_CREATION_ENABLE_CONFIG = "topic.creation.enable";
    protected static final String TOPIC_CREATION_ENABLE_DOC = "Whether to allow automatic creation of topics used by source connectors, when source connectors are configured with `topic.creation.` properties. Each task will use an admin client to create its topics and will not depend on the Kafka brokers to create topics automatically.";
    protected static final boolean TOPIC_CREATION_ENABLE_DEFAULT = true;
    private String kafkaClusterId;

    protected static ConfigDef baseConfigDef() {
        ConfigDef result = new ConfigDef().define(BOOTSTRAP_SERVERS_CONFIG, ConfigDef.Type.LIST, BOOTSTRAP_SERVERS_DEFAULT, ConfigDef.Importance.HIGH, BOOTSTRAP_SERVERS_DOC).define(CLIENT_DNS_LOOKUP_CONFIG, ConfigDef.Type.STRING, ClientDnsLookup.USE_ALL_DNS_IPS.toString(), ConfigDef.ValidString.in(ClientDnsLookup.USE_ALL_DNS_IPS.toString(), ClientDnsLookup.RESOLVE_CANONICAL_BOOTSTRAP_SERVERS_ONLY.toString()), ConfigDef.Importance.MEDIUM, CLIENT_DNS_LOOKUP_DOC).define(KEY_CONVERTER_CLASS_CONFIG, ConfigDef.Type.CLASS, ConfigDef.Importance.HIGH, KEY_CONVERTER_CLASS_DOC).define(VALUE_CONVERTER_CLASS_CONFIG, ConfigDef.Type.CLASS, ConfigDef.Importance.HIGH, VALUE_CONVERTER_CLASS_DOC).define(TASK_SHUTDOWN_GRACEFUL_TIMEOUT_MS_CONFIG, ConfigDef.Type.LONG, TASK_SHUTDOWN_GRACEFUL_TIMEOUT_MS_DEFAULT, ConfigDef.Importance.LOW, TASK_SHUTDOWN_GRACEFUL_TIMEOUT_MS_DOC).define(OFFSET_COMMIT_INTERVAL_MS_CONFIG, ConfigDef.Type.LONG, 60000L, ConfigDef.Importance.LOW, OFFSET_COMMIT_INTERVAL_MS_DOC).define(OFFSET_COMMIT_TIMEOUT_MS_CONFIG, ConfigDef.Type.LONG, 5000L, ConfigDef.Importance.LOW, OFFSET_COMMIT_TIMEOUT_MS_DOC).define(PLUGIN_PATH_CONFIG, ConfigDef.Type.LIST, null, ConfigDef.Importance.LOW, PLUGIN_PATH_DOC).define(PLUGIN_DISCOVERY_CONFIG, ConfigDef.Type.STRING, PluginDiscoveryMode.HYBRID_WARN.toString(), ConfigDef.CaseInsensitiveValidString.in(Utils.enumOptions(PluginDiscoveryMode.class)), ConfigDef.Importance.LOW, PLUGIN_DISCOVERY_DOC).define(METRICS_SAMPLE_WINDOW_MS_CONFIG, ConfigDef.Type.LONG, 30000, ConfigDef.Range.atLeast(0), ConfigDef.Importance.LOW, "The window of time a metrics sample is computed over.").define(METRICS_NUM_SAMPLES_CONFIG, ConfigDef.Type.INT, 2, ConfigDef.Range.atLeast(1), ConfigDef.Importance.LOW, "The number of samples maintained to compute metrics.").define(METRICS_RECORDING_LEVEL_CONFIG, ConfigDef.Type.STRING, Sensor.RecordingLevel.INFO.toString(), ConfigDef.ValidString.in(Sensor.RecordingLevel.INFO.toString(), Sensor.RecordingLevel.DEBUG.toString()), ConfigDef.Importance.LOW, "The highest recording level for metrics.").define(METRIC_REPORTER_CLASSES_CONFIG, ConfigDef.Type.LIST, "", ConfigDef.Importance.LOW, "A list of classes to use as metrics reporters. Implementing the <code>org.apache.kafka.common.metrics.MetricsReporter</code> interface allows plugging in classes that will be notified of new metric creation. The JmxReporter is always included to register JMX statistics.").define(AUTO_INCLUDE_JMX_REPORTER_CONFIG, ConfigDef.Type.BOOLEAN, true, ConfigDef.Importance.LOW, "Deprecated. Whether to automatically include JmxReporter even if it's not listed in <code>metric.reporters</code>. This configuration will be removed in Kafka 4.0, users should instead include <code>org.apache.kafka.common.metrics.JmxReporter</code> in <code>metric.reporters</code> in order to enable the JmxReporter.").define(HEADER_CONVERTER_CLASS_CONFIG, ConfigDef.Type.CLASS, HEADER_CONVERTER_CLASS_DEFAULT, ConfigDef.Importance.LOW, HEADER_CONVERTER_CLASS_DOC).define(CONFIG_PROVIDERS_CONFIG, ConfigDef.Type.LIST, Collections.emptyList(), ConfigDef.Importance.LOW, CONFIG_PROVIDERS_DOC).define(CONNECTOR_CLIENT_POLICY_CLASS_CONFIG, ConfigDef.Type.STRING, CONNECTOR_CLIENT_POLICY_CLASS_DEFAULT, ConfigDef.Importance.MEDIUM, CONNECTOR_CLIENT_POLICY_CLASS_DOC).define(TOPIC_CREATION_ENABLE_CONFIG, ConfigDef.Type.BOOLEAN, true, ConfigDef.Importance.LOW, TOPIC_CREATION_ENABLE_DOC).withClientSslSupport();
        WorkerConfig.addTopicTrackingConfig(result);
        RestServerConfig.addPublicConfig(result);
        return result;
    }

    public static void addTopicTrackingConfig(ConfigDef configDef) {
        configDef.define(TOPIC_TRACKING_ENABLE_CONFIG, ConfigDef.Type.BOOLEAN, true, ConfigDef.Importance.LOW, TOPIC_TRACKING_ENABLE_DOC).define(TOPIC_TRACKING_ALLOW_RESET_CONFIG, ConfigDef.Type.BOOLEAN, true, ConfigDef.Importance.LOW, TOPIC_TRACKING_ALLOW_RESET_DOC);
    }

    static String lookupKafkaClusterId(WorkerConfig config) {
        log.info("Creating Kafka admin client");
        try (Admin adminClient = Admin.create(config.originals());){
            String string = WorkerConfig.lookupKafkaClusterId(adminClient);
            return string;
        }
    }

    static String lookupKafkaClusterId(Admin adminClient) {
        log.debug("Looking up Kafka cluster ID");
        try {
            KafkaFuture<String> clusterIdFuture = adminClient.describeCluster().clusterId();
            if (clusterIdFuture == null) {
                log.info("Kafka cluster version is too old to return cluster ID");
                return null;
            }
            log.debug("Fetching Kafka cluster ID");
            String kafkaClusterId = clusterIdFuture.get();
            log.info("Kafka cluster ID: {}", (Object)kafkaClusterId);
            return kafkaClusterId;
        }
        catch (InterruptedException e) {
            throw new ConnectException("Unexpectedly interrupted when looking up Kafka cluster info", e);
        }
        catch (ExecutionException e) {
            throw new ConnectException("Failed to connect to and describe Kafka cluster. Check worker's broker connection and security properties.", e);
        }
    }

    private void logInternalConverterRemovalWarnings(Map<String, String> props) {
        ArrayList<String> removedProperties = new ArrayList<String>();
        for (String property : Arrays.asList("internal.key.converter", "internal.value.converter")) {
            if (props.containsKey(property)) {
                removedProperties.add(property);
            }
            removedProperties.addAll(this.originalsWithPrefix(property + ".").keySet());
        }
        if (!removedProperties.isEmpty()) {
            log.warn("The worker has been configured with one or more internal converter properties ({}). Support for these properties was deprecated in version 2.0 and removed in version 3.0, and specifying them will have no effect. Instead, an instance of the JsonConverter with schemas.enable set to false will be used. For more information, please visit https://kafka.apache.org/documentation/#upgrade and consult the upgrade notesfor the 3.0 release.", (Object)removedProperties);
        }
    }

    private void logPluginPathConfigProviderWarning(Map<String, String> rawOriginals) {
        String transformedPluginPath;
        String rawPluginPath = rawOriginals.get(PLUGIN_PATH_CONFIG);
        if (!Objects.equals(rawPluginPath, transformedPluginPath = Objects.toString(this.originals().get(PLUGIN_PATH_CONFIG), null))) {
            log.warn("Variables cannot be used in the 'plugin.path' property, since the property is used by plugin scanning before the config providers that replace the variables are initialized. The raw value '{}' was used for plugin scanning, as opposed to the transformed value '{}', and this may cause unexpected results.", (Object)rawPluginPath, (Object)transformedPluginPath);
        }
    }

    public String bootstrapServers() {
        return String.join((CharSequence)",", this.getList(BOOTSTRAP_SERVERS_CONFIG));
    }

    public Integer rebalanceTimeout() {
        return null;
    }

    public boolean topicCreationEnable() {
        return this.getBoolean(TOPIC_CREATION_ENABLE_CONFIG);
    }

    public boolean exactlyOnceSourceEnabled() {
        return false;
    }

    public String offsetsTopic() {
        return null;
    }

    public boolean connectorOffsetsTopicsPermitted() {
        return false;
    }

    public long offsetCommitInterval() {
        return this.getLong(OFFSET_COMMIT_INTERVAL_MS_CONFIG);
    }

    public String groupId() {
        return null;
    }

    public String kafkaClusterId() {
        if (this.kafkaClusterId == null) {
            this.kafkaClusterId = WorkerConfig.lookupKafkaClusterId(this);
        }
        return this.kafkaClusterId;
    }

    @Override
    protected Map<String, Object> postProcessParsedConfig(Map<String, Object> parsedValues) {
        return CommonClientConfigs.postProcessReconnectBackoffConfigs(this, parsedValues);
    }

    public static String pluginPath(Map<String, String> props) {
        return props.get(PLUGIN_PATH_CONFIG);
    }

    public static PluginDiscoveryMode pluginDiscovery(Map<String, String> props) {
        String value = props.getOrDefault(PLUGIN_DISCOVERY_CONFIG, PluginDiscoveryMode.HYBRID_WARN.toString());
        try {
            return PluginDiscoveryMode.valueOf(value.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new ConnectException("Invalid plugin.discovery value, must be one of " + Arrays.toString(Utils.enumOptions(PluginDiscoveryMode.class)));
        }
    }

    public WorkerConfig(ConfigDef definition, Map<String, String> props) {
        super(definition, props);
        this.logInternalConverterRemovalWarnings(props);
        this.logPluginPathConfigProviderWarning(props);
    }
}

