/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.sqlserver.SqlServerValueConverters;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.Column;
import io.debezium.relational.DefaultValueConverter;
import io.debezium.relational.ValueConverter;
import io.debezium.util.HexConverter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import microsoft.sql.DateTimeOffset;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
class SqlServerDefaultValueConverter
implements DefaultValueConverter {
    private static Logger LOGGER = LoggerFactory.getLogger(SqlServerDefaultValueConverter.class);
    private final ConnectionProvider connectionProvider;
    private final SqlServerValueConverters valueConverters;
    private final Map<String, DefaultValueConverter.DefaultValueMapper> defaultValueMappers;

    SqlServerDefaultValueConverter(ConnectionProvider connectionProvider, SqlServerValueConverters valueConverters) {
        this.connectionProvider = connectionProvider;
        this.valueConverters = valueConverters;
        this.defaultValueMappers = Collections.unmodifiableMap(this.createDefaultValueMappers());
    }

    @Override
    public Optional<Object> parseDefaultValue(Column column, String defaultValueExpression) {
        if (defaultValueExpression == null) {
            return Optional.empty();
        }
        String dataType = column.typeName();
        DefaultValueConverter.DefaultValueMapper mapper = this.defaultValueMappers.get(dataType);
        if (mapper == null) {
            LOGGER.warn("Mapper for type '{}' not found.", (Object)dataType);
            return Optional.empty();
        }
        try {
            Object rawDefaultValue = mapper.parse(column, defaultValueExpression);
            Object convertedDefaultValue = this.convertDefaultValue(rawDefaultValue, column);
            return Optional.ofNullable(convertedDefaultValue);
        }
        catch (Exception e) {
            LOGGER.warn("Cannot parse column default value '{}' to type '{}'. Expression evaluation is not supported.", (Object)defaultValueExpression, (Object)dataType);
            LOGGER.debug("Parsing failed due to error", e);
            return Optional.empty();
        }
    }

    private Object convertDefaultValue(Object defaultValue, Column column) {
        if (this.valueConverters != null && defaultValue != null) {
            SchemaBuilder schemaBuilder = this.valueConverters.schemaBuilder(column);
            if (schemaBuilder == null) {
                return defaultValue;
            }
            Schema schema = schemaBuilder.build();
            Field field = new Field(column.name(), -1, schema);
            ValueConverter valueConverter = this.valueConverters.converter(column, field);
            Object result = valueConverter.convert(defaultValue);
            if (result instanceof BigDecimal && column.scale().isPresent() && column.scale().get() > ((BigDecimal)result).scale()) {
                result = ((BigDecimal)result).setScale((int)column.scale().get(), RoundingMode.HALF_EVEN);
            }
            return result;
        }
        return defaultValue;
    }

    private Map<String, DefaultValueConverter.DefaultValueMapper> createDefaultValueMappers() {
        HashMap<String, DefaultValueConverter.DefaultValueMapper> result = new HashMap<String, DefaultValueConverter.DefaultValueMapper>();
        result.put("bigint", (c, v) -> SqlServerDefaultValueConverter.nullableDefaultValueMapper(c, v, (col, value) -> Long.parseLong(value.charAt(value.length() - 1) == '.' ? value.substring(0, value.length() - 1) : value)));
        result.put("int", (c, v) -> SqlServerDefaultValueConverter.nullableDefaultValueMapper(c, v, (col, value) -> Integer.parseInt(value)));
        result.put("smallint", (c, v) -> SqlServerDefaultValueConverter.nullableDefaultValueMapper(c, v, (col, value) -> Short.parseShort(value)));
        result.put("tinyint", (c, v) -> SqlServerDefaultValueConverter.nullableDefaultValueMapper(c, v, (col, value) -> Short.parseShort(value)));
        result.put("bit", (c, v) -> v.equals("((1))"));
        result.put("decimal", (c, v) -> new BigDecimal(v.substring(2, v.length() - 2)));
        result.put("numeric", (c, v) -> new BigDecimal(v.substring(2, v.length() - 2)));
        result.put("money", (c, v) -> new BigDecimal(v.substring(2, v.length() - 2)));
        result.put("smallmoney", (c, v) -> new BigDecimal(v.substring(2, v.length() - 2)));
        result.put("float", (c, v) -> SqlServerDefaultValueConverter.nullableDefaultValueMapper(c, v, (col, value) -> Double.parseDouble(value)));
        result.put("real", (c, v) -> SqlServerDefaultValueConverter.nullableDefaultValueMapper(c, v, (col, value) -> Float.valueOf(Float.parseFloat(value))));
        result.put("date", (c, v) -> {
            String rawValue = v.substring(2, v.length() - 2);
            return JdbcConnection.querySingleValue(this.connectionProvider.get(), "SELECT PARSE(? AS date)", st -> st.setString(1, rawValue), rs -> rs.getDate(1));
        });
        result.put("datetime", (c, v) -> {
            String rawValue = v.substring(2, v.length() - 2);
            return JdbcConnection.querySingleValue(this.connectionProvider.get(), "SELECT PARSE(? AS datetime)", st -> st.setString(1, rawValue), rs -> rs.getTimestamp(1));
        });
        result.put("datetime2", (c, v) -> {
            String rawValue = v.substring(2, v.length() - 2);
            return JdbcConnection.querySingleValue(this.connectionProvider.get(), "SELECT PARSE(? AS datetime2)", st -> st.setString(1, rawValue), rs -> rs.getTimestamp(1));
        });
        result.put("datetimeoffset", (c, v) -> {
            String rawValue = v.substring(2, v.length() - 2);
            return JdbcConnection.querySingleValue(this.connectionProvider.get(), "SELECT PARSE(? AS datetimeoffset)", st -> st.setString(1, rawValue), rs -> (DateTimeOffset)rs.getObject(1));
        });
        result.put("smalldatetime", (c, v) -> {
            String rawValue = v.substring(2, v.length() - 2);
            return JdbcConnection.querySingleValue(this.connectionProvider.get(), "SELECT PARSE(? AS smalldatetime)", st -> st.setString(1, rawValue), rs -> rs.getTimestamp(1));
        });
        result.put("time", (c, v) -> {
            String rawValue = v.substring(2, v.length() - 2);
            return JdbcConnection.querySingleValue(this.connectionProvider.get(), "SELECT PARSE(? AS time)", st -> st.setString(1, rawValue), rs -> rs.getTime(1));
        });
        result.put("char", (c, v) -> v.substring(2, v.length() - 2));
        result.put("text", (c, v) -> v.substring(2, v.length() - 2));
        result.put("varchar", (c, v) -> v.substring(2, v.length() - 2));
        result.put("nchar", (c, v) -> v.substring(2, v.length() - 2));
        result.put("ntext", (c, v) -> v.substring(2, v.length() - 2));
        result.put("nvarchar", (c, v) -> v.substring(2, v.length() - 2));
        result.put("binary", (c, v) -> HexConverter.convertFromHex(v.substring(3, v.length() - 1)));
        result.put("image", (c, v) -> HexConverter.convertFromHex(v.substring(3, v.length() - 1)));
        result.put("varbinary", (c, v) -> HexConverter.convertFromHex(v.substring(3, v.length() - 1)));
        return result;
    }

    public static Object nullableDefaultValueMapper(Column column, String v, DefaultValueConverter.DefaultValueMapper mapper) throws Exception {
        int end;
        int start = v.lastIndexOf(40) == -1 ? 0 : v.lastIndexOf(40) + 1;
        String value = v.substring(start, end = !v.contains(")") ? v.length() : v.indexOf(41));
        if ("NULL".equalsIgnoreCase(value)) {
            return null;
        }
        return mapper.parse(column, value);
    }

    @FunctionalInterface
    static interface ConnectionProvider {
        public Connection get() throws SQLException;
    }
}

