/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.debezium.sqlserver;

import io.debezium.connector.sqlserver.SqlServerConnector;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.debezium.AbstractDebeziumTask;
import io.kestra.plugin.debezium.sqlserver.SqlServerInterface;
import io.swagger.v3.oas.annotations.media.Schema;
import java.nio.file.Path;
import java.util.Properties;
import lombok.Generated;

@Schema(title="Wait for change data capture event on Microsoft SQL server")
@Plugin(examples={@Example(code={"hostname: 127.0.0.1", "port: 1433", "username: sa", "password: sqlserver_passwd", "maxRecords: 100"})})
public class Capture
extends AbstractDebeziumTask
implements SqlServerInterface {
    protected String database;
    private SqlServerInterface.SnapshotMode snapshotMode;

    @Override
    protected boolean needDatabaseHistory() {
        return true;
    }

    @Override
    protected Properties properties(RunContext runContext, Path offsetFile, Path historyFile) throws Exception {
        Properties props = super.properties(runContext, offsetFile, historyFile);
        props.setProperty("connector.class", SqlServerConnector.class.getName());
        SqlServerInterface.handleProperties(props, runContext, this);
        return props;
    }

    @Generated
    private static SqlServerInterface.SnapshotMode $default$snapshotMode() {
        return SqlServerInterface.SnapshotMode.INITIAL;
    }

    @Generated
    protected Capture(CaptureBuilder<?, ?> b) {
        super(b);
        this.database = b.database;
        this.snapshotMode = b.snapshotMode$set ? b.snapshotMode$value : Capture.$default$snapshotMode();
    }

    @Generated
    public static CaptureBuilder<?, ?> builder() {
        return new CaptureBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "Capture(super=" + super.toString() + ", database=" + this.getDatabase() + ", snapshotMode=" + this.getSnapshotMode() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Capture)) {
            return false;
        }
        Capture other = (Capture)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        SqlServerInterface.SnapshotMode this$snapshotMode = this.getSnapshotMode();
        SqlServerInterface.SnapshotMode other$snapshotMode = other.getSnapshotMode();
        return !(this$snapshotMode == null ? other$snapshotMode != null : !((Object)((Object)this$snapshotMode)).equals((Object)other$snapshotMode));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Capture;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        SqlServerInterface.SnapshotMode $snapshotMode = this.getSnapshotMode();
        result = result * 59 + ($snapshotMode == null ? 43 : ((Object)((Object)$snapshotMode)).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getDatabase() {
        return this.database;
    }

    @Override
    @Generated
    public SqlServerInterface.SnapshotMode getSnapshotMode() {
        return this.snapshotMode;
    }

    @Generated
    public Capture() {
        this.snapshotMode = Capture.$default$snapshotMode();
    }

    @Generated
    private static final class CaptureBuilderImpl
    extends CaptureBuilder<Capture, CaptureBuilderImpl> {
        @Generated
        private CaptureBuilderImpl() {
        }

        @Override
        @Generated
        protected CaptureBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Capture build() {
            return new Capture(this);
        }
    }

    @Generated
    public static abstract class CaptureBuilder<C extends Capture, B extends CaptureBuilder<C, B>>
    extends AbstractDebeziumTask.AbstractDebeziumTaskBuilder<C, B> {
        @Generated
        private String database;
        @Generated
        private boolean snapshotMode$set;
        @Generated
        private SqlServerInterface.SnapshotMode snapshotMode$value;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B database(String database) {
            this.database = database;
            return (B)((Object)this.self());
        }

        @Generated
        public B snapshotMode(SqlServerInterface.SnapshotMode snapshotMode) {
            this.snapshotMode$value = snapshotMode;
            this.snapshotMode$set = true;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        public String toString() {
            return "Capture.CaptureBuilder(super=" + super.toString() + ", database=" + this.database + ", snapshotMode$value=" + this.snapshotMode$value + ")";
        }
    }
}

