/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.internal.grpc.inprocess;

import com.clickhouse.client.internal.google.common.base.Preconditions;
import com.clickhouse.client.internal.google.errorprone.annotations.DoNotCall;
import com.clickhouse.client.internal.grpc.Deadline;
import com.clickhouse.client.internal.grpc.ExperimentalApi;
import com.clickhouse.client.internal.grpc.Internal;
import com.clickhouse.client.internal.grpc.ServerBuilder;
import com.clickhouse.client.internal.grpc.ServerStreamTracer;
import com.clickhouse.client.internal.grpc.inprocess.InProcessServer;
import com.clickhouse.client.internal.grpc.inprocess.InProcessSocketAddress;
import com.clickhouse.client.internal.grpc.internal.AbstractServerImplBuilder;
import com.clickhouse.client.internal.grpc.internal.FixedObjectPool;
import com.clickhouse.client.internal.grpc.internal.GrpcUtil;
import com.clickhouse.client.internal.grpc.internal.InternalServer;
import com.clickhouse.client.internal.grpc.internal.ObjectPool;
import com.clickhouse.client.internal.grpc.internal.ServerImplBuilder;
import com.clickhouse.client.internal.grpc.internal.SharedResourcePool;
import java.io.File;
import java.net.SocketAddress;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1783")
public final class InProcessServerBuilder
extends AbstractServerImplBuilder<InProcessServerBuilder> {
    private final ServerImplBuilder serverImplBuilder;
    final SocketAddress listenAddress;
    int maxInboundMetadataSize = Integer.MAX_VALUE;
    ObjectPool<ScheduledExecutorService> schedulerPool = SharedResourcePool.forResource(GrpcUtil.TIMER_SERVICE);

    public static InProcessServerBuilder forName(String name) {
        return InProcessServerBuilder.forAddress(new InProcessSocketAddress(Preconditions.checkNotNull(name, "name")));
    }

    public static InProcessServerBuilder forAddress(SocketAddress listenAddress) {
        return new InProcessServerBuilder(listenAddress);
    }

    @DoNotCall(value="Unsupported. Use forName() instead")
    public static InProcessServerBuilder forPort(int port) {
        throw new UnsupportedOperationException("call forName() instead");
    }

    public static String generateName() {
        return UUID.randomUUID().toString();
    }

    private InProcessServerBuilder(SocketAddress listenAddress) {
        this.listenAddress = Preconditions.checkNotNull(listenAddress, "listenAddress");
        final class InProcessClientTransportServersBuilder
        implements ServerImplBuilder.ClientTransportServersBuilder {
            InProcessClientTransportServersBuilder() {
            }

            @Override
            public InternalServer buildClientTransportServers(List<? extends ServerStreamTracer.Factory> streamTracerFactories) {
                return InProcessServerBuilder.this.buildTransportServers(streamTracerFactories);
            }
        }
        this.serverImplBuilder = new ServerImplBuilder(new InProcessClientTransportServersBuilder());
        this.serverImplBuilder.setStatsRecordStartedRpcs(false);
        this.serverImplBuilder.setStatsRecordFinishedRpcs(false);
        this.handshakeTimeout(Long.MAX_VALUE, TimeUnit.SECONDS);
    }

    @Override
    @Internal
    protected ServerBuilder<?> delegate() {
        return this.serverImplBuilder;
    }

    public InProcessServerBuilder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.schedulerPool = new FixedObjectPool<ScheduledExecutorService>(Preconditions.checkNotNull(scheduledExecutorService, "scheduledExecutorService"));
        return this;
    }

    public InProcessServerBuilder deadlineTicker(Deadline.Ticker ticker) {
        this.serverImplBuilder.setDeadlineTicker(ticker);
        return this;
    }

    @Override
    public InProcessServerBuilder maxInboundMetadataSize(int bytes) {
        Preconditions.checkArgument(bytes > 0, "maxInboundMetadataSize must be > 0");
        this.maxInboundMetadataSize = bytes;
        return this;
    }

    InProcessServer buildTransportServers(List<? extends ServerStreamTracer.Factory> streamTracerFactories) {
        return new InProcessServer(this, streamTracerFactories);
    }

    @Override
    public InProcessServerBuilder useTransportSecurity(File certChain, File privateKey) {
        throw new UnsupportedOperationException("TLS not supported in InProcessServer");
    }

    void setStatsEnabled(boolean value) {
        this.serverImplBuilder.setStatsEnabled(value);
    }
}

