/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.jdbc;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.tasks.common.FetchType;
import io.kestra.core.runners.RunContext;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.utils.Rethrow;
import io.kestra.plugin.jdbc.AbstractCellConverter;
import io.kestra.plugin.jdbc.JdbcQueryInterface;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.io.BufferedWriter;
import java.io.IOException;
import java.net.URI;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import lombok.Generated;

public abstract class AbstractJdbcQuery
extends Task
implements JdbcQueryInterface {
    private String url;
    private String username;
    private String password;
    private String timeZoneId;
    private String sql;
    @Deprecated(since="0.19.0", forRemoval=true)
    private boolean store;
    @Deprecated(since="0.19.0", forRemoval=true)
    private boolean fetchOne;
    @Deprecated(since="0.19.0", forRemoval=true)
    private boolean fetch;
    @NotNull
    protected FetchType fetchType;
    protected Integer fetchSize;
    protected transient Map<String, Object> additionalVars;
    private static final ObjectMapper MAPPER = JacksonMapper.ofIon();

    protected abstract AbstractCellConverter getCellConverter(ZoneId var1);

    protected Statement createStatement(Connection conn) throws SQLException {
        return conn.createStatement(1003, 1007);
    }

    /*
     * Exception decompiling
     */
    public Output run(RunContext runContext) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String[] tags() {
        return new String[]{"fetch", this.getFetchType().equals((Object)FetchType.FETCH) || this.getFetchType().equals((Object)FetchType.FETCH_ONE) ? "true" : "false", "store", this.getFetchType().equals((Object)FetchType.STORE) ? "true" : "false"};
    }

    protected Map<String, Object> fetchResult(ResultSet rs, AbstractCellConverter cellConverter, Connection connection) throws SQLException {
        if (rs.next()) {
            return this.mapResultSetToMap(rs, cellConverter, connection);
        }
        return null;
    }

    protected long fetchResults(Statement stmt, ResultSet rs, List<Map<String, Object>> maps, AbstractCellConverter cellConverter, Connection connection) throws SQLException {
        return this.fetch(stmt, rs, Rethrow.throwConsumer(maps::add), cellConverter, connection);
    }

    protected long fetchToFile(Statement stmt, ResultSet rs, BufferedWriter writer, AbstractCellConverter cellConverter, Connection connection) throws SQLException, IOException {
        return this.fetch(stmt, rs, Rethrow.throwConsumer(map -> {
            String s = MAPPER.writeValueAsString(map);
            writer.write(s);
            writer.write("\n");
        }), cellConverter, connection);
    }

    private long fetch(Statement stmt, ResultSet rs, Consumer<Map<String, Object>> c, AbstractCellConverter cellConverter, Connection connection) throws SQLException {
        long count = 0L;
        while (true) {
            if (rs.next()) {
                Map<String, Object> map = this.mapResultSetToMap(rs, cellConverter, connection);
                c.accept(map);
                ++count;
                continue;
            }
            boolean isResult = stmt.getMoreResults();
            if (!isResult) break;
        }
        return count;
    }

    private Map<String, Object> mapResultSetToMap(ResultSet rs, AbstractCellConverter cellConverter, Connection connection) throws SQLException {
        int columnsCount = rs.getMetaData().getColumnCount();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (int i = 1; i <= columnsCount; ++i) {
            map.put(rs.getMetaData().getColumnName(i), this.convertCell(i, rs, cellConverter, connection));
        }
        return map;
    }

    private Object convertCell(int columnIndex, ResultSet rs, AbstractCellConverter cellConverter, Connection connection) throws SQLException {
        return cellConverter.convertCell(columnIndex, rs, connection);
    }

    @Override
    public FetchType getFetchType() {
        if (this.fetch) {
            return FetchType.FETCH;
        }
        if (this.fetchOne) {
            return FetchType.FETCH_ONE;
        }
        if (this.store) {
            return FetchType.STORE;
        }
        return this.fetchType;
    }

    @Override
    public boolean isFetchOne() {
        return this.getFetchType().equals((Object)FetchType.FETCH_ONE);
    }

    @Override
    public boolean isFetch() {
        return this.getFetchType().equals((Object)FetchType.FETCH);
    }

    @Override
    public boolean isStore() {
        return this.getFetchType().equals((Object)FetchType.STORE);
    }

    @Generated
    private static boolean $default$store() {
        return false;
    }

    @Generated
    private static boolean $default$fetchOne() {
        return false;
    }

    @Generated
    private static boolean $default$fetch() {
        return false;
    }

    @Generated
    private static FetchType $default$fetchType() {
        return FetchType.NONE;
    }

    @Generated
    private static Integer $default$fetchSize() {
        return 10000;
    }

    @Generated
    private static Map<String, Object> $default$additionalVars() {
        return new HashMap<String, Object>();
    }

    @Generated
    protected AbstractJdbcQuery(AbstractJdbcQueryBuilder<?, ?> b) {
        super(b);
        this.url = b.url;
        this.username = b.username;
        this.password = b.password;
        this.timeZoneId = b.timeZoneId;
        this.sql = b.sql;
        this.store = b.store$set ? b.store$value : AbstractJdbcQuery.$default$store();
        this.fetchOne = b.fetchOne$set ? b.fetchOne$value : AbstractJdbcQuery.$default$fetchOne();
        this.fetch = b.fetch$set ? b.fetch$value : AbstractJdbcQuery.$default$fetch();
        this.fetchType = b.fetchType$set ? b.fetchType$value : AbstractJdbcQuery.$default$fetchType();
        this.fetchSize = b.fetchSize$set ? b.fetchSize$value : AbstractJdbcQuery.$default$fetchSize();
        this.additionalVars = b.additionalVars$set ? b.additionalVars$value : AbstractJdbcQuery.$default$additionalVars();
    }

    @Generated
    public String toString() {
        return "AbstractJdbcQuery(super=" + super.toString() + ", url=" + this.getUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", timeZoneId=" + this.getTimeZoneId() + ", sql=" + this.getSql() + ", store=" + this.isStore() + ", fetchOne=" + this.isFetchOne() + ", fetch=" + this.isFetch() + ", fetchType=" + String.valueOf(this.getFetchType()) + ", fetchSize=" + this.getFetchSize() + ", additionalVars=" + String.valueOf(this.additionalVars) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractJdbcQuery)) {
            return false;
        }
        AbstractJdbcQuery other = (AbstractJdbcQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isStore() != other.isStore()) {
            return false;
        }
        if (this.isFetchOne() != other.isFetchOne()) {
            return false;
        }
        if (this.isFetch() != other.isFetch()) {
            return false;
        }
        Integer this$fetchSize = this.getFetchSize();
        Integer other$fetchSize = other.getFetchSize();
        if (this$fetchSize == null ? other$fetchSize != null : !((Object)this$fetchSize).equals(other$fetchSize)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$timeZoneId = this.getTimeZoneId();
        String other$timeZoneId = other.getTimeZoneId();
        if (this$timeZoneId == null ? other$timeZoneId != null : !this$timeZoneId.equals(other$timeZoneId)) {
            return false;
        }
        String this$sql = this.getSql();
        String other$sql = other.getSql();
        if (this$sql == null ? other$sql != null : !this$sql.equals(other$sql)) {
            return false;
        }
        FetchType this$fetchType = this.getFetchType();
        FetchType other$fetchType = other.getFetchType();
        return !(this$fetchType == null ? other$fetchType != null : !this$fetchType.equals(other$fetchType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractJdbcQuery;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isStore() ? 79 : 97);
        result = result * 59 + (this.isFetchOne() ? 79 : 97);
        result = result * 59 + (this.isFetch() ? 79 : 97);
        Integer $fetchSize = this.getFetchSize();
        result = result * 59 + ($fetchSize == null ? 43 : ((Object)$fetchSize).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $timeZoneId = this.getTimeZoneId();
        result = result * 59 + ($timeZoneId == null ? 43 : $timeZoneId.hashCode());
        String $sql = this.getSql();
        result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
        FetchType $fetchType = this.getFetchType();
        result = result * 59 + ($fetchType == null ? 43 : $fetchType.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getUrl() {
        return this.url;
    }

    @Override
    @Generated
    public String getUsername() {
        return this.username;
    }

    @Override
    @Generated
    public String getPassword() {
        return this.password;
    }

    @Override
    @Generated
    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    @Override
    @Generated
    public String getSql() {
        return this.sql;
    }

    @Override
    @Generated
    public Integer getFetchSize() {
        return this.fetchSize;
    }

    @Generated
    public AbstractJdbcQuery() {
        this.store = AbstractJdbcQuery.$default$store();
        this.fetchOne = AbstractJdbcQuery.$default$fetchOne();
        this.fetch = AbstractJdbcQuery.$default$fetch();
        this.fetchType = AbstractJdbcQuery.$default$fetchType();
        this.fetchSize = AbstractJdbcQuery.$default$fetchSize();
        this.additionalVars = AbstractJdbcQuery.$default$additionalVars();
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="Map containing the first row of fetched data.", description="Only populated if `fetchOne` parameter is set to true.")
        @JsonInclude
        private final Map<String, Object> row;
        @Schema(title="List of map containing rows of fetched data.", description="Only populated if `fetch` parameter is set to true.")
        private final List<Map<String, Object>> rows;
        @Schema(title="The URI of the result file on Kestra's internal storage (.ion file / Amazon Ion formatted text file).", description="Only populated if `store` is set to true.")
        private final URI uri;
        @Schema(title="The number of rows fetched.", description="Only populated if `store` or `fetch` parameter is set to true.")
        private final Long size;

        @Generated
        protected Output(OutputBuilder<?, ?> b) {
            this.row = b.row;
            this.rows = b.rows;
            this.uri = b.uri;
            this.size = b.size;
        }

        @Generated
        public static OutputBuilder<?, ?> builder() {
            return new OutputBuilderImpl();
        }

        @Generated
        public Map<String, Object> getRow() {
            return this.row;
        }

        @Generated
        public List<Map<String, Object>> getRows() {
            return this.rows;
        }

        @Generated
        public URI getUri() {
            return this.uri;
        }

        @Generated
        public Long getSize() {
            return this.size;
        }

        @Generated
        public static abstract class OutputBuilder<C extends Output, B extends OutputBuilder<C, B>> {
            @Generated
            private Map<String, Object> row;
            @Generated
            private List<Map<String, Object>> rows;
            @Generated
            private URI uri;
            @Generated
            private Long size;

            @Generated
            public B row(Map<String, Object> row) {
                this.row = row;
                return this.self();
            }

            @Generated
            public B rows(List<Map<String, Object>> rows) {
                this.rows = rows;
                return this.self();
            }

            @Generated
            public B uri(URI uri) {
                this.uri = uri;
                return this.self();
            }

            @Generated
            public B size(Long size) {
                this.size = size;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "AbstractJdbcQuery.Output.OutputBuilder(row=" + String.valueOf(this.row) + ", rows=" + String.valueOf(this.rows) + ", uri=" + String.valueOf(this.uri) + ", size=" + this.size + ")";
            }
        }

        @Generated
        private static final class OutputBuilderImpl
        extends OutputBuilder<Output, OutputBuilderImpl> {
            @Generated
            private OutputBuilderImpl() {
            }

            @Override
            @Generated
            protected OutputBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public Output build() {
                return new Output(this);
            }
        }
    }

    @Generated
    public static abstract class AbstractJdbcQueryBuilder<C extends AbstractJdbcQuery, B extends AbstractJdbcQueryBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private String url;
        @Generated
        private String username;
        @Generated
        private String password;
        @Generated
        private String timeZoneId;
        @Generated
        private String sql;
        @Generated
        private boolean store$set;
        @Generated
        private boolean store$value;
        @Generated
        private boolean fetchOne$set;
        @Generated
        private boolean fetchOne$value;
        @Generated
        private boolean fetch$set;
        @Generated
        private boolean fetch$value;
        @Generated
        private boolean fetchType$set;
        @Generated
        private FetchType fetchType$value;
        @Generated
        private boolean fetchSize$set;
        @Generated
        private Integer fetchSize$value;
        @Generated
        private boolean additionalVars$set;
        @Generated
        private Map<String, Object> additionalVars$value;

        @Generated
        public B url(String url) {
            this.url = url;
            return (B)this.self();
        }

        @Generated
        public B username(String username) {
            this.username = username;
            return (B)this.self();
        }

        @Generated
        public B password(String password) {
            this.password = password;
            return (B)this.self();
        }

        @Generated
        public B timeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
            return (B)this.self();
        }

        @Generated
        public B sql(String sql) {
            this.sql = sql;
            return (B)this.self();
        }

        @Deprecated
        @Generated
        public B store(boolean store) {
            this.store$value = store;
            this.store$set = true;
            return (B)this.self();
        }

        @Deprecated
        @Generated
        public B fetchOne(boolean fetchOne) {
            this.fetchOne$value = fetchOne;
            this.fetchOne$set = true;
            return (B)this.self();
        }

        @Deprecated
        @Generated
        public B fetch(boolean fetch) {
            this.fetch$value = fetch;
            this.fetch$set = true;
            return (B)this.self();
        }

        @Generated
        public B fetchType(FetchType fetchType) {
            this.fetchType$value = fetchType;
            this.fetchType$set = true;
            return (B)this.self();
        }

        @Generated
        public B fetchSize(Integer fetchSize) {
            this.fetchSize$value = fetchSize;
            this.fetchSize$set = true;
            return (B)this.self();
        }

        @Generated
        public B additionalVars(Map<String, Object> additionalVars) {
            this.additionalVars$value = additionalVars;
            this.additionalVars$set = true;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "AbstractJdbcQuery.AbstractJdbcQueryBuilder(super=" + super.toString() + ", url=" + this.url + ", username=" + this.username + ", password=" + this.password + ", timeZoneId=" + this.timeZoneId + ", sql=" + this.sql + ", store$value=" + this.store$value + ", fetchOne$value=" + this.fetchOne$value + ", fetch$value=" + this.fetch$value + ", fetchType$value=" + String.valueOf(this.fetchType$value) + ", fetchSize$value=" + this.fetchSize$value + ", additionalVars$value=" + String.valueOf(this.additionalVars$value) + ")";
        }
    }
}

