/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.jdbc.clickhouse;

import com.clickhouse.jdbc.ClickHouseDriver;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.jdbc.AbstractCellConverter;
import io.kestra.plugin.jdbc.AbstractJdbcBatch;
import io.kestra.plugin.jdbc.clickhouse.ClickHouseCellConverter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.time.ZoneId;
import lombok.Generated;

@Schema(title="Bulk Insert new rows into a ClickHouse database.")
@Plugin(examples={@Example(title="Insert rows from another table to a Clickhouse database using asynchronous inserts.", full=true, code={"id: clickhouse_bulk_insert\nnamespace: company.team\n\ninputs:\n  - id: file\n    type: FILE\n\ntasks:\n  - id: bulk_insert\n    type: io.kestra.plugin.jdbc.clickhouse.BulkInsert\n    from: \"{{ inputs.file }}\"\n    url: jdbc:clickhouse://127.0.0.1:56982/\n    username: ch_user\n    password: ch_password\n    sql: INSERT INTO YourTable SETTINGS async_insert=1, wait_for_async_insert=1 values( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )\n"}), @Example(title="Insert data into specific columns via a SQL query to a ClickHouse database using asynchronous inserts.", full=true, code={"id: clickhouse_bulk_insert\nnamespace: company.team\n\ninputs:\n  - id: file\n    type: FILE\n\ntasks:\n  - id: bulk_insert\n    type: io.kestra.plugin.jdbc.clickhouse.BulkInsert\n    from: \"{{ inputs.file }}\"\n    url: jdbc:clickhouse://127.0.0.1:56982/\n    username: ch_user\n    password: ch_password\n    sql: INSERT INTO YourTable ( field1, field2, field3 ) SETTINGS async_insert=1, wait_for_async_insert=1 values( ?, ?, ? )\n"}), @Example(title="Insert data into specific columns via a SQL query to a ClickHouse database using asynchronous inserts.", full=true, code={"id: clickhouse_bulk_insert\nnamespace: company.team\n\ninputs:\n  - id: file\n    type: FILE\n\ntasks:\n  - id: bulk_insert\n    type: io.kestra.plugin.jdbc.clickhouse.BulkInsert\n    from: \"{{ inputs.file }}\"\n    url: jdbc:clickhouse://127.0.0.1:56982/\n    username: ch_user\n    password: ch_password\n    table: YourTable\n"})})
public class BulkInsert
extends AbstractJdbcBatch
implements RunnableTask<AbstractJdbcBatch.Output> {
    @Override
    protected AbstractCellConverter getCellConverter(ZoneId zoneId) {
        return new ClickHouseCellConverter(zoneId);
    }

    @Override
    public void registerDriver() throws SQLException {
        DriverManager.registerDriver(new ClickHouseDriver());
    }

    @Override
    public AbstractJdbcBatch.Output run(RunContext runContext) throws Exception {
        return super.run(runContext);
    }

    @Generated
    protected BulkInsert(BulkInsertBuilder<?, ?> b) {
        super(b);
    }

    @Generated
    public static BulkInsertBuilder<?, ?> builder() {
        return new BulkInsertBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "BulkInsert(super=" + super.toString() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BulkInsert)) {
            return false;
        }
        BulkInsert other = (BulkInsert)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BulkInsert;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Generated
    public BulkInsert() {
    }

    @Generated
    private static final class BulkInsertBuilderImpl
    extends BulkInsertBuilder<BulkInsert, BulkInsertBuilderImpl> {
        @Generated
        private BulkInsertBuilderImpl() {
        }

        @Override
        @Generated
        protected BulkInsertBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public BulkInsert build() {
            return new BulkInsert(this);
        }
    }

    @Generated
    public static abstract class BulkInsertBuilder<C extends BulkInsert, B extends BulkInsertBuilder<C, B>>
    extends AbstractJdbcBatch.AbstractJdbcBatchBuilder<C, B> {
        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "BulkInsert.BulkInsertBuilder(super=" + super.toString() + ")";
        }
    }
}

