/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.jdbc.clickhouse;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.tasks.InputFilesInterface;
import io.kestra.core.models.tasks.NamespaceFiles;
import io.kestra.core.models.tasks.NamespaceFilesInterface;
import io.kestra.core.models.tasks.OutputFilesInterface;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.tasks.runners.ScriptService;
import io.kestra.core.models.tasks.runners.TaskRunner;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.Rethrow;
import io.kestra.plugin.scripts.exec.scripts.models.ScriptOutput;
import io.kestra.plugin.scripts.exec.scripts.runners.CommandsWrapper;
import io.kestra.plugin.scripts.runner.docker.Docker;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

@Schema(title="Run clickhouse-local commands.")
@Plugin(examples={@Example(title="Run clickhouse-local commands", full=true, code={"id: clickhouse-local\nnamespace: company.team\ntasks:\n  - id: query\n    type: io.kestra.plugin.clickhouse.ClickHouseLocalCLI\n    commands:\n      - SELECT count() FROM s3('https://datasets-documentation.s3.eu-west-3.amazonaws.com/house_parquet/house_0.parquet')\n"})})
public class ClickHouseLocalCLI
extends Task
implements RunnableTask<ScriptOutput>,
NamespaceFilesInterface,
InputFilesInterface,
OutputFilesInterface {
    public static final String DEFAULT_IMAGE = "clickhouse/clickhouse-server:latest";
    @Schema(title="The commands to run before main list of commands.")
    @PluginProperty(dynamic=true)
    protected List<String> beforeCommands;
    @Schema(title="The commands to run.")
    @PluginProperty(dynamic=true)
    @NotEmpty
    protected List<String> commands;
    @Schema(title="Additional environment variables for the current process.")
    @PluginProperty(dynamic=true)
    protected Map<String, String> env;
    @Schema(title="The task runner to use.")
    @Valid
    @PluginProperty
    private TaskRunner taskRunner;
    @Schema(title="The Clickhouse container image.")
    @PluginProperty(dynamic=true)
    private String containerImage;
    private NamespaceFiles namespaceFiles;
    private Object inputFiles;
    private List<String> outputFiles;

    public ScriptOutput run(RunContext runContext) throws Exception {
        return new CommandsWrapper(runContext).withWarningOnStdErr(Boolean.valueOf(true)).withTaskRunner(this.taskRunner).withContainerImage(this.containerImage).withEnv((Map)Optional.ofNullable(this.env).orElse(new HashMap())).withNamespaceFiles(this.namespaceFiles).withInputFiles(this.inputFiles).withOutputFiles(this.outputFiles).withCommands(ScriptService.scriptCommands(List.of("clickhouse-local"), (List)Optional.ofNullable(this.beforeCommands).map(Rethrow.throwFunction(arg_0 -> ((RunContext)runContext).render(arg_0))).orElse(null), (List)runContext.render(this.commands))).run();
    }

    @Generated
    private static TaskRunner $default$taskRunner() {
        return Docker.instance();
    }

    @Generated
    private static String $default$containerImage() {
        return DEFAULT_IMAGE;
    }

    @Generated
    protected ClickHouseLocalCLI(ClickHouseLocalCLIBuilder<?, ?> b) {
        super(b);
        this.beforeCommands = b.beforeCommands;
        this.commands = b.commands;
        this.env = b.env;
        this.taskRunner = b.taskRunner$set ? b.taskRunner$value : ClickHouseLocalCLI.$default$taskRunner();
        this.containerImage = b.containerImage$set ? b.containerImage$value : ClickHouseLocalCLI.$default$containerImage();
        this.namespaceFiles = b.namespaceFiles;
        this.inputFiles = b.inputFiles;
        this.outputFiles = b.outputFiles;
    }

    @Generated
    public static ClickHouseLocalCLIBuilder<?, ?> builder() {
        return new ClickHouseLocalCLIBuilderImpl();
    }

    @Generated
    public String toString() {
        return "ClickHouseLocalCLI(super=" + super.toString() + ", beforeCommands=" + String.valueOf(this.getBeforeCommands()) + ", commands=" + String.valueOf(this.getCommands()) + ", env=" + String.valueOf(this.getEnv()) + ", taskRunner=" + String.valueOf(this.getTaskRunner()) + ", containerImage=" + this.getContainerImage() + ", namespaceFiles=" + String.valueOf(this.getNamespaceFiles()) + ", inputFiles=" + String.valueOf(this.getInputFiles()) + ", outputFiles=" + String.valueOf(this.getOutputFiles()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClickHouseLocalCLI)) {
            return false;
        }
        ClickHouseLocalCLI other = (ClickHouseLocalCLI)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$beforeCommands = this.getBeforeCommands();
        List<String> other$beforeCommands = other.getBeforeCommands();
        if (this$beforeCommands == null ? other$beforeCommands != null : !((Object)this$beforeCommands).equals(other$beforeCommands)) {
            return false;
        }
        List<String> this$commands = this.getCommands();
        List<String> other$commands = other.getCommands();
        if (this$commands == null ? other$commands != null : !((Object)this$commands).equals(other$commands)) {
            return false;
        }
        Map<String, String> this$env = this.getEnv();
        Map<String, String> other$env = other.getEnv();
        if (this$env == null ? other$env != null : !((Object)this$env).equals(other$env)) {
            return false;
        }
        TaskRunner this$taskRunner = this.getTaskRunner();
        TaskRunner other$taskRunner = other.getTaskRunner();
        if (this$taskRunner == null ? other$taskRunner != null : !this$taskRunner.equals(other$taskRunner)) {
            return false;
        }
        String this$containerImage = this.getContainerImage();
        String other$containerImage = other.getContainerImage();
        if (this$containerImage == null ? other$containerImage != null : !this$containerImage.equals(other$containerImage)) {
            return false;
        }
        NamespaceFiles this$namespaceFiles = this.getNamespaceFiles();
        NamespaceFiles other$namespaceFiles = other.getNamespaceFiles();
        if (this$namespaceFiles == null ? other$namespaceFiles != null : !this$namespaceFiles.equals(other$namespaceFiles)) {
            return false;
        }
        Object this$inputFiles = this.getInputFiles();
        Object other$inputFiles = other.getInputFiles();
        if (this$inputFiles == null ? other$inputFiles != null : !this$inputFiles.equals(other$inputFiles)) {
            return false;
        }
        List<String> this$outputFiles = this.getOutputFiles();
        List<String> other$outputFiles = other.getOutputFiles();
        return !(this$outputFiles == null ? other$outputFiles != null : !((Object)this$outputFiles).equals(other$outputFiles));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClickHouseLocalCLI;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<String> $beforeCommands = this.getBeforeCommands();
        result = result * 59 + ($beforeCommands == null ? 43 : ((Object)$beforeCommands).hashCode());
        List<String> $commands = this.getCommands();
        result = result * 59 + ($commands == null ? 43 : ((Object)$commands).hashCode());
        Map<String, String> $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : ((Object)$env).hashCode());
        TaskRunner $taskRunner = this.getTaskRunner();
        result = result * 59 + ($taskRunner == null ? 43 : $taskRunner.hashCode());
        String $containerImage = this.getContainerImage();
        result = result * 59 + ($containerImage == null ? 43 : $containerImage.hashCode());
        NamespaceFiles $namespaceFiles = this.getNamespaceFiles();
        result = result * 59 + ($namespaceFiles == null ? 43 : $namespaceFiles.hashCode());
        Object $inputFiles = this.getInputFiles();
        result = result * 59 + ($inputFiles == null ? 43 : $inputFiles.hashCode());
        List<String> $outputFiles = this.getOutputFiles();
        result = result * 59 + ($outputFiles == null ? 43 : ((Object)$outputFiles).hashCode());
        return result;
    }

    @Generated
    public List<String> getBeforeCommands() {
        return this.beforeCommands;
    }

    @Generated
    public List<String> getCommands() {
        return this.commands;
    }

    @Generated
    public Map<String, String> getEnv() {
        return this.env;
    }

    @Generated
    public TaskRunner getTaskRunner() {
        return this.taskRunner;
    }

    @Generated
    public String getContainerImage() {
        return this.containerImage;
    }

    @Generated
    public NamespaceFiles getNamespaceFiles() {
        return this.namespaceFiles;
    }

    @Generated
    public Object getInputFiles() {
        return this.inputFiles;
    }

    @Generated
    public List<String> getOutputFiles() {
        return this.outputFiles;
    }

    @Generated
    public ClickHouseLocalCLI() {
        this.taskRunner = ClickHouseLocalCLI.$default$taskRunner();
        this.containerImage = ClickHouseLocalCLI.$default$containerImage();
    }

    @Generated
    public static abstract class ClickHouseLocalCLIBuilder<C extends ClickHouseLocalCLI, B extends ClickHouseLocalCLIBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private List<String> beforeCommands;
        @Generated
        private List<String> commands;
        @Generated
        private Map<String, String> env;
        @Generated
        private boolean taskRunner$set;
        @Generated
        private TaskRunner taskRunner$value;
        @Generated
        private boolean containerImage$set;
        @Generated
        private String containerImage$value;
        @Generated
        private NamespaceFiles namespaceFiles;
        @Generated
        private Object inputFiles;
        @Generated
        private List<String> outputFiles;

        @Generated
        public B beforeCommands(List<String> beforeCommands) {
            this.beforeCommands = beforeCommands;
            return (B)this.self();
        }

        @Generated
        public B commands(List<String> commands) {
            this.commands = commands;
            return (B)this.self();
        }

        @Generated
        public B env(Map<String, String> env) {
            this.env = env;
            return (B)this.self();
        }

        @Generated
        public B taskRunner(TaskRunner taskRunner) {
            this.taskRunner$value = taskRunner;
            this.taskRunner$set = true;
            return (B)this.self();
        }

        @Generated
        public B containerImage(String containerImage) {
            this.containerImage$value = containerImage;
            this.containerImage$set = true;
            return (B)this.self();
        }

        @Generated
        public B namespaceFiles(NamespaceFiles namespaceFiles) {
            this.namespaceFiles = namespaceFiles;
            return (B)this.self();
        }

        @Generated
        public B inputFiles(Object inputFiles) {
            this.inputFiles = inputFiles;
            return (B)this.self();
        }

        @Generated
        public B outputFiles(List<String> outputFiles) {
            this.outputFiles = outputFiles;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "ClickHouseLocalCLI.ClickHouseLocalCLIBuilder(super=" + super.toString() + ", beforeCommands=" + String.valueOf(this.beforeCommands) + ", commands=" + String.valueOf(this.commands) + ", env=" + String.valueOf(this.env) + ", taskRunner$value=" + String.valueOf(this.taskRunner$value) + ", containerImage$value=" + this.containerImage$value + ", namespaceFiles=" + String.valueOf(this.namespaceFiles) + ", inputFiles=" + String.valueOf(this.inputFiles) + ", outputFiles=" + String.valueOf(this.outputFiles) + ")";
        }
    }

    @Generated
    private static final class ClickHouseLocalCLIBuilderImpl
    extends ClickHouseLocalCLIBuilder<ClickHouseLocalCLI, ClickHouseLocalCLIBuilderImpl> {
        @Generated
        private ClickHouseLocalCLIBuilderImpl() {
        }

        @Override
        @Generated
        protected ClickHouseLocalCLIBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ClickHouseLocalCLI build() {
            return new ClickHouseLocalCLI(this);
        }
    }
}

