/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.jdbc.clickhouse;

import io.kestra.plugin.jdbc.AbstractCellConverter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.yandex.clickhouse.ClickHouseArray;

public class ClickHouseCellConverter
extends AbstractCellConverter {
    private static final Pattern PATTERN = Pattern.compile("DateTime(64)?\\((.*)'(.*)'\\)");

    public ClickHouseCellConverter(ZoneId zoneId) {
        super(zoneId);
    }

    @Override
    public Object convertCell(int columnIndex, ResultSet rs, Connection connection) throws SQLException {
        Object data = rs.getObject(columnIndex);
        if (data == null) {
            return null;
        }
        Object columnVal = rs.getObject(columnIndex);
        String columnTypeName = rs.getMetaData().getColumnTypeName(columnIndex);
        if (columnVal instanceof ClickHouseArray) {
            ClickHouseArray col = (ClickHouseArray)columnVal;
            return col.getArray();
        }
        if (columnTypeName.startsWith("DateTime")) {
            Matcher matcher = PATTERN.matcher(columnTypeName);
            if (!matcher.find() || matcher.groupCount() < 3) {
                throw new IllegalArgumentException("Invalid Column Type '" + columnTypeName + "'");
            }
            return LocalDateTime.parse(rs.getString(columnIndex), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss[.SSSSSS][.SSSSS][.SSSS][.SSS][.SS][.S]")).atZone(ZoneId.of(matcher.group(3))).withZoneSameInstant(this.zoneId);
        }
        return super.convert(columnIndex, rs);
    }
}

