/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.jdbc.clickhouse;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.jdbc.AbstractCellConverter;
import io.kestra.plugin.jdbc.AbstractJdbcQuery;
import io.kestra.plugin.jdbc.clickhouse.ClickHouseCellConverter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.time.ZoneId;
import lombok.Generated;
import ru.yandex.clickhouse.ClickHouseDriver;

@Schema(title="Clickhouse Query Task.", description="Currently supported types are the following ones : \n - Int8,\n - Float32,\n - Float64,\n - Decimal(n, m),\n - String,\n - FixedString(n),\n - UUID,\n - Date,\n - DateTime(n),\n - DateTime64(n, m),\n - Enum,\n - LowCardinality(n),\n - Array(n),\n - Nested(),\n - Tuple(n, m),\n - Nullable(n),\n - Ipv4,\n - Ipv6")
@Plugin(examples={@Example(title="Request a Clickhouse Database and fetch a row as outputs", code={"url: jdbc:clickhouse://127.0.0.1:56982/", "username: clickhouse", "password: ch_passwd", "sql: select * from clickhouse_types", "fetchOne: true"})})
public class Query
extends AbstractJdbcQuery
implements RunnableTask<AbstractJdbcQuery.Output> {
    @Override
    protected AbstractCellConverter getCellConverter(ZoneId zoneId) {
        return new ClickHouseCellConverter(zoneId);
    }

    @Override
    protected void registerDriver() throws SQLException {
        DriverManager.registerDriver(new ClickHouseDriver());
    }

    @Override
    public AbstractJdbcQuery.Output run(RunContext runContext) throws Exception {
        return super.run(runContext);
    }

    @Generated
    protected Query(QueryBuilder<?, ?> b) {
        super((AbstractJdbcQuery.AbstractJdbcQueryBuilder<?, ?>)b);
    }

    @Generated
    public static QueryBuilder<?, ?> builder() {
        return new QueryBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "Query(super=" + super.toString() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Query)) {
            return false;
        }
        Query other = (Query)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Query;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Generated
    public Query() {
    }

    @Generated
    private static final class QueryBuilderImpl
    extends QueryBuilder<Query, QueryBuilderImpl> {
        @Generated
        private QueryBuilderImpl() {
        }

        @Override
        @Generated
        protected QueryBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Query build() {
            return new Query(this);
        }
    }

    @Generated
    public static abstract class QueryBuilder<C extends Query, B extends QueryBuilder<C, B>>
    extends AbstractJdbcQuery.AbstractJdbcQueryBuilder<C, B> {
        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Query.QueryBuilder(super=" + super.toString() + ")";
        }
    }
}

