/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.jdbc;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.AbstractMetricEntry;
import io.kestra.core.models.executions.metrics.Counter;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.kestra.core.serializers.FileSerde;
import io.kestra.core.utils.Rethrow;
import io.kestra.plugin.jdbc.AbstractCellConverter;
import io.kestra.plugin.jdbc.JdbcStatementInterface;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.slf4j.Logger;
import reactor.core.publisher.Flux;

public abstract class AbstractJdbcBatch
extends Task
implements JdbcStatementInterface {
    private String url;
    private String username;
    private String password;
    private String timeZoneId;
    @NotNull
    @Schema(title="Source file URI")
    @PluginProperty(dynamic=true)
    private String from;
    @NotNull
    @Schema(title="Insert query to be executed.", description="The query must have as many question marks as the number of columns in the table.\nExample: 'insert into <table_name> values( ? , ? , ? )' for 3 columns.\nIn case you do not want all columns, you need to specify it in the query in the columns property\nExample: 'insert into <table_name> (id, name) values( ? , ? )' for inserting data into 2 columns: 'id' and 'name'.")
    @PluginProperty(dynamic=true)
    private String sql;
    @Schema(title="The size of chunk for every bulk request.")
    @PluginProperty(dynamic=true)
    @NotNull
    private Integer chunk;
    @Schema(title="The columns to be inserted.", description="If not provided, `?` count need to match the `from` number of columns.")
    @PluginProperty(dynamic=true)
    private List<String> columns;
    @Schema(title="The table from which column names will be retrieved.", description="This property specifies the table name which will be used to retrieve the columns for the inserted values.\nYou can use it instead of specifying manually the columns in the `columns` property. In this case, the `sql` property can also be omitted, an INSERT statement would be generated automatically.")
    @PluginProperty(dynamic=true)
    private String table;

    protected abstract AbstractCellConverter getCellConverter(ZoneId var1);

    public Output run(RunContext runContext) throws Exception {
        Logger logger = runContext.logger();
        URI from = new URI(runContext.render(this.from));
        AtomicLong count = new AtomicLong();
        AbstractCellConverter cellConverter = this.getCellConverter(this.zoneId());
        List<String> columnsToUse = this.columns;
        if (columnsToUse == null && this.table != null) {
            columnsToUse = this.fetchColumnsFromTable(runContext, this.table);
        }
        String sql = columnsToUse != null && this.sql == null ? this.constructInsertStatement(runContext, this.table, columnsToUse) : runContext.render(this.sql);
        logger.debug("Starting prepared statement: {}", (Object)sql);
        try (Connection connection = this.connection(runContext);){
            Output output;
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(runContext.storage().getFile(from)), 32768);){
                connection.setAutoCommit(false);
                Flux flowable = FileSerde.readAll((Reader)bufferedReader).doOnNext(docWriteRequest -> count.incrementAndGet()).buffer(this.chunk.intValue(), this.chunk.intValue()).map(Rethrow.throwFunction(o2 -> {
                    PreparedStatement ps = connection.prepareStatement(sql);
                    ParameterType parameterMetaData = ParameterType.of(ps.getParameterMetaData());
                    for (Object value : o2) {
                        ps = this.addRows(ps, parameterMetaData, value, cellConverter, connection);
                        ps.addBatch();
                        ps.clearParameters();
                    }
                    int[] updatedRows = ps.executeBatch();
                    connection.commit();
                    return Arrays.stream(updatedRows).sum();
                }));
                Integer updated = (Integer)flowable.reduce(Integer::sum).block();
                runContext.metric((AbstractMetricEntry)Counter.of((String)"records", (Long)count.get(), (String[])new String[0]));
                runContext.metric((AbstractMetricEntry)Counter.of((String)"updated", (Integer)(updated == null ? 0 : updated), (String[])new String[0]));
                logger.info("Successfully executed {} bulk queries and updated {} rows", (Object)count.get(), (Object)updated);
                output = Output.builder().rowCount(count.get()).updatedCount(updated).build();
            }
            return output;
        }
    }

    private String constructInsertStatement(RunContext runContext, String table, List<String> columns) throws IllegalVariableEvaluationException {
        return String.format("INSERT INTO %s (%s) VALUES (%s)", runContext.render(table), String.join((CharSequence)", ", columns), String.join((CharSequence)", ", Collections.nCopies(columns.size(), "?")));
    }

    private List<String> fetchColumnsFromTable(RunContext runContext, String table) throws Exception {
        ArrayList<String> columns = new ArrayList<String>();
        try (Connection connection = this.connection(runContext);){
            DatabaseMetaData metaData = connection.getMetaData();
            try (ResultSet resultSet = metaData.getColumns(null, null, table, null);){
                while (resultSet.next()) {
                    columns.add(resultSet.getString("COLUMN_NAME"));
                }
            }
        }
        return columns;
    }

    private PreparedStatement addRows(PreparedStatement ps, ParameterType parameterMetaData, Object o2, AbstractCellConverter cellConverter, Connection connection) throws Exception {
        block3: {
            block2: {
                if (!(o2 instanceof Map)) break block2;
                Map map = (Map)o2;
                ListIterator iterKeys = new ArrayList(map.keySet()).listIterator();
                int index = 0;
                while (iterKeys.hasNext()) {
                    String col = (String)iterKeys.next();
                    if (this.columns != null && !this.columns.contains(col)) continue;
                    ps = cellConverter.addPreparedStatementValue(ps, parameterMetaData, map.get(col), ++index, connection);
                }
                break block3;
            }
            if (!(o2 instanceof Collection)) break block3;
            ListIterator iter = ((List)o2).listIterator();
            while (iter.hasNext()) {
                ps = cellConverter.addPreparedStatementValue(ps, parameterMetaData, iter.next(), iter.nextIndex(), connection);
            }
        }
        return ps;
    }

    @Generated
    private static Integer $default$chunk() {
        return 1000;
    }

    @Generated
    protected AbstractJdbcBatch(AbstractJdbcBatchBuilder<?, ?> b10) {
        super(b10);
        this.url = b10.url;
        this.username = b10.username;
        this.password = b10.password;
        this.timeZoneId = b10.timeZoneId;
        this.from = b10.from;
        this.sql = b10.sql;
        this.chunk = b10.chunk$set ? b10.chunk$value : AbstractJdbcBatch.$default$chunk();
        this.columns = b10.columns;
        this.table = b10.table;
    }

    @Generated
    public String toString() {
        return "AbstractJdbcBatch(super=" + super.toString() + ", url=" + this.getUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", timeZoneId=" + this.getTimeZoneId() + ", from=" + this.getFrom() + ", sql=" + this.getSql() + ", chunk=" + this.getChunk() + ", columns=" + String.valueOf(this.getColumns()) + ", table=" + this.getTable() + ")";
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof AbstractJdbcBatch)) {
            return false;
        }
        AbstractJdbcBatch other = (AbstractJdbcBatch)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        Integer this$chunk = this.getChunk();
        Integer other$chunk = other.getChunk();
        if (this$chunk == null ? other$chunk != null : !((Object)this$chunk).equals(other$chunk)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$timeZoneId = this.getTimeZoneId();
        String other$timeZoneId = other.getTimeZoneId();
        if (this$timeZoneId == null ? other$timeZoneId != null : !this$timeZoneId.equals(other$timeZoneId)) {
            return false;
        }
        String this$from = this.getFrom();
        String other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        String this$sql = this.getSql();
        String other$sql = other.getSql();
        if (this$sql == null ? other$sql != null : !this$sql.equals(other$sql)) {
            return false;
        }
        List<String> this$columns = this.getColumns();
        List<String> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        String this$table = this.getTable();
        String other$table = other.getTable();
        return !(this$table == null ? other$table != null : !this$table.equals(other$table));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractJdbcBatch;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $chunk = this.getChunk();
        result = result * 59 + ($chunk == null ? 43 : ((Object)$chunk).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $timeZoneId = this.getTimeZoneId();
        result = result * 59 + ($timeZoneId == null ? 43 : $timeZoneId.hashCode());
        String $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        String $sql = this.getSql();
        result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
        List<String> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        String $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getUrl() {
        return this.url;
    }

    @Override
    @Generated
    public String getUsername() {
        return this.username;
    }

    @Override
    @Generated
    public String getPassword() {
        return this.password;
    }

    @Override
    @Generated
    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    @Generated
    public String getFrom() {
        return this.from;
    }

    @Generated
    public String getSql() {
        return this.sql;
    }

    @Generated
    public Integer getChunk() {
        return this.chunk;
    }

    @Generated
    public List<String> getColumns() {
        return this.columns;
    }

    @Generated
    public String getTable() {
        return this.table;
    }

    @Generated
    public AbstractJdbcBatch() {
        this.chunk = AbstractJdbcBatch.$default$chunk();
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The rows count.")
        private final Long rowCount;
        @Schema(title="The updated rows count.")
        private final Integer updatedCount;

        @ConstructorProperties(value={"rowCount", "updatedCount"})
        @Generated
        Output(Long rowCount, Integer updatedCount) {
            this.rowCount = rowCount;
            this.updatedCount = updatedCount;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public Long getRowCount() {
            return this.rowCount;
        }

        @Generated
        public Integer getUpdatedCount() {
            return this.updatedCount;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private Long rowCount;
            @Generated
            private Integer updatedCount;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder rowCount(Long rowCount) {
                this.rowCount = rowCount;
                return this;
            }

            @Generated
            public OutputBuilder updatedCount(Integer updatedCount) {
                this.updatedCount = updatedCount;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.rowCount, this.updatedCount);
            }

            @Generated
            public String toString() {
                return "AbstractJdbcBatch.Output.OutputBuilder(rowCount=" + this.rowCount + ", updatedCount=" + this.updatedCount + ")";
            }
        }
    }

    public static class ParameterType {
        private final Map<Integer, Class<?>> cls = new HashMap();
        private final Map<Integer, Integer> types = new HashMap<Integer, Integer>();
        private final Map<Integer, String> typesName = new HashMap<Integer, String>();

        public static ParameterType of(ParameterMetaData parameterMetaData) throws SQLException, ClassNotFoundException {
            ParameterType parameterType = new ParameterType();
            for (int i10 = 1; i10 <= parameterMetaData.getParameterCount(); ++i10) {
                parameterType.cls.put(i10, Class.forName(parameterMetaData.getParameterClassName(i10)));
                parameterType.types.put(i10, parameterMetaData.getParameterType(i10));
                parameterType.typesName.put(i10, parameterMetaData.getParameterTypeName(i10));
            }
            return parameterType;
        }

        public Class<?> getClass(int index) {
            return this.cls.get(index);
        }

        public Integer getType(int index) {
            return this.types.get(index);
        }

        public String getTypeName(int index) {
            return this.typesName.get(index);
        }
    }

    @Generated
    public static abstract class AbstractJdbcBatchBuilder<C extends AbstractJdbcBatch, B extends AbstractJdbcBatchBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private String url;
        @Generated
        private String username;
        @Generated
        private String password;
        @Generated
        private String timeZoneId;
        @Generated
        private String from;
        @Generated
        private String sql;
        @Generated
        private boolean chunk$set;
        @Generated
        private Integer chunk$value;
        @Generated
        private List<String> columns;
        @Generated
        private String table;

        @Generated
        public B url(String url) {
            this.url = url;
            return (B)this.self();
        }

        @Generated
        public B username(String username) {
            this.username = username;
            return (B)this.self();
        }

        @Generated
        public B password(String password) {
            this.password = password;
            return (B)this.self();
        }

        @Generated
        public B timeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
            return (B)this.self();
        }

        @Generated
        public B from(String from) {
            this.from = from;
            return (B)this.self();
        }

        @Generated
        public B sql(String sql) {
            this.sql = sql;
            return (B)this.self();
        }

        @Generated
        public B chunk(Integer chunk) {
            this.chunk$value = chunk;
            this.chunk$set = true;
            return (B)this.self();
        }

        @Generated
        public B columns(List<String> columns) {
            this.columns = columns;
            return (B)this.self();
        }

        @Generated
        public B table(String table) {
            this.table = table;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "AbstractJdbcBatch.AbstractJdbcBatchBuilder(super=" + super.toString() + ", url=" + this.url + ", username=" + this.username + ", password=" + this.password + ", timeZoneId=" + this.timeZoneId + ", from=" + this.from + ", sql=" + this.sql + ", chunk$value=" + this.chunk$value + ", columns=" + String.valueOf(this.columns) + ", table=" + this.table + ")";
        }
    }
}

