/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.jdbc;

import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.tasks.Output;
import io.kestra.core.models.tasks.common.FetchType;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.PollingTriggerInterface;
import io.kestra.core.models.triggers.TriggerContext;
import io.kestra.core.models.triggers.TriggerOutput;
import io.kestra.core.models.triggers.TriggerService;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.jdbc.AbstractJdbcQuery;
import io.kestra.plugin.jdbc.JdbcQueryInterface;
import jakarta.validation.constraints.NotNull;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;

public abstract class AbstractJdbcTrigger
extends AbstractTrigger
implements PollingTriggerInterface,
TriggerOutput<AbstractJdbcQuery.Output>,
JdbcQueryInterface {
    private final Duration interval;
    private String url;
    private String username;
    private String password;
    private String timeZoneId;
    private String sql;
    @Deprecated(since="0.19.0", forRemoval=true)
    private boolean store;
    @Deprecated(since="0.19.0", forRemoval=true)
    private boolean fetchOne;
    @Deprecated(since="0.19.0", forRemoval=true)
    private boolean fetch;
    @NotNull
    protected FetchType fetchType;
    protected Integer fetchSize;
    protected transient Map<String, Object> additionalVars;

    public Optional<Execution> evaluate(ConditionContext conditionContext, TriggerContext context) throws Exception {
        RunContext runContext = conditionContext.getRunContext();
        Logger logger = runContext.logger();
        AbstractJdbcQuery.Output run = this.runQuery(runContext);
        logger.debug("Found '{}' rows from '{}'", (Object)run.getSize(), (Object)runContext.render(this.sql));
        if (Optional.ofNullable(run.getSize()).orElse(0L) == 0L) {
            return Optional.empty();
        }
        Execution execution = TriggerService.generateExecution((AbstractTrigger)this, (ConditionContext)conditionContext, (TriggerContext)context, (Output)run);
        return Optional.of(execution);
    }

    @Override
    public FetchType getFetchType() {
        if (this.fetch) {
            return FetchType.FETCH;
        }
        if (this.fetchOne) {
            return FetchType.FETCH_ONE;
        }
        if (this.store) {
            return FetchType.STORE;
        }
        return this.fetchType;
    }

    protected abstract AbstractJdbcQuery.Output runQuery(RunContext var1) throws Exception;

    @Generated
    private static Duration $default$interval() {
        return Duration.ofSeconds(60L);
    }

    @Generated
    private static boolean $default$store() {
        return false;
    }

    @Generated
    private static boolean $default$fetchOne() {
        return false;
    }

    @Generated
    private static boolean $default$fetch() {
        return false;
    }

    @Generated
    private static FetchType $default$fetchType() {
        return FetchType.NONE;
    }

    @Generated
    private static Integer $default$fetchSize() {
        return 10000;
    }

    @Generated
    private static Map<String, Object> $default$additionalVars() {
        return new HashMap<String, Object>();
    }

    @Generated
    protected AbstractJdbcTrigger(AbstractJdbcTriggerBuilder<?, ?> b10) {
        super(b10);
        this.interval = b10.interval$set ? b10.interval$value : AbstractJdbcTrigger.$default$interval();
        this.url = b10.url;
        this.username = b10.username;
        this.password = b10.password;
        this.timeZoneId = b10.timeZoneId;
        this.sql = b10.sql;
        this.store = b10.store$set ? b10.store$value : AbstractJdbcTrigger.$default$store();
        this.fetchOne = b10.fetchOne$set ? b10.fetchOne$value : AbstractJdbcTrigger.$default$fetchOne();
        this.fetch = b10.fetch$set ? b10.fetch$value : AbstractJdbcTrigger.$default$fetch();
        this.fetchType = b10.fetchType$set ? b10.fetchType$value : AbstractJdbcTrigger.$default$fetchType();
        this.fetchSize = b10.fetchSize$set ? b10.fetchSize$value : AbstractJdbcTrigger.$default$fetchSize();
        this.additionalVars = b10.additionalVars$set ? b10.additionalVars$value : AbstractJdbcTrigger.$default$additionalVars();
    }

    @Generated
    public String toString() {
        return "AbstractJdbcTrigger(super=" + super.toString() + ", interval=" + String.valueOf(this.getInterval()) + ", url=" + this.getUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", timeZoneId=" + this.getTimeZoneId() + ", sql=" + this.getSql() + ", store=" + this.isStore() + ", fetchOne=" + this.isFetchOne() + ", fetch=" + this.isFetch() + ", fetchType=" + String.valueOf(this.getFetchType()) + ", fetchSize=" + this.getFetchSize() + ", additionalVars=" + String.valueOf(this.additionalVars) + ")";
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof AbstractJdbcTrigger)) {
            return false;
        }
        AbstractJdbcTrigger other = (AbstractJdbcTrigger)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        if (this.isStore() != other.isStore()) {
            return false;
        }
        if (this.isFetchOne() != other.isFetchOne()) {
            return false;
        }
        if (this.isFetch() != other.isFetch()) {
            return false;
        }
        Integer this$fetchSize = this.getFetchSize();
        Integer other$fetchSize = other.getFetchSize();
        if (this$fetchSize == null ? other$fetchSize != null : !((Object)this$fetchSize).equals(other$fetchSize)) {
            return false;
        }
        Duration this$interval = this.getInterval();
        Duration other$interval = other.getInterval();
        if (this$interval == null ? other$interval != null : !((Object)this$interval).equals(other$interval)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$timeZoneId = this.getTimeZoneId();
        String other$timeZoneId = other.getTimeZoneId();
        if (this$timeZoneId == null ? other$timeZoneId != null : !this$timeZoneId.equals(other$timeZoneId)) {
            return false;
        }
        String this$sql = this.getSql();
        String other$sql = other.getSql();
        if (this$sql == null ? other$sql != null : !this$sql.equals(other$sql)) {
            return false;
        }
        FetchType this$fetchType = this.getFetchType();
        FetchType other$fetchType = other.getFetchType();
        return !(this$fetchType == null ? other$fetchType != null : !this$fetchType.equals(other$fetchType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractJdbcTrigger;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isStore() ? 79 : 97);
        result = result * 59 + (this.isFetchOne() ? 79 : 97);
        result = result * 59 + (this.isFetch() ? 79 : 97);
        Integer $fetchSize = this.getFetchSize();
        result = result * 59 + ($fetchSize == null ? 43 : ((Object)$fetchSize).hashCode());
        Duration $interval = this.getInterval();
        result = result * 59 + ($interval == null ? 43 : ((Object)$interval).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $timeZoneId = this.getTimeZoneId();
        result = result * 59 + ($timeZoneId == null ? 43 : $timeZoneId.hashCode());
        String $sql = this.getSql();
        result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
        FetchType $fetchType = this.getFetchType();
        result = result * 59 + ($fetchType == null ? 43 : $fetchType.hashCode());
        return result;
    }

    @Generated
    public Duration getInterval() {
        return this.interval;
    }

    @Override
    @Generated
    public String getUrl() {
        return this.url;
    }

    @Override
    @Generated
    public String getUsername() {
        return this.username;
    }

    @Override
    @Generated
    public String getPassword() {
        return this.password;
    }

    @Override
    @Generated
    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    @Override
    @Generated
    public String getSql() {
        return this.sql;
    }

    @Override
    @Deprecated
    @Generated
    public boolean isStore() {
        return this.store;
    }

    @Override
    @Deprecated
    @Generated
    public boolean isFetchOne() {
        return this.fetchOne;
    }

    @Override
    @Deprecated
    @Generated
    public boolean isFetch() {
        return this.fetch;
    }

    @Override
    @Generated
    public Integer getFetchSize() {
        return this.fetchSize;
    }

    @Generated
    public AbstractJdbcTrigger() {
        this.interval = AbstractJdbcTrigger.$default$interval();
        this.store = AbstractJdbcTrigger.$default$store();
        this.fetchOne = AbstractJdbcTrigger.$default$fetchOne();
        this.fetch = AbstractJdbcTrigger.$default$fetch();
        this.fetchType = AbstractJdbcTrigger.$default$fetchType();
        this.fetchSize = AbstractJdbcTrigger.$default$fetchSize();
        this.additionalVars = AbstractJdbcTrigger.$default$additionalVars();
    }

    @Generated
    public static abstract class AbstractJdbcTriggerBuilder<C extends AbstractJdbcTrigger, B extends AbstractJdbcTriggerBuilder<C, B>>
    extends AbstractTrigger.AbstractTriggerBuilder<C, B> {
        @Generated
        private boolean interval$set;
        @Generated
        private Duration interval$value;
        @Generated
        private String url;
        @Generated
        private String username;
        @Generated
        private String password;
        @Generated
        private String timeZoneId;
        @Generated
        private String sql;
        @Generated
        private boolean store$set;
        @Generated
        private boolean store$value;
        @Generated
        private boolean fetchOne$set;
        @Generated
        private boolean fetchOne$value;
        @Generated
        private boolean fetch$set;
        @Generated
        private boolean fetch$value;
        @Generated
        private boolean fetchType$set;
        @Generated
        private FetchType fetchType$value;
        @Generated
        private boolean fetchSize$set;
        @Generated
        private Integer fetchSize$value;
        @Generated
        private boolean additionalVars$set;
        @Generated
        private Map<String, Object> additionalVars$value;

        @Generated
        public B interval(Duration interval) {
            this.interval$value = interval;
            this.interval$set = true;
            return (B)this.self();
        }

        @Generated
        public B url(String url) {
            this.url = url;
            return (B)this.self();
        }

        @Generated
        public B username(String username) {
            this.username = username;
            return (B)this.self();
        }

        @Generated
        public B password(String password) {
            this.password = password;
            return (B)this.self();
        }

        @Generated
        public B timeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
            return (B)this.self();
        }

        @Generated
        public B sql(String sql) {
            this.sql = sql;
            return (B)this.self();
        }

        @Deprecated
        @Generated
        public B store(boolean store) {
            this.store$value = store;
            this.store$set = true;
            return (B)this.self();
        }

        @Deprecated
        @Generated
        public B fetchOne(boolean fetchOne) {
            this.fetchOne$value = fetchOne;
            this.fetchOne$set = true;
            return (B)this.self();
        }

        @Deprecated
        @Generated
        public B fetch(boolean fetch) {
            this.fetch$value = fetch;
            this.fetch$set = true;
            return (B)this.self();
        }

        @Generated
        public B fetchType(FetchType fetchType) {
            this.fetchType$value = fetchType;
            this.fetchType$set = true;
            return (B)this.self();
        }

        @Generated
        public B fetchSize(Integer fetchSize) {
            this.fetchSize$value = fetchSize;
            this.fetchSize$set = true;
            return (B)this.self();
        }

        @Generated
        public B additionalVars(Map<String, Object> additionalVars) {
            this.additionalVars$value = additionalVars;
            this.additionalVars$set = true;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "AbstractJdbcTrigger.AbstractJdbcTriggerBuilder(super=" + super.toString() + ", interval$value=" + String.valueOf(this.interval$value) + ", url=" + this.url + ", username=" + this.username + ", password=" + this.password + ", timeZoneId=" + this.timeZoneId + ", sql=" + this.sql + ", store$value=" + this.store$value + ", fetchOne$value=" + this.fetchOne$value + ", fetch$value=" + this.fetch$value + ", fetchType$value=" + String.valueOf(this.fetchType$value) + ", fetchSize$value=" + this.fetchSize$value + ", additionalVars$value=" + String.valueOf(this.additionalVars$value) + ")";
        }
    }
}

