/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.jdbc.db2;

import com.ibm.db2.jcc.am.ResultSet;
import io.kestra.plugin.jdbc.AbstractCellConverter;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.ZoneId;

public class Db2CellConverter
extends AbstractCellConverter {
    public Db2CellConverter(ZoneId zoneId) {
        super(zoneId);
    }

    @Override
    public Object convertCell(int columnIndex, java.sql.ResultSet rs, Connection connection) throws SQLException {
        Object data = rs.getObject(columnIndex);
        if (data == null) {
            return null;
        }
        String columnTypeName = rs.getMetaData().getColumnTypeName(columnIndex);
        return switch (columnTypeName.toLowerCase()) {
            case "char", "varchar" -> ((ResultSet)rs).getString(columnIndex);
            case "date" -> ((ResultSet)rs).getDate(columnIndex).toLocalDate();
            case "time" -> ((ResultSet)rs).getTime(columnIndex).toLocalTime();
            case "timestamp" -> ((ResultSet)rs).getTimestamp(columnIndex).toInstant();
            case "blob" -> ((ResultSet)rs).getBlob(columnIndex);
            case "clob" -> ((ResultSet)rs).getClob(columnIndex);
            case "nclob" -> ((ResultSet)rs).getNClob(columnIndex);
            case "xml" -> ((ResultSet)rs).getSQLXML(columnIndex);
            default -> super.convert(columnIndex, rs);
        };
    }
}

