/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.jdbc.db2;

import com.ibm.db2.jcc.DB2Driver;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.jdbc.AbstractCellConverter;
import io.kestra.plugin.jdbc.AbstractJdbcQuery;
import io.kestra.plugin.jdbc.AutoCommitInterface;
import io.kestra.plugin.jdbc.db2.Db2CellConverter;
import io.micronaut.http.uri.UriBuilder;
import io.swagger.v3.oas.annotations.media.Schema;
import java.net.URI;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.time.ZoneId;
import java.util.Properties;
import lombok.Generated;

@Schema(title="Query a DB2 database.")
@Plugin(examples={@Example(title="Send a SQL query to a DB2 Database and fetch a row as output.", full=true, code={"id: db2_query\nnamespace: company.team\n\ntasks:\n  - id: query\n    type: io.kestra.plugin.jdbc.db2.Query\n    url: jdbc:db2://127.0.0.1:50000/\n    username: db2inst\n    password: db2_password\n    sql: select * from db2_types\n    fetchType: FETCH_ONE\n"})})
public class Query
extends AbstractJdbcQuery
implements RunnableTask<AbstractJdbcQuery.Output>,
AutoCommitInterface {
    protected final Boolean autoCommit = true;

    @Override
    protected AbstractCellConverter getCellConverter(ZoneId zoneId) {
        return new Db2CellConverter(zoneId);
    }

    @Override
    public void registerDriver() throws SQLException {
        if (DriverManager.drivers().noneMatch(DB2Driver.class::isInstance)) {
            DriverManager.registerDriver(new DB2Driver());
        }
    }

    @Override
    public Properties connectionProperties(RunContext runContext) throws Exception {
        Properties props = super.connectionProperties(runContext);
        URI url = URI.create((String)props.get("jdbc.url"));
        url = URI.create(url.getSchemeSpecificPart());
        UriBuilder builder = UriBuilder.of((URI)url).scheme("jdbc:db2");
        props.put("jdbc.url", builder.build().toString());
        return props;
    }

    @Generated
    protected Query(QueryBuilder<?, ?> b10) {
        super(b10);
    }

    @Generated
    public static QueryBuilder<?, ?> builder() {
        return new QueryBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "Query(super=" + super.toString() + ", autoCommit=" + this.getAutoCommit() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof Query)) {
            return false;
        }
        Query other = (Query)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        Boolean this$autoCommit = this.getAutoCommit();
        Boolean other$autoCommit = other.getAutoCommit();
        return !(this$autoCommit == null ? other$autoCommit != null : !((Object)this$autoCommit).equals(other$autoCommit));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Query;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $autoCommit = this.getAutoCommit();
        result = result * 59 + ($autoCommit == null ? 43 : ((Object)$autoCommit).hashCode());
        return result;
    }

    @Override
    @Generated
    public Boolean getAutoCommit() {
        return this.autoCommit;
    }

    @Generated
    public Query() {
    }

    @Generated
    private static final class QueryBuilderImpl
    extends QueryBuilder<Query, QueryBuilderImpl> {
        @Generated
        private QueryBuilderImpl() {
        }

        @Override
        @Generated
        protected QueryBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Query build() {
            return new Query(this);
        }
    }

    @Generated
    public static abstract class QueryBuilder<C extends Query, B extends QueryBuilder<C, B>>
    extends AbstractJdbcQuery.AbstractJdbcQueryBuilder<C, B> {
        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Query.QueryBuilder(super=" + super.toString() + ")";
        }
    }
}

