/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.jdbc;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.ZoneId;
import java.util.List;
import java.util.UUID;

public abstract class AbstractCellConverter {
    protected ZoneId zoneId;
    private static final List<Class<?>> SIMPLE_TYPES = ImmutableList.of(String.class, Boolean.class, Integer.class, Short.class, Long.class, Float.class, Double.class, UUID.class, BigDecimal.class, byte[].class);

    public AbstractCellConverter(ZoneId zoneId) {
        this.zoneId = zoneId;
    }

    public abstract Object convertCell(int var1, ResultSet var2, Connection var3) throws SQLException;

    protected Object convert(int columnIndex, ResultSet rs) throws SQLException {
        Object data = rs.getObject(columnIndex);
        if (data == null) {
            return null;
        }
        Class<?> clazz = data.getClass();
        if (SIMPLE_TYPES.contains(clazz)) {
            return data;
        }
        if (clazz.equals(BigInteger.class)) {
            return data.toString();
        }
        if (clazz.equals(BigDecimal.class)) {
            return data.toString();
        }
        if (clazz.equals(Date.class)) {
            return ((Date)data).toLocalDate();
        }
        if (clazz.equals(Timestamp.class)) {
            return ((Timestamp)data).toInstant().atZone(this.zoneId);
        }
        throw new IllegalArgumentException("Data of type [" + clazz + "] is not supported");
    }
}

