/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.jdbc;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.tasks.common.FetchType;
import io.kestra.core.runners.RunContext;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.utils.Rethrow;
import io.kestra.plugin.jdbc.AbstractCellConverter;
import io.kestra.plugin.jdbc.JdbcQueryInterface;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.io.BufferedWriter;
import java.io.IOException;
import java.net.URI;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public abstract class AbstractJdbcBaseQuery
extends Task
implements JdbcQueryInterface {
    private Property<String> url;
    private Property<String> username;
    private Property<String> password;
    private Property<String> timeZoneId;
    protected Property<String> sql;
    @Deprecated(since="0.19.0", forRemoval=true)
    private boolean store;
    @Deprecated(since="0.19.0", forRemoval=true)
    private boolean fetchOne;
    @Deprecated(since="0.19.0", forRemoval=true)
    private boolean fetch;
    @NotNull
    protected Property<FetchType> fetchType;
    protected Property<Integer> fetchSize;
    protected Property<Map<String, Object>> parameters;
    protected transient Map<String, Object> additionalVars;
    private static final ObjectMapper MAPPER = JacksonMapper.ofIon();

    protected abstract AbstractCellConverter getCellConverter(ZoneId var1);

    protected Statement createStatement(Connection conn) throws SQLException {
        return conn.createStatement(1003, 1007);
    }

    protected String[] tags(RunContext runContext) throws IllegalVariableEvaluationException {
        FetchType fetchTypeRendered = this.renderFetchType(runContext);
        return new String[]{"fetch", fetchTypeRendered.equals((Object)FetchType.FETCH) || fetchTypeRendered.equals((Object)FetchType.FETCH_ONE) ? "true" : "false", "store", fetchTypeRendered.equals((Object)FetchType.STORE) ? "true" : "false"};
    }

    protected Map<String, Object> fetchResult(ResultSet rs, AbstractCellConverter cellConverter, Connection connection) throws SQLException {
        if (rs.next()) {
            return this.mapResultSetToMap(rs, cellConverter, connection);
        }
        return null;
    }

    protected long fetchResults(Statement stmt, ResultSet rs, List<Map<String, Object>> maps, AbstractCellConverter cellConverter, Connection connection) throws SQLException {
        return this.fetch(stmt, rs, Rethrow.throwConsumer(maps::add), cellConverter, connection);
    }

    protected long fetchToFile(Statement stmt, ResultSet rs, BufferedWriter writer, AbstractCellConverter cellConverter, Connection connection) throws SQLException, IOException {
        return this.fetch(stmt, rs, Rethrow.throwConsumer(map -> {
            String s = MAPPER.writeValueAsString(map);
            writer.write(s);
            writer.write("\n");
        }), cellConverter, connection);
    }

    protected long fetch(Statement stmt, ResultSet rs, Consumer<Map<String, Object>> c, AbstractCellConverter cellConverter, Connection connection) throws SQLException {
        long count = 0L;
        while (true) {
            if (rs.next()) {
                Map<String, Object> map = this.mapResultSetToMap(rs, cellConverter, connection);
                c.accept(map);
                ++count;
                continue;
            }
            boolean isResult = stmt.getMoreResults();
            if (!isResult) break;
        }
        return count;
    }

    protected Map<String, Object> mapResultSetToMap(ResultSet rs, AbstractCellConverter cellConverter, Connection connection) throws SQLException {
        int columnsCount = rs.getMetaData().getColumnCount();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (int i = 1; i <= columnsCount; ++i) {
            map.put(rs.getMetaData().getColumnLabel(i), this.convertCell(i, rs, cellConverter, connection));
        }
        return map;
    }

    private Object convertCell(int columnIndex, ResultSet rs, AbstractCellConverter cellConverter, Connection connection) throws SQLException {
        return cellConverter.convertCell(columnIndex, rs, connection);
    }

    public FetchType renderFetchType(RunContext runContext) throws IllegalVariableEvaluationException {
        if (this.fetch) {
            return FetchType.FETCH;
        }
        if (this.fetchOne) {
            return FetchType.FETCH_ONE;
        }
        if (this.store) {
            return FetchType.STORE;
        }
        return (FetchType)runContext.render(this.fetchType).as(FetchType.class).orElseThrow();
    }

    protected PreparedStatement prepareStatement(RunContext runContext, Connection conn, String sql) throws SQLException, IllegalVariableEvaluationException {
        Map namedParamsRendered = (Map)runContext.render(this.getParameters()).asMap(String.class, Object.class);
        if (namedParamsRendered.isEmpty()) {
            return this.createPreparedStatement(conn, sql);
        }
        String preparedSql = sql;
        Pattern pattern = Pattern.compile(":\\w+");
        Matcher matcher = pattern.matcher(preparedSql);
        LinkedList<String> params = new LinkedList<String>();
        while (matcher.find()) {
            String param = matcher.group();
            params.add(param.substring(1));
            preparedSql = matcher.replaceFirst("?");
            matcher = pattern.matcher(preparedSql);
        }
        PreparedStatement stmt = this.createPreparedStatement(conn, preparedSql);
        for (int i = 0; i < params.size(); ++i) {
            stmt.setObject(i + 1, namedParamsRendered.get(params.get(i)));
        }
        return stmt;
    }

    protected PreparedStatement createPreparedStatement(Connection conn, String sql) throws SQLException {
        return conn.prepareStatement(sql, 1003, 1007);
    }

    @Generated
    private static boolean $default$store() {
        return false;
    }

    @Generated
    private static boolean $default$fetchOne() {
        return false;
    }

    @Generated
    private static boolean $default$fetch() {
        return false;
    }

    @Generated
    private static Property<FetchType> $default$fetchType() {
        return Property.of((Object)FetchType.NONE);
    }

    @Generated
    private static Property<Integer> $default$fetchSize() {
        return Property.of((Object)10000);
    }

    @Generated
    private static Map<String, Object> $default$additionalVars() {
        return new HashMap<String, Object>();
    }

    @Generated
    protected AbstractJdbcBaseQuery(AbstractJdbcBaseQueryBuilder<?, ?> b) {
        super(b);
        this.url = b.url;
        this.username = b.username;
        this.password = b.password;
        this.timeZoneId = b.timeZoneId;
        this.sql = b.sql;
        this.store = b.store$set ? b.store$value : AbstractJdbcBaseQuery.$default$store();
        this.fetchOne = b.fetchOne$set ? b.fetchOne$value : AbstractJdbcBaseQuery.$default$fetchOne();
        this.fetch = b.fetch$set ? b.fetch$value : AbstractJdbcBaseQuery.$default$fetch();
        this.fetchType = b.fetchType$set ? b.fetchType$value : AbstractJdbcBaseQuery.$default$fetchType();
        this.fetchSize = b.fetchSize$set ? b.fetchSize$value : AbstractJdbcBaseQuery.$default$fetchSize();
        this.parameters = b.parameters;
        this.additionalVars = b.additionalVars$set ? b.additionalVars$value : AbstractJdbcBaseQuery.$default$additionalVars();
    }

    @Generated
    public String toString() {
        return "AbstractJdbcBaseQuery(super=" + super.toString() + ", url=" + String.valueOf(this.getUrl()) + ", username=" + String.valueOf(this.getUsername()) + ", password=" + String.valueOf(this.getPassword()) + ", timeZoneId=" + String.valueOf(this.getTimeZoneId()) + ", sql=" + String.valueOf(this.getSql()) + ", store=" + this.isStore() + ", fetchOne=" + this.isFetchOne() + ", fetch=" + this.isFetch() + ", fetchType=" + String.valueOf(this.getFetchType()) + ", fetchSize=" + String.valueOf(this.getFetchSize()) + ", parameters=" + String.valueOf(this.getParameters()) + ", additionalVars=" + String.valueOf(this.additionalVars) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractJdbcBaseQuery)) {
            return false;
        }
        AbstractJdbcBaseQuery other = (AbstractJdbcBaseQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isStore() != other.isStore()) {
            return false;
        }
        if (this.isFetchOne() != other.isFetchOne()) {
            return false;
        }
        if (this.isFetch() != other.isFetch()) {
            return false;
        }
        Property<String> this$url = this.getUrl();
        Property<String> other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        Property<String> this$username = this.getUsername();
        Property<String> other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        Property<String> this$password = this.getPassword();
        Property<String> other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        Property<String> this$timeZoneId = this.getTimeZoneId();
        Property<String> other$timeZoneId = other.getTimeZoneId();
        if (this$timeZoneId == null ? other$timeZoneId != null : !this$timeZoneId.equals(other$timeZoneId)) {
            return false;
        }
        Property<String> this$sql = this.getSql();
        Property<String> other$sql = other.getSql();
        if (this$sql == null ? other$sql != null : !this$sql.equals(other$sql)) {
            return false;
        }
        Property<FetchType> this$fetchType = this.getFetchType();
        Property<FetchType> other$fetchType = other.getFetchType();
        if (this$fetchType == null ? other$fetchType != null : !this$fetchType.equals(other$fetchType)) {
            return false;
        }
        Property<Integer> this$fetchSize = this.getFetchSize();
        Property<Integer> other$fetchSize = other.getFetchSize();
        if (this$fetchSize == null ? other$fetchSize != null : !this$fetchSize.equals(other$fetchSize)) {
            return false;
        }
        Property<Map<String, Object>> this$parameters = this.getParameters();
        Property<Map<String, Object>> other$parameters = other.getParameters();
        return !(this$parameters == null ? other$parameters != null : !this$parameters.equals(other$parameters));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractJdbcBaseQuery;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isStore() ? 79 : 97);
        result = result * 59 + (this.isFetchOne() ? 79 : 97);
        result = result * 59 + (this.isFetch() ? 79 : 97);
        Property<String> $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        Property<String> $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        Property<String> $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        Property<String> $timeZoneId = this.getTimeZoneId();
        result = result * 59 + ($timeZoneId == null ? 43 : $timeZoneId.hashCode());
        Property<String> $sql = this.getSql();
        result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
        Property<FetchType> $fetchType = this.getFetchType();
        result = result * 59 + ($fetchType == null ? 43 : $fetchType.hashCode());
        Property<Integer> $fetchSize = this.getFetchSize();
        result = result * 59 + ($fetchSize == null ? 43 : $fetchSize.hashCode());
        Property<Map<String, Object>> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : $parameters.hashCode());
        return result;
    }

    @Override
    @Generated
    public Property<String> getUrl() {
        return this.url;
    }

    @Override
    @Generated
    public Property<String> getUsername() {
        return this.username;
    }

    @Override
    @Generated
    public Property<String> getPassword() {
        return this.password;
    }

    @Override
    @Generated
    public Property<String> getTimeZoneId() {
        return this.timeZoneId;
    }

    @Override
    @Generated
    public Property<String> getSql() {
        return this.sql;
    }

    @Override
    @Deprecated
    @Generated
    public boolean isStore() {
        return this.store;
    }

    @Override
    @Deprecated
    @Generated
    public boolean isFetchOne() {
        return this.fetchOne;
    }

    @Override
    @Deprecated
    @Generated
    public boolean isFetch() {
        return this.fetch;
    }

    @Override
    @Generated
    public Property<FetchType> getFetchType() {
        return this.fetchType;
    }

    @Override
    @Generated
    public Property<Integer> getFetchSize() {
        return this.fetchSize;
    }

    @Override
    @Generated
    public Property<Map<String, Object>> getParameters() {
        return this.parameters;
    }

    @Generated
    public AbstractJdbcBaseQuery() {
        this.store = AbstractJdbcBaseQuery.$default$store();
        this.fetchOne = AbstractJdbcBaseQuery.$default$fetchOne();
        this.fetch = AbstractJdbcBaseQuery.$default$fetch();
        this.fetchType = AbstractJdbcBaseQuery.$default$fetchType();
        this.fetchSize = AbstractJdbcBaseQuery.$default$fetchSize();
        this.additionalVars = AbstractJdbcBaseQuery.$default$additionalVars();
    }

    @Generated
    public static abstract class AbstractJdbcBaseQueryBuilder<C extends AbstractJdbcBaseQuery, B extends AbstractJdbcBaseQueryBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private Property<String> url;
        @Generated
        private Property<String> username;
        @Generated
        private Property<String> password;
        @Generated
        private Property<String> timeZoneId;
        @Generated
        private Property<String> sql;
        @Generated
        private boolean store$set;
        @Generated
        private boolean store$value;
        @Generated
        private boolean fetchOne$set;
        @Generated
        private boolean fetchOne$value;
        @Generated
        private boolean fetch$set;
        @Generated
        private boolean fetch$value;
        @Generated
        private boolean fetchType$set;
        @Generated
        private Property<FetchType> fetchType$value;
        @Generated
        private boolean fetchSize$set;
        @Generated
        private Property<Integer> fetchSize$value;
        @Generated
        private Property<Map<String, Object>> parameters;
        @Generated
        private boolean additionalVars$set;
        @Generated
        private Map<String, Object> additionalVars$value;

        @Generated
        public B url(Property<String> url) {
            this.url = url;
            return (B)this.self();
        }

        @Generated
        public B username(Property<String> username) {
            this.username = username;
            return (B)this.self();
        }

        @Generated
        public B password(Property<String> password) {
            this.password = password;
            return (B)this.self();
        }

        @Generated
        public B timeZoneId(Property<String> timeZoneId) {
            this.timeZoneId = timeZoneId;
            return (B)this.self();
        }

        @Generated
        public B sql(Property<String> sql) {
            this.sql = sql;
            return (B)this.self();
        }

        @Deprecated
        @Generated
        public B store(boolean store) {
            this.store$value = store;
            this.store$set = true;
            return (B)this.self();
        }

        @Deprecated
        @Generated
        public B fetchOne(boolean fetchOne) {
            this.fetchOne$value = fetchOne;
            this.fetchOne$set = true;
            return (B)this.self();
        }

        @Deprecated
        @Generated
        public B fetch(boolean fetch) {
            this.fetch$value = fetch;
            this.fetch$set = true;
            return (B)this.self();
        }

        @Generated
        public B fetchType(Property<FetchType> fetchType) {
            this.fetchType$value = fetchType;
            this.fetchType$set = true;
            return (B)this.self();
        }

        @Generated
        public B fetchSize(Property<Integer> fetchSize) {
            this.fetchSize$value = fetchSize;
            this.fetchSize$set = true;
            return (B)this.self();
        }

        @Generated
        public B parameters(Property<Map<String, Object>> parameters) {
            this.parameters = parameters;
            return (B)this.self();
        }

        @Generated
        public B additionalVars(Map<String, Object> additionalVars) {
            this.additionalVars$value = additionalVars;
            this.additionalVars$set = true;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "AbstractJdbcBaseQuery.AbstractJdbcBaseQueryBuilder(super=" + super.toString() + ", url=" + String.valueOf(this.url) + ", username=" + String.valueOf(this.username) + ", password=" + String.valueOf(this.password) + ", timeZoneId=" + String.valueOf(this.timeZoneId) + ", sql=" + String.valueOf(this.sql) + ", store$value=" + this.store$value + ", fetchOne$value=" + this.fetchOne$value + ", fetch$value=" + this.fetch$value + ", fetchType$value=" + String.valueOf(this.fetchType$value) + ", fetchSize$value=" + String.valueOf(this.fetchSize$value) + ", parameters=" + String.valueOf(this.parameters) + ", additionalVars$value=" + String.valueOf(this.additionalVars$value) + ")";
        }
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="Map containing the first row of fetched data.", description="Only populated if `fetchOne` parameter is set to true.")
        @JsonInclude
        private final Map<String, Object> row;
        @Schema(title="List of map containing rows of fetched data.", description="Only populated if `fetch` parameter is set to true.")
        private final List<Map<String, Object>> rows;
        @Schema(title="The URI of the result file on Kestra's internal storage (.ion file / Amazon Ion formatted text file).", description="Only populated if `store` is set to true.")
        private final URI uri;
        @Schema(title="The number of rows fetched.", description="Only populated if `store` or `fetch` parameter is set to true.")
        private final Long size;

        @Generated
        protected Output(OutputBuilder<?, ?> b) {
            this.row = b.row;
            this.rows = b.rows;
            this.uri = b.uri;
            this.size = b.size;
        }

        @Generated
        public static OutputBuilder<?, ?> builder() {
            return new OutputBuilderImpl();
        }

        @Generated
        public Map<String, Object> getRow() {
            return this.row;
        }

        @Generated
        public List<Map<String, Object>> getRows() {
            return this.rows;
        }

        @Generated
        public URI getUri() {
            return this.uri;
        }

        @Generated
        public Long getSize() {
            return this.size;
        }

        @Generated
        public static abstract class OutputBuilder<C extends Output, B extends OutputBuilder<C, B>> {
            @Generated
            private Map<String, Object> row;
            @Generated
            private List<Map<String, Object>> rows;
            @Generated
            private URI uri;
            @Generated
            private Long size;

            @Generated
            public B row(Map<String, Object> row) {
                this.row = row;
                return this.self();
            }

            @Generated
            public B rows(List<Map<String, Object>> rows) {
                this.rows = rows;
                return this.self();
            }

            @Generated
            public B uri(URI uri) {
                this.uri = uri;
                return this.self();
            }

            @Generated
            public B size(Long size) {
                this.size = size;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "AbstractJdbcBaseQuery.Output.OutputBuilder(row=" + String.valueOf(this.row) + ", rows=" + String.valueOf(this.rows) + ", uri=" + String.valueOf(this.uri) + ", size=" + this.size + ")";
            }
        }

        @Generated
        private static final class OutputBuilderImpl
        extends OutputBuilder<Output, OutputBuilderImpl> {
            @Generated
            private OutputBuilderImpl() {
            }

            @Override
            @Generated
            protected OutputBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public Output build() {
                return new Output(this);
            }
        }
    }
}

