/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.jdbc;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.executions.AbstractMetricEntry;
import io.kestra.core.models.executions.metrics.Counter;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.Output;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.jdbc.AbstractCellConverter;
import io.kestra.plugin.jdbc.AbstractJdbcBaseQuery;
import io.kestra.plugin.jdbc.JdbcQueriesInterface;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;

public abstract class AbstractJdbcQueries
extends AbstractJdbcBaseQuery
implements JdbcQueriesInterface {
    protected Property<Boolean> transaction;

    public MultiQueryOutput run(RunContext runContext) throws Exception {
        Logger logger = runContext.logger();
        AbstractCellConverter cellConverter = this.getCellConverter(this.zoneId(runContext));
        boolean isTransactional = (Boolean)runContext.render(this.transaction).as(Boolean.class).orElseThrow();
        long totalSize = 0L;
        LinkedList<AbstractJdbcBaseQuery.Output> outputList = new LinkedList<AbstractJdbcBaseQuery.Output>();
        Connection connection = null;
        Savepoint savepoint = null;
        try {
            String[] queries;
            connection = this.connection(runContext);
            savepoint = AbstractJdbcQueries.initializeSavepoint(connection);
            connection.setAutoCommit(false);
            String sqlRendered = (String)runContext.render(this.sql).as(String.class, this.additionalVars).orElseThrow();
            for (String query : queries = sqlRendered.split(";[^']")) {
                try (PreparedStatement stmt = this.prepareStatement(runContext, connection, query);){
                    stmt.setFetchSize((Integer)runContext.render(this.getFetchSize()).as(Integer.class).orElseThrow());
                    logger.debug("Starting query: {}", (Object)query);
                    stmt.execute();
                    if (!isTransactional) {
                        connection.commit();
                    }
                    totalSize = this.extractResultsFromResultSet(connection, stmt, runContext, cellConverter, totalSize, outputList);
                }
            }
            connection.commit();
            runContext.metric((AbstractMetricEntry)Counter.of((String)"fetch.size", (Long)totalSize, (String[])this.tags(runContext)));
            Object c = ((MultiQueryOutput.MultiQueryOutputBuilder)MultiQueryOutput.builder().outputs(outputList)).build();
            return c;
        }
        catch (Exception e) {
            AbstractJdbcQueries.rollbackIfTransactional(connection, savepoint, isTransactional);
            throw new RuntimeException(e);
        }
        finally {
            AbstractJdbcQueries.safelyCloseConnection(runContext, connection);
        }
    }

    private static void safelyCloseConnection(RunContext runContext, Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException e) {
            runContext.logger().warn("Issue when closing the connection : {}", (Object)e.getMessage());
        }
    }

    private long extractResultsFromResultSet(Connection connection, PreparedStatement stmt, RunContext runContext, AbstractCellConverter cellConverter, long totalSize, List<AbstractJdbcBaseQuery.Output> outputList) throws SQLException, IOException, IllegalVariableEvaluationException {
        block17: {
            try (ResultSet rs = stmt.getResultSet();){
                if (rs == null) break block17;
                AbstractJdbcBaseQuery.Output.OutputBuilder<?, ?> output = AbstractJdbcBaseQuery.Output.builder();
                long size = 0L;
                switch (this.renderFetchType(runContext)) {
                    case FETCH_ONE: {
                        size = 1L;
                        ((AbstractJdbcBaseQuery.Output.OutputBuilder)output.row(this.fetchResult(rs, cellConverter, connection))).size(size);
                        break;
                    }
                    case STORE: {
                        File tempFile = runContext.workingDir().createTempFile(".ion").toFile();
                        try (BufferedWriter fileWriter = new BufferedWriter(new FileWriter(tempFile), 32768);){
                            size = this.fetchToFile(stmt, rs, fileWriter, cellConverter, connection);
                        }
                        ((AbstractJdbcBaseQuery.Output.OutputBuilder)output.uri(runContext.storage().putFile(tempFile))).size(size);
                        break;
                    }
                    case FETCH: {
                        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();
                        size = this.fetchResults(stmt, rs, maps, cellConverter, connection);
                        ((AbstractJdbcBaseQuery.Output.OutputBuilder)output.rows(maps)).size(size);
                        break;
                    }
                    case NONE: {
                        runContext.logger().info("fetchType is set to NONE, no output will be returned");
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("fetchType must be either FETCH, FETCH_ONE, STORE, or NONE");
                    }
                }
                totalSize += size;
                outputList.add((AbstractJdbcBaseQuery.Output)output.build());
            }
        }
        return totalSize;
    }

    private static void rollbackIfTransactional(Connection connection, Savepoint savepoint, boolean isTransactional) throws SQLException {
        if (isTransactional && connection != null) {
            if (savepoint != null) {
                connection.rollback(savepoint);
                return;
            }
            connection.rollback();
        }
    }

    private static Savepoint initializeSavepoint(Connection conn) {
        try {
            return conn.setSavepoint();
        }
        catch (SQLException e) {
            return null;
        }
    }

    @Override
    protected long fetch(Statement stmt, ResultSet rs, Consumer<Map<String, Object>> c, AbstractCellConverter cellConverter, Connection connection) throws SQLException {
        long count = 0L;
        while (rs.next()) {
            Map<String, Object> map = super.mapResultSetToMap(rs, cellConverter, connection);
            c.accept(map);
            ++count;
        }
        return count;
    }

    @Generated
    private static Property<Boolean> $default$transaction() {
        return Property.of((Object)Boolean.TRUE);
    }

    @Generated
    protected AbstractJdbcQueries(AbstractJdbcQueriesBuilder<?, ?> b) {
        super(b);
        this.transaction = b.transaction$set ? b.transaction$value : AbstractJdbcQueries.$default$transaction();
    }

    @Override
    @Generated
    public String toString() {
        return "AbstractJdbcQueries(super=" + super.toString() + ", transaction=" + String.valueOf(this.getTransaction()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractJdbcQueries)) {
            return false;
        }
        AbstractJdbcQueries other = (AbstractJdbcQueries)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Property<Boolean> this$transaction = this.getTransaction();
        Property<Boolean> other$transaction = other.getTransaction();
        return !(this$transaction == null ? other$transaction != null : !this$transaction.equals(other$transaction));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractJdbcQueries;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Property<Boolean> $transaction = this.getTransaction();
        result = result * 59 + ($transaction == null ? 43 : $transaction.hashCode());
        return result;
    }

    @Override
    @Generated
    public Property<Boolean> getTransaction() {
        return this.transaction;
    }

    @Generated
    public AbstractJdbcQueries() {
        this.transaction = AbstractJdbcQueries.$default$transaction();
    }

    public static class MultiQueryOutput
    implements Output {
        List<AbstractJdbcBaseQuery.Output> outputs;

        @Generated
        protected MultiQueryOutput(MultiQueryOutputBuilder<?, ?> b) {
            this.outputs = b.outputs;
        }

        @Generated
        public static MultiQueryOutputBuilder<?, ?> builder() {
            return new MultiQueryOutputBuilderImpl();
        }

        @Generated
        public List<AbstractJdbcBaseQuery.Output> getOutputs() {
            return this.outputs;
        }

        @Generated
        public static abstract class MultiQueryOutputBuilder<C extends MultiQueryOutput, B extends MultiQueryOutputBuilder<C, B>> {
            @Generated
            private List<AbstractJdbcBaseQuery.Output> outputs;

            @Generated
            public B outputs(List<AbstractJdbcBaseQuery.Output> outputs) {
                this.outputs = outputs;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "AbstractJdbcQueries.MultiQueryOutput.MultiQueryOutputBuilder(outputs=" + String.valueOf(this.outputs) + ")";
            }
        }

        @Generated
        private static final class MultiQueryOutputBuilderImpl
        extends MultiQueryOutputBuilder<MultiQueryOutput, MultiQueryOutputBuilderImpl> {
            @Generated
            private MultiQueryOutputBuilderImpl() {
            }

            @Override
            @Generated
            protected MultiQueryOutputBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public MultiQueryOutput build() {
                return new MultiQueryOutput(this);
            }
        }
    }

    @Generated
    public static abstract class AbstractJdbcQueriesBuilder<C extends AbstractJdbcQueries, B extends AbstractJdbcQueriesBuilder<C, B>>
    extends AbstractJdbcBaseQuery.AbstractJdbcBaseQueryBuilder<C, B> {
        @Generated
        private boolean transaction$set;
        @Generated
        private Property<Boolean> transaction$value;

        @Generated
        public B transaction(Property<Boolean> transaction) {
            this.transaction$value = transaction;
            this.transaction$set = true;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "AbstractJdbcQueries.AbstractJdbcQueriesBuilder(super=" + super.toString() + ", transaction$value=" + String.valueOf(this.transaction$value) + ")";
        }
    }
}

