/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.jdbc.oracle;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.plugin.jdbc.AbstractCellConverter;
import io.kestra.plugin.jdbc.AbstractJdbcBaseQuery;
import io.kestra.plugin.jdbc.AbstractJdbcQuery;
import io.kestra.plugin.jdbc.AutoCommitInterface;
import io.kestra.plugin.jdbc.oracle.OracleCellConverter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.time.ZoneId;
import lombok.Generated;
import oracle.jdbc.OracleDriver;

@Schema(title="Query an Oracle database.")
@Plugin(examples={@Example(full=true, title="Execute a query and fetch results on another task to update another table.", code={"id: oracle_query\nnamespace: company.team\n\ntasks:\n  - id: select\n    type: io.kestra.plugin.jdbc.oracle.Query\n    url: jdbc:oracle:thin:@localhost:49161:XE\n    username: oracle_user\n    password: oracle_password\n    sql: select * from source\n    fetchType: FETCH\n\n  - id: generate_update\n    type: io.kestra.plugin.jdbc.oracle.Query\n    url: jdbc:oracle:thin:@localhost:49161:XE\n    username: oracle_user\n    password: oracle_password\n    sql: \"{% for row in outputs.select.rows %} INSERT INTO destination (year_month, store_code, update_date) values ({{ row.year_month }}, {{ row.store_code }}, TO_DATE('{{ row.date }}', 'MONTH DD, YYYY') ); {% endfor %}\"\n"})})
public class Query
extends AbstractJdbcQuery
implements RunnableTask<AbstractJdbcBaseQuery.Output>,
AutoCommitInterface {
    protected final Property<Boolean> autoCommit = Property.of((Object)true);

    @Override
    protected AbstractCellConverter getCellConverter(ZoneId zoneId) {
        return new OracleCellConverter(zoneId);
    }

    @Override
    public void registerDriver() throws SQLException {
        DriverManager.registerDriver(new OracleDriver());
    }

    @Generated
    protected Query(QueryBuilder<?, ?> b) {
        super((AbstractJdbcQuery.AbstractJdbcQueryBuilder<?, ?>)b);
    }

    @Generated
    public static QueryBuilder<?, ?> builder() {
        return new QueryBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "Query(super=" + super.toString() + ", autoCommit=" + String.valueOf(this.getAutoCommit()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Query)) {
            return false;
        }
        Query other = (Query)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Property<Boolean> this$autoCommit = this.getAutoCommit();
        Property<Boolean> other$autoCommit = other.getAutoCommit();
        return !(this$autoCommit == null ? other$autoCommit != null : !this$autoCommit.equals(other$autoCommit));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Query;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Property<Boolean> $autoCommit = this.getAutoCommit();
        result = result * 59 + ($autoCommit == null ? 43 : $autoCommit.hashCode());
        return result;
    }

    @Override
    @Generated
    public Property<Boolean> getAutoCommit() {
        return this.autoCommit;
    }

    @Generated
    public Query() {
    }

    @Generated
    private static final class QueryBuilderImpl
    extends QueryBuilder<Query, QueryBuilderImpl> {
        @Generated
        private QueryBuilderImpl() {
        }

        @Override
        @Generated
        protected QueryBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Query build() {
            return new Query(this);
        }
    }

    @Generated
    public static abstract class QueryBuilder<C extends Query, B extends QueryBuilder<C, B>>
    extends AbstractJdbcQuery.AbstractJdbcQueryBuilder<C, B> {
        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Query.QueryBuilder(super=" + super.toString() + ")";
        }
    }
}

