/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.jdbc;

import com.google.common.collect.ImmutableList;
import io.kestra.plugin.jdbc.AbstractJdbcBatch;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;

public abstract class AbstractCellConverter {
    protected ZoneId zoneId;
    private static final List<Class<?>> SIMPLE_TYPES = ImmutableList.of(String.class, Boolean.class, Integer.class, Short.class, Long.class, Float.class, Double.class, BigDecimal.class, byte[].class);

    public AbstractCellConverter(ZoneId zoneId) {
        this.zoneId = zoneId;
    }

    public abstract Object convertCell(int var1, ResultSet var2, Connection var3) throws SQLException;

    protected Object convert(int columnIndex, ResultSet rs) throws SQLException {
        Object data = rs.getObject(columnIndex);
        if (data == null) {
            return null;
        }
        Class<?> clazz = data.getClass();
        if (SIMPLE_TYPES.contains(clazz)) {
            return data;
        }
        if (clazz.equals(BigInteger.class)) {
            return data.toString();
        }
        if (clazz.equals(BigDecimal.class)) {
            return data.toString();
        }
        if (clazz.equals(Date.class)) {
            return ((Date)data).toLocalDate();
        }
        if (clazz.equals(Time.class)) {
            return ((Time)data).toLocalTime();
        }
        if (clazz.equals(Timestamp.class)) {
            return ((Timestamp)data).toInstant().atZone(this.zoneId);
        }
        if (clazz.equals(UUID.class)) {
            return data.toString();
        }
        String columnName = rs.getMetaData().getColumnName(columnIndex);
        throw new IllegalArgumentException("Data of type '" + clazz + "' for column '" + columnName + "' is not supported");
    }

    protected PreparedStatement addPreparedStatementValue(PreparedStatement ps, AbstractJdbcBatch.ParameterType parameterType, Object value, int index, Connection connection) throws Exception {
        Class<?> cls = parameterType.getClass(index);
        try {
            if (value == null) {
                ps.setNull(index, parameterType.getType(index));
                return ps;
            }
            if (cls == Integer.class) {
                ps.setInt(index, (Integer)value);
                return ps;
            }
            if (cls == Short.class) {
                ps.setShort(index, Short.parseShort(value.toString()));
                return ps;
            }
            if (cls == String.class) {
                ps.setString(index, (String)value);
                return ps;
            }
            if (cls == UUID.class) {
                ps.setObject(index, value);
                return ps;
            }
            if (cls == Long.class) {
                if (value instanceof Integer) {
                    ps.setLong(index, ((Integer)value).longValue());
                    return ps;
                }
                ps.setLong(index, (Long)value);
                return ps;
            }
            if (cls == BigInteger.class) {
                ps.setLong(index, ((BigInteger)value).longValue());
                return ps;
            }
            if (cls == Double.class) {
                ps.setDouble(index, (Double)value);
                return ps;
            }
            if (cls == Float.class) {
                if (value instanceof Double) {
                    ps.setFloat(index, ((Double)value).floatValue());
                    return ps;
                }
                ps.setFloat(index, ((Float)value).floatValue());
                return ps;
            }
            if (cls == BigDecimal.class) {
                if (value instanceof Integer) {
                    ps.setBigDecimal(index, new BigDecimal((Integer)value));
                    return ps;
                }
                ps.setBigDecimal(index, (BigDecimal)value);
                return ps;
            }
            if (cls == Date.class) {
                if (value instanceof LocalDate) {
                    ps.setDate(index, Date.valueOf((LocalDate)value));
                    return ps;
                }
                if (value instanceof LocalDateTime) {
                    ps.setDate(index, Date.valueOf(((LocalDateTime)value).toLocalDate()));
                    return ps;
                }
            } else if (cls == Time.class) {
                if (value instanceof LocalTime) {
                    ps.setTime(index, Time.valueOf((LocalTime)value));
                    return ps;
                }
                if (value instanceof OffsetTime) {
                    OffsetTime current = (OffsetTime)value;
                    ps.setTime(index, Time.valueOf(current.toLocalTime()), Calendar.getInstance(TimeZone.getTimeZone(current.getOffset())));
                    return ps;
                }
                if (value instanceof Instant) {
                    Instant current = (Instant)value;
                    ps.setTime(index, Time.valueOf(LocalTime.from(current.atZone(this.zoneId))));
                    return ps;
                }
            } else if (cls == Timestamp.class) {
                if (value instanceof LocalDateTime) {
                    ps.setTimestamp(index, Timestamp.valueOf((LocalDateTime)value));
                    return ps;
                }
                if (value instanceof ZonedDateTime) {
                    ZonedDateTime current = (ZonedDateTime)value;
                    ps.setTimestamp(index, Timestamp.valueOf(current.toLocalDateTime()), Calendar.getInstance(TimeZone.getTimeZone(current.getZone())));
                    return ps;
                }
                if (value instanceof OffsetDateTime) {
                    OffsetDateTime current = (OffsetDateTime)value;
                    ps.setTimestamp(index, Timestamp.valueOf(current.toLocalDateTime()), Calendar.getInstance(TimeZone.getTimeZone(current.toZonedDateTime().getZone())));
                    return ps;
                }
                if (value instanceof Instant) {
                    ps.setTimestamp(index, Timestamp.valueOf(LocalDateTime.ofInstant((Instant)value, ZoneOffset.UTC)));
                    return ps;
                }
                if (value instanceof LocalDate) {
                    ps.setTimestamp(index, Timestamp.valueOf(((LocalDate)value).atStartOfDay()));
                    return ps;
                }
            } else {
                if (cls == Boolean.class) {
                    ps.setBoolean(index, (Boolean)value);
                    return ps;
                }
                if (cls.getName().equals("[B")) {
                    ps.setBytes(index, (byte[])value);
                    return ps;
                }
                if (cls == Array.class) {
                    Collection collection = (Collection)value;
                    ps.setArray(index, connection.createArrayOf(parameterType.getTypeName(index).substring(1), collection.toArray()));
                    return ps;
                }
                if (Blob.class.isAssignableFrom(cls)) {
                    if (value.getClass().getName().equals("[B")) {
                        Blob blob = connection.createBlob();
                        blob.setBytes(1L, (byte[])value);
                        ps.setBlob(index, blob);
                        return ps;
                    }
                } else if (Clob.class.isAssignableFrom(cls)) {
                    if (value instanceof String) {
                        Clob blob = connection.createClob();
                        blob.setString(1L, (String)value);
                        ps.setClob(index, blob);
                        return ps;
                    }
                } else if (NClob.class.isAssignableFrom(cls) && value instanceof String) {
                    NClob blob = connection.createNClob();
                    blob.setString(1L, (String)value);
                    ps.setClob(index, blob);
                    return ps;
                }
            }
        }
        catch (Exception e2) {
            throw this.addPreparedStatementException(parameterType, index, value, e2);
        }
        throw this.addPreparedStatementException(parameterType, index, value, null);
    }

    protected Duration parseDuration(Object value) {
        if (value instanceof Duration) {
            return (Duration)value;
        }
        if (value instanceof String) {
            try {
                return Duration.parse((String)value);
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        } else if (value instanceof BigDecimal) {
            BigDecimal current = (BigDecimal)value;
            return Duration.ofSeconds(current.longValue(), current.subtract(new BigDecimal(current.longValue())).multiply(new BigDecimal(1000000000L)).intValue());
        }
        return null;
    }

    protected Exception addPreparedStatementException(AbstractJdbcBatch.ParameterType parameterType, int index, Object value, Throwable e2) {
        return new Exception("Unable to transform data with type '" + parameterType.getTypeName(index) + "', class '" + parameterType.getClass(index) + "', index '" + index + "', value '" + (value != null ? value.toString() : "null") + "', valueClass '" + (Serializable)(value != null ? value.getClass() : "null") + "'", e2);
    }
}

