/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.jdbc;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.validation.constraints.NotNull;
import lombok.Generated;

public abstract class AbstractJdbcConnection
extends Task {
    @Schema(title="The jdbc url to connect to the database")
    @PluginProperty(dynamic=true)
    @NotNull
    protected String url;
    @Schema(title="The database user")
    @PluginProperty(dynamic=true)
    protected String username;
    @Schema(title="The database user's password")
    @PluginProperty(dynamic=true)
    protected String password;

    protected abstract void registerDriver() throws SQLException;

    protected Properties connectionProperties(RunContext runContext) throws IllegalVariableEvaluationException, IOException {
        Properties props = new Properties();
        props.put("jdbc.url", runContext.render(this.url));
        if (this.username != null) {
            props.put("user", runContext.render(this.username));
        }
        if (this.password != null) {
            props.put("password", runContext.render(this.password));
        }
        return props;
    }

    protected Connection connection(RunContext runContext) throws IllegalVariableEvaluationException, SQLException, IOException {
        this.registerDriver();
        Properties props = this.connectionProperties(runContext);
        String jdbcUrl = props.getProperty("jdbc.url");
        props.remove("jdbc.url");
        return DriverManager.getConnection(jdbcUrl, props);
    }

    @Generated
    protected AbstractJdbcConnection(AbstractJdbcConnectionBuilder<?, ?> b2) {
        super(b2);
        this.url = b2.url;
        this.username = b2.username;
        this.password = b2.password;
    }

    @Generated
    public String toString() {
        return "AbstractJdbcConnection(super=" + super.toString() + ", url=" + this.getUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ")";
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof AbstractJdbcConnection)) {
            return false;
        }
        AbstractJdbcConnection other = (AbstractJdbcConnection)((Object)o2);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractJdbcConnection;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    @NotNull
    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public AbstractJdbcConnection() {
    }

    @Generated
    public static abstract class AbstractJdbcConnectionBuilder<C extends AbstractJdbcConnection, B extends AbstractJdbcConnectionBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private String url;
        @Generated
        private String username;
        @Generated
        private String password;

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public B url(@NotNull String url) {
            this.url = url;
            return (B)this.self();
        }

        @Generated
        public B username(String username) {
            this.username = username;
            return (B)this.self();
        }

        @Generated
        public B password(String password) {
            this.password = password;
            return (B)this.self();
        }

        @Generated
        public String toString() {
            return "AbstractJdbcConnection.AbstractJdbcConnectionBuilder(super=" + super.toString() + ", url=" + this.url + ", username=" + this.username + ", password=" + this.password + ")";
        }
    }
}

