/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.jdbc.oracle;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.plugin.jdbc.AbstractCellConverter;
import io.kestra.plugin.jdbc.AbstractJdbcBatch;
import io.kestra.plugin.jdbc.oracle.OracleCellConverter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.time.ZoneId;
import lombok.Generated;
import oracle.jdbc.OracleDriver;

@Schema(title="Execute a batch query to a Oracle server")
@Plugin(examples={@Example(title="Fetch rows from a table and bulk insert to another one", full=true, code={"tasks:", "  - id: query", "    type: io.kestra.plugin.jdbc.oracle.Query", "    url: jdbc:oracle:thin:@dev:49161:XE", "    username: oracle", "    password: oracle_passwd", "    sql: |", "      SELECT *", "      FROM xref", "      LIMIT 1500;", "    store: true", "  - id: update", "    type: io.kestra.plugin.jdbc.oracle.Batch", "    from: \"{{ outputs.query.uri }}\"", "    url: jdbc:oracle:thin:@prod:49161:XE", "    username: oracle", "    password: oracle_passwd", "    sql: |", "      insert into xref values( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )"})})
public class Batch
extends AbstractJdbcBatch
implements RunnableTask<AbstractJdbcBatch.Output> {
    @Override
    protected AbstractCellConverter getCellConverter(ZoneId zoneId) {
        return new OracleCellConverter(zoneId);
    }

    @Override
    protected void registerDriver() throws SQLException {
        DriverManager.registerDriver(new OracleDriver());
    }

    @Generated
    protected Batch(BatchBuilder<?, ?> b2) {
        super((AbstractJdbcBatch.AbstractJdbcBatchBuilder<?, ?>)b2);
    }

    @Generated
    public static BatchBuilder<?, ?> builder() {
        return new BatchBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "Batch(super=" + super.toString() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof Batch)) {
            return false;
        }
        Batch other = (Batch)((Object)o2);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o2);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Batch;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Generated
    public Batch() {
    }

    @Generated
    private static final class BatchBuilderImpl
    extends BatchBuilder<Batch, BatchBuilderImpl> {
        @Generated
        private BatchBuilderImpl() {
        }

        @Override
        @Generated
        protected BatchBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Batch build() {
            return new Batch(this);
        }
    }

    @Generated
    public static abstract class BatchBuilder<C extends Batch, B extends BatchBuilder<C, B>>
    extends AbstractJdbcBatch.AbstractJdbcBatchBuilder<C, B> {
        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Batch.BatchBuilder(super=" + super.toString() + ")";
        }
    }
}

