/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.jdbc.oracle;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.jdbc.AbstractCellConverter;
import io.kestra.plugin.jdbc.AbstractJdbcQuery;
import io.kestra.plugin.jdbc.AutoCommitInterface;
import io.kestra.plugin.jdbc.oracle.OracleCellConverter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.time.ZoneId;
import lombok.Generated;
import oracle.jdbc.OracleDriver;

@Schema(title="Query a Oracle server")
@Plugin(examples={@Example(full=true, title="Execute a query and fetch results on another task to update another table", code={"tasks:", "- id: select", "  type: io.kestra.plugin.jdbc.oracle.Query", "  url: jdbc:oracle:thin:@localhost:49161:XE", "  username: oracle", "  password: oracle_passwd", "  sql: select * from source", "  fetch: true", "- id: generate-update", "  type: io.kestra.plugin.jdbc.oracle.Query", "  url: jdbc:oracle:thin:@localhost:49161:XE", "  username: oracle", "  password: oracle_passwd", "  sql:  \"{% for row in outputs.update.rows %} INSERT INTO destination (year_month, store_code, update_date) values ({{row.year_month}}, {{row.store_code}}, TO_DATE('{{row.date}}', 'MONTH DD, YYYY') ); {% endfor %}\""})})
public class Query
extends AbstractJdbcQuery
implements RunnableTask<AbstractJdbcQuery.Output>,
AutoCommitInterface {
    protected final Boolean autoCommit = true;

    @Override
    protected AbstractCellConverter getCellConverter(ZoneId zoneId) {
        return new OracleCellConverter(zoneId);
    }

    @Override
    protected void registerDriver() throws SQLException {
        DriverManager.registerDriver(new OracleDriver());
    }

    @Override
    public AbstractJdbcQuery.Output run(RunContext runContext) throws Exception {
        return super.run(runContext);
    }

    @Generated
    protected Query(QueryBuilder<?, ?> b2) {
        super((AbstractJdbcQuery.AbstractJdbcQueryBuilder<?, ?>)b2);
    }

    @Generated
    public static QueryBuilder<?, ?> builder() {
        return new QueryBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "Query(super=" + super.toString() + ", autoCommit=" + this.getAutoCommit() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof Query)) {
            return false;
        }
        Query other = (Query)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        Boolean this$autoCommit = this.getAutoCommit();
        Boolean other$autoCommit = other.getAutoCommit();
        return !(this$autoCommit == null ? other$autoCommit != null : !((Object)this$autoCommit).equals(other$autoCommit));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Query;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $autoCommit = this.getAutoCommit();
        result = result * 59 + ($autoCommit == null ? 43 : ((Object)$autoCommit).hashCode());
        return result;
    }

    @Override
    @Generated
    public Boolean getAutoCommit() {
        return this.autoCommit;
    }

    @Generated
    public Query() {
    }

    @Generated
    private static final class QueryBuilderImpl
    extends QueryBuilder<Query, QueryBuilderImpl> {
        @Generated
        private QueryBuilderImpl() {
        }

        @Override
        @Generated
        protected QueryBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Query build() {
            return new Query(this);
        }
    }

    @Generated
    public static abstract class QueryBuilder<C extends Query, B extends QueryBuilder<C, B>>
    extends AbstractJdbcQuery.AbstractJdbcQueryBuilder<C, B> {
        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Query.QueryBuilder(super=" + super.toString() + ")";
        }
    }
}

