/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.text.DateFormatSymbols;
import java.util.TimeZone;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.AccessorPrototype;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DynamicByteArray;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTimestampltzAccessor;
import oracle.jdbc.driver.TimestamptzAccessor;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CTimestamptzAccessor
extends TimestamptzAccessor {
    T4CMAREngine mare;
    boolean underlyingLongRaw = false;

    T4CTimestamptzAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, n2, s2, n3, bl);
        this.mare = t4CMAREngine;
    }

    T4CTimestamptzAccessor(OracleStatement oracleStatement, int n2, boolean bl, int n3, int n4, int n5, long l2, int n6, short s2, int n7, int n8, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, n2 == -1 ? n8 : n2, bl, n3, n4, n5, l2, n6, s2);
        this.mare = t4CMAREngine;
        if (oracleStatement != null && oracleStatement.implicitDefineForLobPrefetchDone) {
            this.definedColumnType = 0;
            this.definedColumnSize = 0;
        } else {
            this.definedColumnType = n7;
            this.definedColumnSize = n8;
        }
        if (n2 == -1) {
            this.underlyingLongRaw = true;
        }
    }

    public T4CMAREngine getMAREngine() {
        return this.mare;
    }

    public void unmarshalColumnMetadata() throws SQLException, IOException {
        if (this.statement.statementType != 2 && !this.statement.sqlKind.isPlsqlOrCall() && this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED) {
            this.setRowMetadata(this.lastRowProcessed, (byte)this.mare.unmarshalUB1());
        }
    }

    public void processIndicator(int n2) throws IOException, SQLException {
        if (this.internalType == 1 && this.describeType == 112 || this.internalType == 23 && this.describeType == 113) {
            this.mare.unmarshalSB2();
            this.mare.unmarshalUB2();
        } else if (this.statement.connection.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (!this.statement.sqlKind.isPlsqlOrCall()) {
                this.mare.unmarshalSB2();
            }
        } else if (this.statement.sqlKind.isPlsqlOrCall() || this.isDMLReturnedParam) {
            this.mare.processIndicator(n2 <= 0, n2);
        }
    }

    @Override
    int getPreviousRowProcessed() {
        if (this.previousRowProcessed == -1) {
            this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
        }
        return this.previousRowProcessed;
    }

    @Override
    void reinitForResultSetCache(ByteArray byteArray, OracleStatement oracleStatement) throws SQLException {
        this.rowData = byteArray;
        this.mare = ((T4CConnection)oracleStatement.connection).mare;
        this.rowNull = null;
        this.setCapacity(oracleStatement.getFetchSize());
    }

    @Override
    boolean unmarshalOneRow() throws SQLException, IOException {
        boolean bl = false;
        if (!this.isUseless()) {
            if (this.isUnexpected()) {
                long l2 = this.rowData.getPosition();
                this.unmarshalColumnMetadata();
                this.unmarshalBytes();
                this.rowData.setPosition(l2);
                this.setNull(this.lastRowProcessed, true);
            } else if (this.isNullByDescribe()) {
                this.setNull(this.lastRowProcessed, true);
                this.unmarshalColumnMetadata();
                if (this.statement.connection.versionNumber < 9200) {
                    this.processIndicator(0);
                }
            } else {
                this.unmarshalColumnMetadata();
                bl = this.unmarshalBytes();
            }
        }
        this.previousRowProcessed = this.lastRowProcessed++;
        return bl;
    }

    boolean unmarshalBytes() throws SQLException, IOException {
        this.setOffset(this.lastRowProcessed);
        int n2 = this.statement.maxFieldSize > 0 ? ((DynamicByteArray)this.rowData).unmarshalCLR(this.mare, this.statement.maxFieldSize) : ((DynamicByteArray)this.rowData).unmarshalCLR(this.mare);
        this.processIndicator(n2);
        this.setLength(this.lastRowProcessed, n2);
        this.setNull(this.lastRowProcessed, n2 == 0);
        return false;
    }

    @Override
    void copyRow() throws SQLException, IOException {
        if (this.isNullByDescribe || this.previousRowProcessed == -1) {
            this.setNull(this.lastRowProcessed, true);
            this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
        } else if (this.lastRowProcessed == 0) {
            if (this.previousRowProcessed == -1) {
                this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
            }
            long l2 = this.getOffset(this.previousRowProcessed);
            this.setNull(this.lastRowProcessed, this.isNull(this.previousRowProcessed));
            this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
            if (!this.isNull(this.previousRowProcessed)) {
                this.setOffset(this.lastRowProcessed);
                ((DynamicByteArray)this.rowData).copyLeft(l2, this.getLength(this.previousRowProcessed));
                this.setLength(this.lastRowProcessed, this.getLength(this.previousRowProcessed));
            }
        } else if (this.lastCopyRow == this.previousRowProcessed) {
            this.setNull(this.lastRowProcessed, this.lastCopyRowIsNull);
            this.rowMetadata[this.lastRowProcessed] = this.lastCopyRowMetaData;
            this.setOffset(this.lastRowProcessed, this.lastCopyRowOffset);
            this.setLength(this.lastRowProcessed, this.lastCopyRowLength);
        } else {
            this.setNull(this.lastRowProcessed, this.isNull(this.previousRowProcessed));
            this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
            this.setOffset(this.lastRowProcessed, this.getOffset(this.previousRowProcessed));
            this.setLength(this.lastRowProcessed, this.getLength(this.previousRowProcessed));
        }
        this.previousRowProcessed = this.lastRowProcessed++;
    }

    @Override
    String toText(int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, String string) throws SQLException {
        if (this.definedColumnType == 0 || this.definedColumnType == -101) {
            return super.toText(n2, n3, n4, n5, n6, n7, n8, bl, string);
        }
        String string2 = (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTZNFM");
        return T4CTimestamptzAccessor.nlsFormatToText(n2, n3, n4, n5, n6, n7, n8, bl, string, string2);
    }

    private static final String nlsFormatToText(int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, String string, String string2) throws SQLException {
        char[] cArray = (string2 + "      ").toCharArray();
        int n9 = string2.length();
        StringBuffer stringBuffer = new StringBuffer(n9 + 25);
        String[] stringArray = null;
        String[] stringArray2 = null;
        TimeZone timeZone = null;
        int n10 = n2 < 0 ? Math.abs(n2) + 1 : n2;
        boolean bl2 = false;
        block13: for (int i2 = 0; i2 < n9; ++i2) {
            switch (cArray[i2]) {
                case 'R': 
                case 'r': {
                    if (cArray[i2 + 1] != 'R' && cArray[i2 + 1] != 'r') continue block13;
                    if (!(cArray[i2 + 2] != 'R' && cArray[i2 + 2] != 'r' || cArray[i2 + 3] != 'R' && cArray[i2 + 3] != 'r')) {
                        if (n10 < 1000) {
                            stringBuffer.append("0" + n10);
                        } else if (n10 < 100) {
                            stringBuffer.append("00" + n10);
                        } else if (n10 < 10) {
                            stringBuffer.append("000" + n10);
                        } else {
                            stringBuffer.append(n10);
                        }
                        i2 += 3;
                        continue block13;
                    }
                    if (n10 >= 100) {
                        n10 %= 100;
                    }
                    if (n10 < 10) {
                        stringBuffer.append("0" + n10);
                    } else {
                        stringBuffer.append(n10);
                    }
                    ++i2;
                    continue block13;
                }
                case 'Y': 
                case 'y': {
                    if (cArray[i2 + 1] != 'Y' && cArray[i2 + 1] != 'y') continue block13;
                    if (!(cArray[i2 + 2] != 'Y' && cArray[i2 + 2] != 'y' || cArray[i2 + 3] != 'Y' && cArray[i2 + 3] != 'y')) {
                        int n11;
                        int n12 = n11 = n2 < 0 && bl2 ? Math.abs(n2) : n10;
                        if (n11 < 1000) {
                            stringBuffer.append("0" + n11);
                        } else if (n11 < 100) {
                            stringBuffer.append("00" + n11);
                        } else if (n11 < 10) {
                            stringBuffer.append("000" + n11);
                        } else {
                            stringBuffer.append(n11);
                        }
                        i2 += 3;
                        continue block13;
                    }
                    if (n10 >= 100) {
                        n10 %= 100;
                    }
                    if (n10 < 10) {
                        stringBuffer.append("0" + n10);
                    } else {
                        stringBuffer.append(n10);
                    }
                    ++i2;
                    continue block13;
                }
                case 'D': 
                case 'd': {
                    if (cArray[i2 + 1] != 'D' && cArray[i2 + 1] != 'd') continue block13;
                    stringBuffer.append((n4 < 10 ? "0" : "") + n4);
                    ++i2;
                    continue block13;
                }
                case 'M': 
                case 'm': {
                    if (cArray[i2 + 1] == 'M' || cArray[i2 + 1] == 'm') {
                        stringBuffer.append((n3 < 10 ? "0" : "") + n3);
                        ++i2;
                        continue block13;
                    }
                    if (cArray[i2 + 1] == 'I' || cArray[i2 + 1] == 'i') {
                        stringBuffer.append((n6 < 10 ? "0" : "") + n6);
                        ++i2;
                        continue block13;
                    }
                    if (cArray[i2 + 1] != 'O' && cArray[i2 + 1] != 'o' || cArray[i2 + 2] != 'N' && cArray[i2 + 2] != 'n') continue block13;
                    if (!(cArray[i2 + 3] != 'T' && cArray[i2 + 3] != 't' || cArray[i2 + 4] != 'H' && cArray[i2 + 4] != 'h')) {
                        if (stringArray2 == null) {
                            stringArray2 = new DateFormatSymbols().getMonths();
                        }
                        if (cArray[i2] == 'm') {
                            stringBuffer.append(stringArray2[n3 - 1].toLowerCase());
                        } else if (cArray[i2 + 1] == 'O') {
                            stringBuffer.append(stringArray2[n3 - 1].toUpperCase());
                        } else {
                            stringBuffer.append(stringArray2[n3 - 1]);
                        }
                        i2 += 4;
                        continue block13;
                    }
                    if (stringArray == null) {
                        stringArray = new DateFormatSymbols().getShortMonths();
                    }
                    if (cArray[i2] == 'm') {
                        stringBuffer.append(stringArray[n3 - 1].toLowerCase());
                    } else if (cArray[i2 + 1] == 'O') {
                        stringBuffer.append(stringArray[n3 - 1].toUpperCase());
                    } else {
                        stringBuffer.append(stringArray[n3 - 1]);
                    }
                    i2 += 2;
                    continue block13;
                }
                case 'H': 
                case 'h': {
                    if (cArray[i2 + 1] != 'H' && cArray[i2 + 1] != 'h') continue block13;
                    if (cArray[i2 + 2] == '2' || cArray[i2 + 3] == '4') {
                        stringBuffer.append((n5 < 10 ? "0" : "") + n5);
                        i2 += 3;
                        continue block13;
                    }
                    if (n5 > 12) {
                        n5 -= 12;
                    }
                    stringBuffer.append((n5 < 10 ? "0" : "") + n5);
                    ++i2;
                    continue block13;
                }
                case 'S': 
                case 's': {
                    if (cArray[i2 + 1] == 'S' || cArray[i2 + 1] == 's') {
                        stringBuffer.append((n7 < 10 ? "0" : "") + n7);
                        if (cArray[++i2 + 1] != 'X' && cArray[i2 + 1] != 'x' || cArray[i2 + 2] != 'F' && cArray[i2 + 2] != 'f' || cArray[i2 + 3] != 'F' && cArray[i2 + 3] != 'f') continue block13;
                        stringBuffer.append(".");
                        ++i2;
                        continue block13;
                    }
                    if (cArray[i2 + 1] != 'Y' && cArray[i2 + 1] != 'y' || cArray[i2 + 2] != 'Y' && cArray[i2 + 2] != 'y' || cArray[i2 + 3] != 'Y' && cArray[i2 + 3] != 'y' || n2 >= 0) continue block13;
                    stringBuffer.append("-");
                    bl2 = true;
                    continue block13;
                }
                case 'F': 
                case 'f': {
                    if (cArray[i2 + 1] != 'F' && cArray[i2 + 1] != 'f') continue block13;
                    if (n8 >= 0) {
                        stringBuffer.append(n8);
                    } else {
                        stringBuffer.append(0);
                    }
                    ++i2;
                    continue block13;
                }
                case 'T': 
                case 't': {
                    long l2;
                    if (cArray[i2 + 1] != 'Z' && cArray[i2 + 1] != 'z') continue block13;
                    if (cArray[i2 + 2] == 'R' || cArray[i2 + 2] == 'r') {
                        if (string.length() > 3 && string.startsWith("GMT")) {
                            stringBuffer.append(string.substring(3));
                        } else {
                            stringBuffer.append(string.toUpperCase());
                        }
                        i2 += 2;
                        continue block13;
                    }
                    if (cArray[i2 + 2] == 'H' || cArray[i2 + 2] == 'h') {
                        if (timeZone == null) {
                            timeZone = TimeZone.getTimeZone(string);
                        }
                        long l3 = timeZone.getRawOffset() / 3600000;
                        stringBuffer.append(l3);
                        i2 += 2;
                        continue block13;
                    }
                    if (cArray[i2 + 2] != 'M' && cArray[i2 + 2] != 'm') continue block13;
                    if (timeZone == null) {
                        timeZone = TimeZone.getTimeZone(string);
                    }
                    stringBuffer.append(((l2 = (long)(Math.abs(timeZone.getRawOffset()) % 3600000 / 60000)) < 10L ? "0" : "") + l2);
                    i2 += 2;
                    continue block13;
                }
                case 'A': 
                case 'a': {
                    if (cArray[i2 + 1] == 'M' || cArray[i2 + 1] == 'm') {
                        stringBuffer.append(bl ? "AM" : "PM");
                        ++i2;
                        continue block13;
                    }
                    if (cArray[i2 + 1] != 'D' && cArray[i2 + 1] != 'd') continue block13;
                    stringBuffer.append(n2 < 0 ? "BC" : "AD");
                    ++i2;
                    continue block13;
                }
                case 'B': 
                case 'b': {
                    if (cArray[i2 + 1] != 'C' && cArray[i2 + 1] != 'c') continue block13;
                    stringBuffer.append(n2 < 0 ? "BC" : "AD");
                    ++i2;
                    continue block13;
                }
                case 'P': 
                case 'p': {
                    if (cArray[i2 + 1] != 'M' && cArray[i2 + 1] != 'm') continue block13;
                    stringBuffer.append(bl ? "AM" : "PM");
                    ++i2;
                    continue block13;
                }
                default: {
                    stringBuffer.append(cArray[i2]);
                }
            }
        }
        return stringBuffer.substring(0, stringBuffer.length());
    }

    @Override
    Object getObject(int n2) throws SQLException {
        if (this.definedColumnType == 0) {
            return super.getObject(n2);
        }
        if (this.isUnexpected()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21).fillInStackTrace();
        }
        if (this.isNull(n2)) {
            return null;
        }
        switch (this.definedColumnType) {
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return this.getString(n2);
            }
            case 93: {
                return this.getTimestamp(n2);
            }
            case -101: {
                return this.getTIMESTAMPTZ(n2);
            }
            case 91: {
                return this.getDate(n2);
            }
            case 92: {
                return this.getTime(n2);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytes(n2);
            }
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
    }

    @Override
    AccessorPrototype newPrototype(int n2) {
        assert (n2 >= 0) : "numRows: " + n2;
        AccessorPrototype accessorPrototype = new AccessorPrototype(n2, this, this.statement.rowData){

            @Override
            Accessor newAccessor(OracleStatement oracleStatement) throws SQLException {
                T4CTimestampltzAccessor t4CTimestampltzAccessor = new T4CTimestampltzAccessor(oracleStatement, T4CTimestamptzAccessor.this.describeMaxLength, T4CTimestamptzAccessor.this.nullable, -1, T4CTimestamptzAccessor.this.precision, T4CTimestamptzAccessor.this.scale, T4CTimestamptzAccessor.this.contflag, -1, T4CTimestamptzAccessor.this.formOfUse, T4CTimestamptzAccessor.this.definedColumnType, T4CTimestamptzAccessor.this.definedColumnSize, null);
                this.initializeRowData(t4CTimestampltzAccessor);
                return t4CTimestampltzAccessor;
            }
        };
        return accessorPrototype;
    }
}

