/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.PooledConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIOtxen;
import oracle.jdbc.driver.T4CTTIOtxse;
import oracle.jdbc.driver.T4CTTIk2rpc;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.proxy._Proxy_;
import oracle.jdbc.replay.ReplayableConnection;
import oracle.jdbc.xa.OracleXAConnection;
import oracle.jdbc.xa.OracleXAException;
import oracle.jdbc.xa.OracleXid;
import oracle.jdbc.xa.client.OracleXADataSource;
import oracle.jdbc.xa.client.OracleXAResource;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CXAResource
extends OracleXAResource {
    int[] applicationValueArr = new int[1];
    boolean isTransLoose = false;
    byte[] context;
    int errorNumber;
    private OpaqueString password = null;

    T4CXAResource(OracleConnection oracleConnection, OracleXAConnection oracleXAConnection, boolean bl) throws XAException {
        super(oracleConnection, oracleXAConnection);
        this.isTransLoose = bl;
    }

    @Override
    protected int doStart(Xid xid, int n2) throws XAException, SQLException {
        T4CConnection t4CConnection = this.connection instanceof ReplayableConnection ? (T4CConnection)((_Proxy_)((Object)this.connection))._getDelegate_() : (T4CConnection)this.connection;
        try (Monitor.CloseableLock closeableLock = t4CConnection.acquireCloseableLock();){
            int n3;
            int n4 = -1;
            if (this.isTransLoose) {
                n2 |= 0x10000;
            }
            if ((n3 = n2 & 0x8200000) == 0x8000000 && OracleXid.isLocalTransaction(xid)) {
                int n5 = 0;
                return n5;
            }
            this.applicationValueArr[0] = 0;
            try {
                try {
                    T4CTTIOtxse t4CTTIOtxse = t4CConnection.otxse;
                    byte[] byArray = null;
                    byte[] byArray2 = xid.getGlobalTransactionId();
                    byte[] byArray3 = xid.getBranchQualifier();
                    int n6 = 0;
                    int n7 = 0;
                    if (byArray2 != null && byArray3 != null) {
                        n6 = Math.min(byArray2.length, 64);
                        n7 = Math.min(byArray3.length, 64);
                        byArray = new byte[128];
                        System.arraycopy(byArray2, 0, byArray, 0, n6);
                        System.arraycopy(byArray3, 0, byArray, n6, n7);
                    }
                    int n8 = 0;
                    n8 = (n2 & 8) != 0 ? (n8 |= 8) : ((n2 & 0x200000) != 0 || (n2 & 0x8000000) != 0 ? (n8 |= 4) : (n8 |= 1));
                    if ((n2 & 0x100) != 0) {
                        n8 |= 0x100;
                    }
                    if ((n2 & 0x200) != 0) {
                        n8 |= 0x200;
                    }
                    if ((n2 & 0x400) != 0) {
                        n8 |= 0x400;
                    }
                    if ((n2 & 0x10000) != 0) {
                        n8 |= 0x10000;
                    }
                    t4CConnection.needLine();
                    t4CTTIOtxse.doOTXSE(1, null, byArray, xid.getFormatId(), n6, n7, this.timeout, n8, this.applicationValueArr);
                    this.applicationValueArr[0] = t4CTTIOtxse.getApplicationValue();
                    byte[] byArray4 = t4CTTIOtxse.getContext();
                    if (byArray4 != null) {
                        this.context = byArray4;
                    }
                    n4 = 0;
                    t4CConnection.currentlyInTransaction = true;
                }
                catch (IOException iOException) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
                }
            }
            catch (SQLException sQLException) {
                n4 = sQLException.getErrorCode();
                if (n4 == 0) {
                    throw new XAException(-6);
                }
                throw sQLException;
            }
            int n9 = n4;
            return n9;
        }
    }

    @Override
    protected int doEnd(Xid xid, int n2, boolean bl) throws XAException, SQLException {
        T4CConnection t4CConnection = this.connection instanceof ReplayableConnection ? (T4CConnection)((_Proxy_)((Object)this.connection))._getDelegate_() : (T4CConnection)this.connection;
        try (Monitor.CloseableLock closeableLock = t4CConnection.acquireCloseableLock();){
            int n3;
            int n4;
            byte[] byArray;
            T4CTTIOtxse t4CTTIOtxse;
            int n5;
            block18: {
                n5 = -1;
                t4CTTIOtxse = t4CConnection.otxse;
                byArray = null;
                byte[] byArray2 = xid.getGlobalTransactionId();
                byte[] byArray3 = xid.getBranchQualifier();
                n4 = 0;
                n3 = 0;
                if (byArray2 != null && byArray3 != null) {
                    n4 = Math.min(byArray2.length, 64);
                    n3 = Math.min(byArray3.length, 64);
                    byArray = new byte[128];
                    System.arraycopy(byArray2, 0, byArray, 0, n4);
                    System.arraycopy(byArray3, 0, byArray, n4, n3);
                }
                if (this.context != null || (n5 = this.doStart(xid, 0x8000000)) == 0) break block18;
                int n6 = n5;
                return n6;
            }
            try {
                try {
                    byte[] byArray4 = this.context;
                    int n7 = 0;
                    if ((n2 & 2) == 2) {
                        n7 = 0x100000;
                    } else if ((n2 & 0x2000000) == 0x2000000 && (n2 & 0x100000) != 0x100000) {
                        n7 = 0x100000;
                    }
                    this.applicationValueArr[0] = this.applicationValueArr[0] >> 16;
                    t4CConnection.needLine();
                    t4CTTIOtxse.doOTXSE(2, byArray4, byArray, xid.getFormatId(), n4, n3, this.timeout, n7, this.applicationValueArr);
                    this.applicationValueArr[0] = t4CTTIOtxse.getApplicationValue();
                    byte[] byArray5 = t4CTTIOtxse.getContext();
                    if (byArray5 != null) {
                        this.context = byArray5;
                    }
                    n5 = 0;
                    t4CConnection.currentlyInTransaction = false;
                }
                catch (IOException iOException) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
                }
            }
            catch (SQLException sQLException) {
                n5 = sQLException.getErrorCode();
                if (n5 == 0) {
                    throw new XAException(-6);
                }
                throw sQLException;
            }
            int n8 = n5;
            return n8;
        }
    }

    @Override
    protected void doCommit(Xid xid, boolean bl) throws SQLException, XAException {
        block22: {
            T4CConnection t4CConnection = this.connection instanceof ReplayableConnection ? (T4CConnection)((_Proxy_)((Object)this.connection))._getDelegate_() : (T4CConnection)this.connection;
            try (Monitor.CloseableLock closeableLock = t4CConnection.acquireCloseableLock();){
                int n2 = bl ? 4 : 2;
                try {
                    int n3 = this.doTransaction(xid, 1, n2);
                    if ((!bl || n3 != 2 && n3 != 4) && (bl || n3 != 5)) {
                        if (n3 == 8) {
                            throw new XAException(106);
                        }
                        throw new XAException(-6);
                    }
                    t4CConnection.currentlyInTransaction = false;
                }
                catch (SQLException sQLException) {
                    int n4 = sQLException.getErrorCode();
                    if (n4 == 24756) {
                        this.kputxrec(xid, 1, this.timeout + 120, sQLException);
                        break block22;
                    }
                    if (n4 == 24780) {
                        OracleXADataSource oracleXADataSource = null;
                        PooledConnection pooledConnection = null;
                        try {
                            oracleXADataSource = new OracleXADataSource();
                            oracleXADataSource.setURL(t4CConnection.url);
                            oracleXADataSource.setUser(t4CConnection.userName);
                            t4CConnection.getPasswordInternal(this);
                            oracleXADataSource.setPassword(this.password.get());
                            pooledConnection = oracleXADataSource.getXAConnection();
                            XAResource xAResource = pooledConnection.getXAResource();
                            xAResource.commit(xid, bl);
                            t4CConnection.currentlyInTransaction = false;
                            break block22;
                        }
                        catch (SQLException sQLException2) {
                            XAException xAException = new XAException(-6);
                            xAException.initCause(sQLException2);
                            throw xAException;
                        }
                        finally {
                            try {
                                if (pooledConnection != null) {
                                    pooledConnection.close();
                                }
                            }
                            catch (Exception exception) {}
                        }
                    }
                    throw sQLException;
                }
            }
        }
    }

    @Override
    protected int doPrepare(Xid xid) throws XAException, SQLException {
        T4CConnection t4CConnection = this.connection instanceof ReplayableConnection ? (T4CConnection)((_Proxy_)((Object)this.connection))._getDelegate_() : (T4CConnection)this.connection;
        try (Monitor.CloseableLock closeableLock = t4CConnection.acquireCloseableLock();){
            int n2;
            int n3;
            block13: {
                n3 = -1;
                try {
                    n2 = this.doTransaction(xid, 3, 0);
                    if (n2 == 8) {
                        throw new XAException(106);
                    }
                    if (n2 == 4) {
                        n3 = 3;
                        break block13;
                    }
                    if (n2 == 1) {
                        n3 = 0;
                        break block13;
                    }
                    if (n2 == 3) {
                        throw new XAException(100);
                    }
                    throw new XAException(-6);
                }
                catch (SQLException sQLException) {
                    int n4 = sQLException.getErrorCode();
                    if (n4 == 25351) {
                        XAException xAException = new XAException(-6);
                        xAException.initCause(sQLException);
                        throw xAException;
                    }
                    throw sQLException;
                }
            }
            n2 = n3;
            return n2;
        }
    }

    @Override
    protected int doForget(Xid xid) throws XAException, SQLException {
        T4CConnection t4CConnection = this.connection instanceof ReplayableConnection ? (T4CConnection)((_Proxy_)((Object)this.connection))._getDelegate_() : (T4CConnection)this.connection;
        try (Monitor.CloseableLock closeableLock = t4CConnection.acquireCloseableLock();){
            int n2;
            int n3 = 0;
            SQLException sQLException = null;
            if (OracleXid.isLocalTransaction(xid)) {
                int n4 = 24771;
                return n4;
            }
            try {
                n2 = this.doStart(xid, 0x8000000);
            }
            catch (SQLException sQLException2) {
                n2 = sQLException2.getErrorCode();
                sQLException = sQLException2;
            }
            if (n2 != 24756) {
                if (n2 == 0) {
                    try {
                        this.doEnd(xid, 0, false);
                    }
                    catch (Exception exception) {
                    }
                }
                if (n2 == 0 || n2 == 2079 || n2 == 24754 || n2 == 24761 || n2 == 24774 || n2 == 24776 || n2 == 25351) {
                    this.checkError(24769, sQLException);
                } else if (n2 == 24752) {
                    this.checkError(24771, sQLException);
                } else {
                    this.checkError(n2, sQLException);
                }
                int n5 = n3;
                return n5;
            }
            this.kputxrec(xid, 4, 1, null);
            int n6 = n3;
            return n6;
        }
    }

    @Override
    protected void doRollback(Xid xid) throws XAException, SQLException {
        block23: {
            T4CConnection t4CConnection = this.connection instanceof ReplayableConnection ? (T4CConnection)((_Proxy_)((Object)this.connection))._getDelegate_() : (T4CConnection)this.connection;
            try (Monitor.CloseableLock closeableLock = t4CConnection.acquireCloseableLock();){
                try {
                    int n2 = this.doTransaction(xid, 2, 3);
                    if (n2 == 8) {
                        throw new XAException(106);
                    }
                    if (n2 != 3) {
                        throw new XAException(-6);
                    }
                    t4CConnection.currentlyInTransaction = false;
                }
                catch (SQLException sQLException) {
                    int n3 = sQLException.getErrorCode();
                    if (n3 == 24756) {
                        this.kputxrec(xid, 2, this.timeout + 120, sQLException);
                        break block23;
                    }
                    if (n3 == 24780) {
                        OracleXADataSource oracleXADataSource = null;
                        PooledConnection pooledConnection = null;
                        try {
                            oracleXADataSource = new OracleXADataSource();
                            oracleXADataSource.setURL(t4CConnection.url);
                            oracleXADataSource.setUser(t4CConnection.userName);
                            t4CConnection.getPasswordInternal(this);
                            oracleXADataSource.setPassword(this.password.get());
                            pooledConnection = oracleXADataSource.getXAConnection();
                            XAResource xAResource = pooledConnection.getXAResource();
                            xAResource.rollback(xid);
                            t4CConnection.currentlyInTransaction = false;
                            break block23;
                        }
                        catch (SQLException sQLException2) {
                            XAException xAException = new XAException(-6);
                            xAException.initCause(sQLException2);
                            throw xAException;
                        }
                        finally {
                            try {
                                if (pooledConnection != null) {
                                    pooledConnection.close();
                                }
                            }
                            catch (Exception exception) {}
                        }
                    }
                    if (n3 == 25402) {
                        break block23;
                    }
                    throw sQLException;
                }
            }
        }
    }

    int doTransaction(Xid xid, int n2, int n3) throws SQLException {
        T4CConnection t4CConnection = this.connection instanceof ReplayableConnection ? (T4CConnection)((_Proxy_)((Object)this.connection))._getDelegate_() : (T4CConnection)this.connection;
        int n4 = -1;
        try {
            T4CTTIOtxen t4CTTIOtxen = t4CConnection.otxen;
            byte[] byArray = null;
            byte[] byArray2 = xid.getGlobalTransactionId();
            byte[] byArray3 = xid.getBranchQualifier();
            int n5 = 0;
            int n6 = 0;
            if (byArray2 != null && byArray3 != null) {
                n5 = Math.min(byArray2.length, 64);
                n6 = Math.min(byArray3.length, 64);
                byArray = new byte[128];
                System.arraycopy(byArray2, 0, byArray, 0, n5);
                System.arraycopy(byArray3, 0, byArray, n5, n6);
            }
            byte[] byArray4 = this.context;
            t4CConnection.needLine();
            t4CTTIOtxen.doOTXEN(n2, byArray4, byArray, xid.getFormatId(), n5, n6, this.timeout, n3, 0);
            n4 = t4CTTIOtxen.getOutStateFromServer();
        }
        catch (IOException iOException) {
            t4CConnection.handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
        return n4;
    }

    protected void kputxrec(Xid xid, int n2, int n3, SQLException sQLException) throws XAException, SQLException {
        int n4;
        int n5;
        T4CConnection t4CConnection = this.connection instanceof ReplayableConnection ? (T4CConnection)((_Proxy_)((Object)this.connection))._getDelegate_() : (T4CConnection)this.connection;
        switch (n2) {
            case 1: {
                n5 = 3;
                break;
            }
            case 4: {
                n5 = 2;
                break;
            }
            default: {
                n5 = 0;
            }
        }
        int n6 = 0;
        while (n3-- > 0 && (n6 = this.doTransaction(xid, 5, n5)) == 7) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        if (n6 == 7) {
            throw new XAException(-6);
        }
        int n7 = -1;
        switch (n6) {
            case 3: {
                if (n2 == 1) {
                    n4 = 7;
                    break;
                }
                n4 = 8;
                n7 = -3;
                break;
            }
            case 0: {
                if (n2 == 4) {
                    n4 = 8;
                    n7 = -3;
                    break;
                }
                n4 = 7;
                if (n2 != 1) break;
                n7 = -4;
                break;
            }
            case 2: {
                if (n2 == 4) {
                    n4 = 8;
                    n7 = -6;
                    break;
                }
            }
            case 5: {
                if (n2 == 4) {
                    n4 = 7;
                    break;
                }
                n7 = 7;
                n4 = 8;
                break;
            }
            case 4: {
                if (n2 == 4) {
                    n4 = 7;
                    break;
                }
                n7 = 6;
                n4 = 8;
                break;
            }
            case 6: {
                if (n2 == 4) {
                    n4 = 7;
                    break;
                }
                n7 = 5;
                n4 = 8;
                break;
            }
            default: {
                n7 = -3;
                n4 = 8;
            }
        }
        T4CTTIk2rpc t4CTTIk2rpc = t4CConnection.k2rpc;
        try {
            t4CTTIk2rpc.doOK2RPC(3, n4);
        }
        catch (IOException iOException) {
            XAException xAException = new XAException(-7);
            xAException.initCause(iOException);
            throw xAException;
        }
        catch (SQLException sQLException2) {
            XAException xAException = new XAException(-6);
            xAException.initCause(sQLException2);
            throw xAException;
        }
        if (n7 != -1) {
            OracleXAException oracleXAException = null;
            if (sQLException != null) {
                oracleXAException = new OracleXAException(sQLException.getErrorCode(), n7);
                oracleXAException.initCause(sQLException);
            } else {
                oracleXAException = new OracleXAException(0, n7);
            }
            throw oracleXAException;
        }
    }

    final void setPasswordInternal(OpaqueString opaqueString) {
        this.password = opaqueString;
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return (OracleConnection)this.connection;
    }

    @Override
    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }
}

