/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.InternalFactory;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.internal.XSAttribute;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
final class XSAttributeI
extends XSAttribute {
    String attributeName = null;
    byte[] attributeNameBytes;
    String attributeValue = null;
    byte[] attributeValueBytes;
    String attributeDefaultValue = null;
    byte[] attributeDefaultValueBytes;
    long flag = 0L;

    XSAttributeI() {
    }

    @Override
    public void setAttributeName(String string) throws SQLException {
        InternalFactory.xsSecurityCheck();
        this.attributeName = string;
    }

    void doCharConversion(DBConversion dBConversion) throws SQLException {
        this.attributeNameBytes = (byte[])(this.attributeName != null ? dBConversion.StringToCharBytes(this.attributeName) : null);
        this.attributeValueBytes = (byte[])(this.attributeValue != null ? dBConversion.StringToCharBytes(this.attributeValue) : null);
        this.attributeDefaultValueBytes = (byte[])(this.attributeDefaultValue != null ? dBConversion.StringToCharBytes(this.attributeDefaultValue) : null);
    }

    @Override
    public void setAttributeValue(String string) throws SQLException {
        InternalFactory.xsSecurityCheck();
        this.attributeValue = string;
    }

    @Override
    public void setAttributeDefaultValue(String string) throws SQLException {
        InternalFactory.xsSecurityCheck();
        this.attributeDefaultValue = string;
    }

    @Override
    public void setFlag(long l2) throws SQLException {
        InternalFactory.xsSecurityCheck();
        this.flag = l2;
    }

    @Override
    public String getAttributeName() {
        InternalFactory.xsSecurityCheck();
        return this.attributeName;
    }

    @Override
    public String getAttributeValue() {
        InternalFactory.xsSecurityCheck();
        return this.attributeValue;
    }

    @Override
    public String getAttributeDefaultValue() {
        InternalFactory.xsSecurityCheck();
        return this.attributeDefaultValue;
    }

    @Override
    public long getFlag() {
        InternalFactory.xsSecurityCheck();
        return this.flag;
    }

    void marshal(T4CMAREngine t4CMAREngine) throws IOException {
        if (this.attributeNameBytes != null) {
            t4CMAREngine.marshalUB4(this.attributeNameBytes.length);
            t4CMAREngine.marshalCLR(this.attributeNameBytes, this.attributeNameBytes.length);
        } else {
            t4CMAREngine.marshalUB4(0L);
        }
        if (this.attributeValueBytes != null) {
            t4CMAREngine.marshalUB4(this.attributeValueBytes.length);
            t4CMAREngine.marshalCLR(this.attributeValueBytes, this.attributeValueBytes.length);
        } else {
            t4CMAREngine.marshalUB4(0L);
        }
        if (this.attributeDefaultValueBytes != null) {
            t4CMAREngine.marshalUB4(this.attributeDefaultValueBytes.length);
            t4CMAREngine.marshalCLR(this.attributeDefaultValueBytes, this.attributeDefaultValueBytes.length);
        } else {
            t4CMAREngine.marshalUB4(0L);
        }
        t4CMAREngine.marshalUB4(this.flag);
    }

    static XSAttributeI unmarshal(T4CMAREngine t4CMAREngine) throws SQLException, IOException {
        Object object;
        int n2;
        int n3;
        int[] nArray = new int[1];
        String string = null;
        String string2 = null;
        String string3 = null;
        int n4 = (int)t4CMAREngine.unmarshalUB4();
        if (n4 > 0) {
            byte[] byArray = new byte[n4];
            t4CMAREngine.unmarshalCLR(byArray, 0, nArray);
            string = t4CMAREngine.conv.CharBytesToString(byArray, nArray[0]);
        }
        if ((n3 = (int)t4CMAREngine.unmarshalUB4()) > 0) {
            byte[] byArray = new byte[n3];
            t4CMAREngine.unmarshalCLR(byArray, 0, nArray);
            string2 = t4CMAREngine.conv.CharBytesToString(byArray, nArray[0]);
        }
        if ((n2 = (int)t4CMAREngine.unmarshalUB4()) > 0) {
            object = new byte[n2];
            t4CMAREngine.unmarshalCLR((byte[])object, 0, nArray);
            string3 = t4CMAREngine.conv.CharBytesToString((byte[])object, nArray[0]);
        }
        long l2 = t4CMAREngine.unmarshalUB4();
        object = new XSAttributeI();
        ((XSAttributeI)object).setAttributeName(string);
        ((XSAttributeI)object).setAttributeValue(string2);
        ((XSAttributeI)object).setAttributeDefaultValue(string3);
        ((XSAttributeI)object).setFlag(l2);
        return object;
    }
}

