/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import oracle.sql.Datum;

class SINT32
extends Datum {
    boolean isBigEndian;

    private SINT32() {
    }

    private SINT32(byte[] byArray, boolean bl) {
        this.setBytes(byArray);
        this.isBigEndian = bl;
    }

    public boolean isConvertibleTo(Class clazz) {
        return false;
    }

    @Override
    public Object toJdbc() {
        return SINT32.bytesToInt(this.shareBytes(), this.isBigEndian);
    }

    @Override
    public Object makeJdbcArray(int n2) {
        return new SINT32[n2];
    }

    static SINT32[] createArray(int n2) {
        return new SINT32[n2];
    }

    static int bytesToInt(byte[] byArray, boolean bl) {
        int n2 = 0;
        int n3 = bl ? 0 : byArray.length - 1;
        for (byte by : byArray) {
            n2 |= (by & 0xFF) << n3 * 8;
            n3 += bl ? 1 : -1;
        }
        return n2;
    }

    static SINT32 valueOf(int n2, boolean bl) {
        byte[] byArray = new byte[4];
        int n3 = bl ? 0 : byArray.length - 1;
        for (int i2 = 0; i2 < 4; ++i2) {
            byArray[i2] = (byte)(n2 >> n3 * 8 & 0xFF);
            n3 += bl ? 1 : -1;
        }
        return new SINT32(byArray, bl);
    }
}

